/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Light;
import artofillusion.raytracer.RTLight;
import artofillusion.raytracer.Ray;

public class RTDirectionalLight
extends RTLight {
    private final double radius;

    public RTDirectionalLight(DirectionalLight light, CoordinateSystem coords, boolean softShadows) {
        super((Light)light, coords);
        this.radius = softShadows ? Math.tan(light.getRadius() * Math.PI / 180.0) : 0.0;
    }

    public double findRayToLight(Vec3 origin, Ray ray, int rayNumber) {
        ray.getOrigin().set(origin);
        Vec3 dir = ray.getDirection();
        dir.set(this.getCoords().getZDirection());
        dir.scale(-1.0);
        if (rayNumber != -1) {
            ray.rt.rt.randomizePoint(dir, ray.rt.random, this.radius, rayNumber);
            dir.normalize();
        }
        return Double.MAX_VALUE;
    }
}

