/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Cube;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.SurfaceIntersection;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformMapping;

public class RTCube
extends RTObject {
    private Cube theCube;
    protected double minx;
    protected double miny;
    protected double minz;
    protected double maxx;
    protected double maxy;
    protected double maxz;
    protected double[] param;
    private boolean bumpMapped;
    private boolean transform;
    protected Mat4 toLocal;
    protected Mat4 fromLocal;
    public static final double TOL = 1.0E-12;

    public RTCube(Cube cube, Mat4 fromLocal, Mat4 toLocal, double[] param) {
        Vec3 size = cube.getBounds().getSize();
        Vec3 vx = toLocal.timesDirection(Vec3.vx());
        Vec3 vy = toLocal.timesDirection(Vec3.vy());
        this.theCube = cube;
        this.param = param;
        double xsize = size.x;
        double ysize = size.y;
        double zsize = size.z;
        this.transform = true;
        if (vx.x == 1.0 || vx.x == -1.0) {
            if (vy.y == 1.0 || vy.y == -1.0) {
                this.transform = false;
            } else if (vy.z == 1.0 || vy.z == -1.0) {
                ysize = size.z;
                zsize = size.y;
                this.transform = false;
            }
        } else if (vx.y == 1.0 || vx.y == -1.0) {
            if (vy.x == 1.0 || vy.x == -1.0) {
                xsize = size.y;
                ysize = size.x;
                this.transform = false;
            } else if (vy.z == 1.0 || vy.z == -1.0) {
                xsize = size.y;
                ysize = size.z;
                zsize = size.x;
                this.transform = false;
            }
        } else if (vx.z == 1.0 || vx.z == -1.0) {
            if (vy.x == 1.0 || vy.x == -1.0) {
                xsize = size.z;
                ysize = size.x;
                zsize = size.y;
                this.transform = false;
            } else if (vy.y == 1.0 || vy.y == -1.0) {
                xsize = size.z;
                zsize = size.x;
                this.transform = false;
            }
        }
        if (this.transform) {
            this.fromLocal = fromLocal;
            this.minx = -0.5 * xsize;
            this.miny = -0.5 * ysize;
            this.minz = -0.5 * zsize;
            this.maxx = 0.5 * xsize;
            this.maxy = 0.5 * ysize;
            this.maxz = 0.5 * zsize;
        } else {
            Vec3 center = fromLocal.times(new Vec3());
            this.minx = center.x - 0.5 * xsize;
            this.miny = center.y - 0.5 * ysize;
            this.minz = center.z - 0.5 * zsize;
            this.maxx = center.x + 0.5 * xsize;
            this.maxy = center.y + 0.5 * ysize;
            this.maxz = center.z + 0.5 * zsize;
        }
        this.bumpMapped = cube.getTexture().hasComponent(5);
        this.toLocal = toLocal;
    }

    public final TextureMapping getTextureMapping() {
        return this.theCube.getTextureMapping();
    }

    public final MaterialMapping getMaterialMapping() {
        return this.theCube.getMaterialMapping();
    }

    public SurfaceIntersection checkIntersection(Ray r) {
        int numIntersections;
        double t2;
        double t1;
        Vec3 direction;
        Vec3 origin;
        Vec3 rorig = r.getOrigin();
        Vec3 rdir = r.getDirection();
        if (this.transform) {
            origin = r.tempVec1;
            origin.set(rorig);
            this.toLocal.transform(origin);
            direction = r.tempVec2;
            direction.set(rdir);
            this.toLocal.transformDirection(direction);
        } else {
            origin = rorig;
            direction = rdir;
        }
        double mint = -1.7976931348623157E308;
        double maxt = Double.MAX_VALUE;
        if (direction.x == 0.0) {
            if (origin.x < this.minx || origin.x > this.maxx) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
        } else {
            t1 = (this.minx - origin.x) / direction.x;
            t2 = (this.maxx - origin.x) / direction.x;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 1.0E-12) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
        }
        if (direction.y == 0.0) {
            if (origin.y < this.miny || origin.y > this.maxy) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
        } else {
            t1 = (this.miny - origin.y) / direction.y;
            t2 = (this.maxy - origin.y) / direction.y;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 1.0E-12) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
        }
        if (direction.z == 0.0) {
            if (origin.z < this.minz || origin.z > this.maxz) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
        } else {
            t1 = (this.minz - origin.z) / direction.z;
            t2 = (this.maxz - origin.z) / direction.z;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 1.0E-12) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
        }
        Vec3 v1 = r.tempVec1;
        Vec3 v2 = r.tempVec2;
        Vec3 trueNorm = r.tempVec3;
        if (mint < 1.0E-12) {
            v1.set(rorig.x + maxt * rdir.x, rorig.y + maxt * rdir.y, rorig.z + maxt * rdir.z);
            mint = maxt;
            numIntersections = 1;
        } else {
            v2.set(rorig.x + maxt * rdir.x, rorig.y + maxt * rdir.y, rorig.z + maxt * rdir.z);
            this.projectPoint(v2, null);
            v1.set(rorig.x + mint * rdir.x, rorig.y + mint * rdir.y, rorig.z + mint * rdir.z);
            numIntersections = 2;
        }
        this.projectPoint(v1, trueNorm);
        return new CubeIntersection(this, numIntersections, v1, v2, mint, maxt, trueNorm);
    }

    private void projectPoint(Vec3 pos, Vec3 normal) {
        if (this.transform) {
            this.toLocal.transform(pos);
        }
        int side = 0;
        double mindist = Math.abs(pos.x - this.minx);
        double dist = Math.abs(pos.x - this.maxx);
        if (dist < mindist) {
            mindist = dist;
            side = 1;
        }
        if ((dist = Math.abs(pos.y - this.miny)) < mindist) {
            mindist = dist;
            side = 2;
        }
        if ((dist = Math.abs(pos.y - this.maxy)) < mindist) {
            mindist = dist;
            side = 3;
        }
        if ((dist = Math.abs(pos.z - this.minz)) < mindist) {
            mindist = dist;
            side = 4;
        }
        if ((dist = Math.abs(pos.z - this.maxz)) < mindist) {
            mindist = dist;
            side = 5;
        }
        if (side == 0) {
            pos.x = this.minx;
        } else if (side == 1) {
            pos.x = this.maxx;
        } else if (side == 2) {
            pos.y = this.miny;
        } else if (side == 3) {
            pos.y = this.maxy;
        } else if (side == 4) {
            pos.z = this.minz;
        } else if (side == 5) {
            pos.z = this.maxz;
        }
        if (this.transform) {
            this.fromLocal.transform(pos);
        }
        if (normal != null) {
            if (side == 0) {
                normal.set(-1.0, 0.0, 0.0);
            }
            if (side == 1) {
                normal.set(1.0, 0.0, 0.0);
            }
            if (side == 2) {
                normal.set(0.0, -1.0, 0.0);
            }
            if (side == 3) {
                normal.set(0.0, 1.0, 0.0);
            }
            if (side == 4) {
                normal.set(0.0, 0.0, -1.0);
            }
            if (side == 5) {
                normal.set(0.0, 0.0, 1.0);
            }
            if (this.transform) {
                this.fromLocal.transformDirection(normal);
            }
        }
    }

    public BoundingBox getBounds() {
        BoundingBox bounds = new BoundingBox(this.minx, this.maxx, this.miny, this.maxy, this.minz, this.maxz);
        if (this.transform) {
            bounds = bounds.transformAndOutset(this.fromLocal);
        }
        return bounds;
    }

    public boolean intersectsBox(BoundingBox bb) {
        if (!bb.intersects(this.getBounds())) {
            return false;
        }
        if (this.transform) {
            bb = bb.transformAndOutset(this.toLocal);
        }
        return !(bb.minx > this.minx) || !(bb.maxx < this.maxx) || !(bb.miny > this.miny) || !(bb.maxy < this.maxy) || !(bb.minz > this.minz) || !(bb.maxz < this.maxz);
    }

    public Mat4 toLocal() {
        return this.toLocal;
    }

    private static class CubeIntersection
    implements SurfaceIntersection {
        private RTCube cube;
        private int numIntersections;
        private double dist1;
        private double dist2;
        private double r1x;
        private double r1y;
        private double r1z;
        private double r2x;
        private double r2y;
        private double r2z;
        private double normx;
        private double normy;
        private double normz;
        private Vec3 pos;

        public CubeIntersection(RTCube cube, int numIntersections, Vec3 point1, Vec3 point2, double dist1, double dist2, Vec3 trueNorm) {
            this.cube = cube;
            this.numIntersections = numIntersections;
            this.dist1 = dist1;
            this.dist2 = dist2;
            this.r1x = point1.x;
            this.r1y = point1.y;
            this.r1z = point1.z;
            this.r2x = point2.x;
            this.r2y = point2.y;
            this.r2z = point2.z;
            this.normx = trueNorm.x;
            this.normy = trueNorm.y;
            this.normz = trueNorm.z;
            this.pos = new Vec3();
        }

        public int numIntersections() {
            return this.numIntersections;
        }

        public void intersectionPoint(int n, Vec3 p) {
            if (n == 0) {
                p.set(this.r1x, this.r1y, this.r1z);
            } else {
                p.set(this.r2x, this.r2y, this.r2z);
            }
        }

        public double intersectionDist(int n) {
            if (n == 0) {
                return this.dist1;
            }
            return this.dist2;
        }

        public void intersectionProperties(TextureSpec spec, Vec3 n, Vec3 viewDir, double size, double time) {
            n.set(this.normx, this.normy, this.normz);
            TextureMapping map = this.cube.theCube.getTextureMapping();
            this.pos.set(this.r1x, this.r1y, this.r1z);
            if (map instanceof UniformMapping) {
                map.getTextureSpec(this.pos, spec, -n.dot(viewDir), size, time, this.cube.param);
            } else {
                this.cube.toLocal.transform(this.pos);
                map.getTextureSpec(this.pos, spec, -n.dot(viewDir), size, time, this.cube.param);
            }
            if (this.cube.bumpMapped) {
                if (this.cube.transform) {
                    this.cube.fromLocal.transformDirection(spec.bumpGrad);
                }
                n.scale(spec.bumpGrad.dot(n) + 1.0);
                n.subtract(spec.bumpGrad);
                n.normalize();
            }
        }

        public void intersectionTransparency(int n, RGBColor trans, double angle, double size, double time) {
            TextureMapping map = this.cube.theCube.getTextureMapping();
            if (n == 0) {
                this.pos.set(this.r1x, this.r1y, this.r1z);
            } else {
                this.pos.set(this.r2x, this.r2y, this.r2z);
            }
            if (map instanceof UniformMapping) {
                map.getTransparency(this.pos, trans, angle, size, time, this.cube.param);
            } else {
                this.cube.toLocal.transform(this.pos);
                map.getTransparency(this.pos, trans, angle, size, time, this.cube.param);
            }
        }

        public void trueNormal(Vec3 n) {
            n.set(this.normx, this.normy, this.normz);
        }
    }
}

