/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.raytracer.Photon;

public class PhotonList {
    public Photon[] photon;
    public float[] dist2;
    public float cutoff2;
    public int numFound;

    public PhotonList(int size) {
        this.photon = new Photon[size];
        this.dist2 = new float[size];
    }

    public final void init(float cutoff2) {
        this.cutoff2 = cutoff2;
        this.numFound = 0;
    }

    public final void addPhoton(Photon p, float sqDist) {
        int child;
        if (this.numFound < this.photon.length) {
            this.photon[this.numFound] = p;
            this.dist2[this.numFound++] = sqDist;
            if (this.numFound == this.photon.length) {
                this.buildHeap();
            }
            return;
        }
        int pos = 0;
        while ((child = (pos << 1) + 1) < this.dist2.length) {
            int child2 = child + 1;
            if (child2 < this.dist2.length && this.dist2[child] < this.dist2[child2]) {
                child = child2;
            }
            if (this.dist2[child] <= sqDist) break;
            this.photon[pos] = this.photon[child];
            this.dist2[pos] = this.dist2[child];
            pos = child;
        }
        this.photon[pos] = p;
        this.dist2[pos] = sqDist;
        this.cutoff2 = this.dist2[0];
    }

    private void buildHeap() {
        int half;
        for (int i = half = (this.dist2.length >> 1) - 1; i >= 0; --i) {
            int parent = i;
            Photon p = this.photon[i];
            float d = this.dist2[i];
            while (parent <= half) {
                int j = (parent << 1) + 1;
                if (j + 1 < this.dist2.length && this.dist2[j] < this.dist2[j + 1]) {
                    ++j;
                }
                if (d >= this.dist2[j]) break;
                this.dist2[parent] = this.dist2[j];
                this.photon[parent] = this.photon[j];
                parent = j;
            }
            this.dist2[parent] = d;
            this.photon[parent] = p;
        }
    }
}

