/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;

public class Photon {
    public float x;
    public float y;
    public float z;
    public int ergb;
    public short direction;
    public short axis;

    public Photon(Vec3 pos, Vec3 dir, RGBColor color) {
        this.x = (float)pos.x;
        this.y = (float)pos.y;
        this.z = (float)pos.z;
        int phi = (int)(Math.atan2(dir.z, dir.x) * 128.0 / Math.PI);
        if (phi < 0) {
            phi += 256;
        }
        int theta = (int)(Math.acos(dir.y) * 256.0 / Math.PI);
        this.direction = (short)((phi << 8) + theta);
        this.ergb = color.getERGB();
    }
}

