/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.Scene;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.raytracer.PhotonMap;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.Raytracer;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.util.ThreadManager;

public class EnvironmentPhotonSource
implements PhotonSource {
    private Vec3 center;
    private RGBColor color;
    private TextureMapping envMapping;
    private int envMode;
    private float lightIntensity;
    private double radius;

    public EnvironmentPhotonSource(Scene scene, PhotonMap map) {
        this.center = map.getBounds().getCenter();
        Vec3[] corner = map.getBounds().getCorners();
        double maxDist2 = 0.0;
        for (int i = 0; i < corner.length; ++i) {
            double dist2 = this.center.distance2(corner[i]);
            if (!(dist2 > maxDist2)) continue;
            maxDist2 = dist2;
        }
        this.radius = Math.sqrt(maxDist2);
        this.envMode = scene.getEnvironmentMode();
        this.color = new RGBColor();
        if (this.envMode == 0) {
            this.color.copy(scene.getEnvironmentColor());
        } else {
            TextureSpec spec = new TextureSpec();
            this.envMapping = scene.getEnvironmentMapping();
            this.envMapping.getTexture().getAverageSpec(spec, scene.getTime(), null);
            if (this.envMode == 1) {
                this.color.copy(spec.diffuse);
            } else {
                this.color.copy(spec.emissive);
            }
        }
        this.lightIntensity = this.color.getRed() + this.color.getGreen() + this.color.getBlue();
        if (this.lightIntensity == 0.0f) {
            return;
        }
        this.color.scale(1.0f / this.lightIntensity);
        this.lightIntensity *= (float)(Math.PI * 4 * this.radius * this.radius);
    }

    public double getTotalIntensity() {
        return this.lightIntensity;
    }

    public void generatePhotons(final PhotonMap map, final double intensity, final ThreadManager threads) {
        final Thread currentThread = Thread.currentThread();
        final Raytracer rt = map.getRaytracer();
        final double[] emittedIntensity = new double[]{0.0};
        threads.setNumIndices(1024);
        threads.setTask(new ThreadManager.Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(int index) {
                double photonIntensity;
                double dot;
                if (rt.renderThread != currentThread) {
                    return;
                }
                double ctheta = ((double)((index & 3) - 2) + map.random.nextDouble()) * 0.5;
                double stheta = Math.sqrt(1.0 - ctheta * ctheta);
                double phi = ((double)(index >> 2 & 3) + map.random.nextDouble()) * 0.5 * Math.PI;
                double sphi = Math.sin(phi);
                double cphi = Math.cos(phi);
                Ray r = new Ray(map.getContext());
                Vec3 orig = r.getOrigin();
                Vec3 dir = r.getDirection();
                orig.set(stheta * sphi, stheta * cphi, ctheta);
                do {
                    dir.set(0.0, 0.0, 0.0);
                    map.randomizePoint(dir, 1.0);
                    dir.normalize();
                    dot = orig.dot(dir);
                    if (dot > 0.0) {
                        dir.scale(-1.0);
                        continue;
                    }
                    dot = -dot;
                } while (dot < map.random.nextDouble());
                orig.scale(EnvironmentPhotonSource.this.radius);
                orig.add(EnvironmentPhotonSource.this.center);
                if (EnvironmentPhotonSource.this.envMode == 1 || EnvironmentPhotonSource.this.envMode == 2) {
                    TextureSpec spec = map.getContext().surfSpec[0];
                    EnvironmentPhotonSource.this.envMapping.getTextureSpec(dir.times(-1.0), spec, 1.0, rt.smoothScale * rt.extraGIEnvSmoothing, rt.time, null);
                    if (EnvironmentPhotonSource.this.envMode == 1) {
                        EnvironmentPhotonSource.this.color.copy(spec.diffuse);
                    } else {
                        EnvironmentPhotonSource.this.color.copy(spec.emissive);
                    }
                    photonIntensity = EnvironmentPhotonSource.this.color.getRed() + EnvironmentPhotonSource.this.color.getGreen() + EnvironmentPhotonSource.this.color.getBlue();
                    if (photonIntensity < 1.0) {
                        if (photonIntensity < (double)map.random.nextFloat()) {
                            return;
                        }
                        EnvironmentPhotonSource.this.color.scale(1.0 / photonIntensity);
                    }
                } else {
                    photonIntensity = 1.0;
                }
                double[] dArray = emittedIntensity;
                synchronized (emittedIntensity) {
                    if (emittedIntensity[0] >= intensity) {
                        threads.cancel();
                        // ** MonitorExit[var19_11] (shouldn't be in output)
                        return;
                    }
                    emittedIntensity[0] = emittedIntensity[0] + photonIntensity;
                    // ** MonitorExit[var19_11] (shouldn't be in output)
                    r.newID();
                    map.spawnPhoton(r, EnvironmentPhotonSource.this.color, true);
                    return;
                }
            }

            public void cleanup() {
                map.getContext().cleanup();
            }
        });
        while (emittedIntensity[0] < intensity) {
            threads.run();
        }
    }
}

