/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.spmanager;

import artofillusion.ArtOfIllusion;
import artofillusion.LayoutWindow;
import artofillusion.Plugin;
import artofillusion.PluginRegistry;
import artofillusion.spmanager.HttpSPMFileSystem;
import artofillusion.spmanager.InstallSplitPane;
import artofillusion.spmanager.SPMObjectInfo;
import artofillusion.spmanager.SPMTranslate;
import artofillusion.spmanager.SPManagerFrame;
import artofillusion.spmanager.StatusDialog;
import artofillusion.ui.Translate;
import artofillusion.util.SearchlistClassLoader;
import buoy.event.CommandEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuItem;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextArea;
import buoy.widget.BTextField;
import buoy.widget.ColumnContainer;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SPManagerPlugin
implements Plugin {
    public static String AOI_VERSION;
    public static String UNIQUE_PATH;
    public static String TEMP_DIR;
    public static String APP_DIRECTORY;
    public static String PLUGIN_DIRECTORY;
    public static String TOOL_SCRIPT_DIRECTORY;
    public static String OBJECT_SCRIPT_DIRECTORY;
    public static String STARTUP_SCRIPT_DIRECTORY;
    public static final int DOWNLOAD = -1;
    private static SPManagerFrame spmFrame;
    protected static HashMap plugins;

    public void processMessage(int message, Object[] args) {
        if (AOI_VERSION == null) {
            AOI_VERSION = ArtOfIllusion.getMajorVersion();
            System.setProperty("artofillusion.version", ArtOfIllusion.getVersion());
            System.setProperty("artofillusion.version.major", ArtOfIllusion.getMajorVersion());
        }
        switch (message) {
            case 0: {
                ClassLoader obj;
                int i;
                SPMTranslate.setLocale(ArtOfIllusion.getPreferences().getLocale());
                APP_DIRECTORY = ArtOfIllusion.APP_DIRECTORY;
                PLUGIN_DIRECTORY = ArtOfIllusion.PLUGIN_DIRECTORY;
                TOOL_SCRIPT_DIRECTORY = ArtOfIllusion.TOOL_SCRIPT_DIRECTORY;
                OBJECT_SCRIPT_DIRECTORY = ArtOfIllusion.OBJECT_SCRIPT_DIRECTORY;
                STARTUP_SCRIPT_DIRECTORY = ArtOfIllusion.STARTUP_SCRIPT_DIRECTORY;
                System.out.println("SPManager starting...");
                ClassLoader ldr = null;
                URLClassLoader urlldr = null;
                SearchlistClassLoader searchldr = null;
                List<ClassLoader> list = PluginRegistry.getPluginClassLoaders();
                HashMap<URL, ClassLoader> loaders = new HashMap<URL, ClassLoader>(list.size());
                for (i = 0; i < list.size(); ++i) {
                    obj = list.get(i);
                    URL[] urlList = obj instanceof URLClassLoader ? ((URLClassLoader)obj).getURLs() : ((SearchlistClassLoader)obj).getURLs();
                    if (urlList.length <= 0) continue;
                    loaders.put(urlList[0], obj);
                }
                URL[] urlarg = new URL[1];
                Class[] sig = new Class[]{URL.class};
                Method addUrl = null;
                try {
                    addUrl = URLClassLoader.class.getDeclaredMethod("addURL", sig);
                    addUrl.setAccessible(true);
                }
                catch (Exception e) {
                    System.out.println("Error getting addURL method: " + e);
                }
                StringBuffer errs = null;
                File plugdir = new File(PLUGIN_DIRECTORY);
                if (plugdir.exists()) {
                    File[] files = plugdir.listFiles();
                    for (i = 0; i < files.length; ++i) {
                        URL url;
                        SPMObjectInfo info = new SPMObjectInfo(files[i].getAbsolutePath());
                        if (info.invalid) {
                            if (errs == null) {
                                errs = new StringBuffer(1024);
                            }
                            if (errs.length() > 0) {
                                errs.append('\n');
                            }
                            errs.append(SPMTranslate.text("pluginFailure", info.getName()));
                        }
                        if (info.actions == null || info.actions.size() <= 0) continue;
                        try {
                            url = files[i].toURI().toURL();
                        }
                        catch (Exception e) {
                            continue;
                        }
                        obj = loaders.get(url);
                        if (obj == null) {
                            System.out.println("SPManager: could not find classloader: " + files[i].getPath());
                            continue;
                        }
                        if (obj instanceof SearchlistClassLoader) {
                            searchldr = (SearchlistClassLoader)obj;
                        } else {
                            urlldr = (URLClassLoader)obj;
                        }
                        for (Map.Entry entry : info.actions.entrySet()) {
                            String[] key = entry.getKey().toString().split(":");
                            try {
                                File urlfile = key[0].startsWith("/") ? new File(APP_DIRECTORY, key[0].substring(1)) : new File(plugdir, key[0]);
                                url = urlfile.toURI().toURL();
                            }
                            catch (Exception e) {
                                System.out.println("Error making url: " + e);
                                continue;
                            }
                            System.out.println("SPM: adding path: " + url);
                            String value = entry.getValue().toString();
                            if ("classpath".equalsIgnoreCase(value)) {
                                if (searchldr != null) {
                                    searchldr.add(url);
                                    continue;
                                }
                                if (addUrl != null) {
                                    try {
                                        addUrl.invoke((Object)urlldr, url);
                                    }
                                    catch (Exception e) {
                                        System.out.println("Error invoking: " + e);
                                    }
                                    continue;
                                }
                                System.out.println("Could not add path" + url);
                                continue;
                            }
                            if (!"import".equalsIgnoreCase(value)) continue;
                            ldr = (ClassLoader)loaders.get(url);
                            if (key.length != 1) continue;
                            if (obj != null) {
                                searchldr.add(ldr);
                                continue;
                            }
                            System.out.println("SPM: could not find loader for: " + url);
                        }
                    }
                    if (errs != null) {
                        BTextArea txt = new BTextArea(5, 45);
                        txt.setEditable(false);
                        txt.append(errs.toString());
                        BScrollPane detail = new BScrollPane(txt, BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_AS_NEEDED);
                        BLabel messg = SPMTranslate.bLabel("loadError");
                        new BStandardDialog("SPManager initialise", new Widget[]{messg, detail}, BStandardDialog.ERROR).showMessageDialog(null);
                    }
                } else {
                    System.out.println("SPManager: could not find plugin dir: " + PLUGIN_DIRECTORY);
                }
                this.init();
                break;
            }
            case 2: {
                LayoutWindow layout = (LayoutWindow)args[0];
                BMenu toolsMenu = layout.getToolsMenu();
                toolsMenu.addSeparator();
                BMenuItem menuItem = SPMTranslate.bMenuItem("SPManager", this, "doMenu");
                toolsMenu.add(menuItem);
                break;
            }
            case 1: {
                break;
            }
            case -1: {
                System.out.println("DOWNLOAD...");
                BFrame frame = (BFrame)args[0];
                URL from = (URL)args[1];
                URL to = (URL)(args.length > 2 ? args[2] : null);
                this.download(frame, from, to);
                break;
            }
        }
    }

    public void init() {
        String path;
        ArrayList<String> err = new ArrayList<String>(8);
        System.out.println("SPManager: java temp dir is " + System.getProperty("java.io.tmpdir"));
        File temp = new File(System.getProperty("java.io.tmpdir"));
        if (!(temp.exists() && temp.isDirectory() || temp.mkdir())) {
            System.out.println("SPManager: could not open/create temp dir: " + temp.getAbsolutePath());
            temp = new File(APP_DIRECTORY, "temp");
        }
        if (!(temp.exists() && temp.isDirectory() || temp.mkdir())) {
            System.out.println("Cannot create temp folder: " + temp.getAbsolutePath());
            temp = new File(System.getProperty("user.dir"), "SPMtemp");
        }
        if (!(temp.exists() && temp.isDirectory() || temp.mkdir())) {
            err.add("Cannot create temp folder: " + temp.getAbsolutePath());
        }
        if (!temp.canWrite()) {
            err.add("Write permission denied to temp folder: " + temp.getAbsolutePath());
        }
        File t = null;
        try {
            t = File.createTempFile("spmanager-temp-" + System.getProperty("user.name") + "-", ".lck", temp);
            t.deleteOnExit();
            path = t.getName();
            path = path.substring(0, path.length() - ".lck".length());
        }
        catch (Exception e) {
            System.out.println("SPManager: could not create temp file: " + t.getAbsolutePath() + e);
            path = System.getProperty("user.name") + "-" + String.valueOf(System.currentTimeMillis());
        }
        temp = new File(temp, path);
        if (!(temp.exists() && temp.isDirectory() || temp.mkdir())) {
            err.add("Cannot create temp folder: " + temp.getAbsolutePath());
        }
        if (!temp.canWrite()) {
            err.add("Write permission denied to temp folder: " + temp.getAbsolutePath());
        }
        TEMP_DIR = temp.getAbsolutePath();
        System.out.println("SPManager: temp dir set to: " + temp.getAbsolutePath());
        File subfolder = new File(PLUGIN_DIRECTORY);
        temp = new File(TEMP_DIR, subfolder.getName());
        if (!temp.exists() && !temp.mkdirs()) {
            err.add("Cannot create temp plugin folder: " + temp.getAbsolutePath());
        }
        if (!(temp = new File(TEMP_DIR, (subfolder = new File(TOOL_SCRIPT_DIRECTORY)).getName())).exists() && !temp.mkdirs()) {
            err.add("Cannot create temp script folder: " + temp.getAbsolutePath());
        }
        if (!(temp = new File(TEMP_DIR, (subfolder = new File(OBJECT_SCRIPT_DIRECTORY)).getName())).exists() && !temp.mkdirs()) {
            err.add("Cannot create temp script folder: " + temp.getAbsolutePath());
        }
        if (!(temp = new File(TEMP_DIR, (subfolder = new File(STARTUP_SCRIPT_DIRECTORY)).getName())).exists() && !temp.mkdirs()) {
            err.add("Cannot create temp script folder: " + temp.getAbsolutePath());
        }
        if (!(temp = new File(PLUGIN_DIRECTORY)).exists() && !temp.mkdir()) {
            err.add("Cannot create missing plugin folder: " + temp.getAbsolutePath());
        }
        if (!(temp = new File(TOOL_SCRIPT_DIRECTORY)).exists() && !temp.mkdirs()) {
            err.add("Cannot create missing script folder: " + temp.getAbsolutePath());
        }
        if (!(temp = new File(OBJECT_SCRIPT_DIRECTORY)).exists() && !temp.mkdirs()) {
            err.add("Cannot create missing script folder: " + temp.getAbsolutePath());
        }
        if (!(temp = new File(STARTUP_SCRIPT_DIRECTORY)).exists() && !temp.mkdirs()) {
            err.add("Cannot create missing script folder: " + temp.getAbsolutePath());
        }
        if (err.size() > 0) {
            BTextArea txt = new BTextArea(5, 45);
            txt.setEditable(false);
            for (int i = 0; i < err.size(); ++i) {
                txt.append(err.get(i) + "\n");
            }
            BScrollPane detail = new BScrollPane(txt, BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_AS_NEEDED);
            BLabel messg = SPMTranslate.bLabel("errMsg");
            new BStandardDialog("SPManager initialise", new Widget[]{messg, detail}, BStandardDialog.WARNING).showMessageDialog(null);
        }
    }

    public void registerResource(String type, String id, ClassLoader loader, String baseName, Locale locale) {
        String suffix = "";
        if (locale.getLanguage().length() > 0) {
            suffix = suffix + "_" + locale.getLanguage();
        }
        if (locale.getCountry().length() > 0) {
            suffix = suffix + "_" + locale.getCountry();
        }
        if (locale.getVariant().length() > 0) {
            suffix = suffix + "_" + locale.getVariant();
        }
        for (int i = 0; i < 3; ++i) {
            int cut;
            try {
                URL url = loader.getResource(baseName + suffix + ".properties");
                if (url != null) {
                    PluginRegistry.registerResource(type, id, loader, url.getPath(), locale);
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if ((cut = suffix.lastIndexOf(95)) <= 0) break;
            suffix = suffix.substring(0, cut);
        }
    }

    public void download(BFrame frame, URL from) {
        this.download(frame, from, null);
    }

    public void download(BFrame frame, URL from, URL to) {
        final BFrame context = frame;
        final URL url = from;
        URL toUrl = to;
        StatusDialog status = new StatusDialog(context){
            SPMObjectInfo info;
            BLabel size;
            BButton okbtn;
            String filename;
            String name;
            ColumnContainer col;
            RowContainer buttons;
            BTextField savePath;
            Thread worker;

            public void setVisible(boolean vis) {
                if (!vis) {
                    super.setVisible(vis);
                    return;
                }
                this.col = (ColumnContainer)this.getContent();
                this.filename = url.getFile();
                int cut = this.filename.lastIndexOf(47);
                if (cut > 0 && cut < this.filename.length()) {
                    this.filename = this.filename.substring(cut + 1);
                }
                if ((cut = this.filename.lastIndexOf(63)) > 0) {
                    this.filename = this.filename.substring(0, cut);
                }
                this.name = new String(this.filename);
                cut = this.name.lastIndexOf(46);
                if (cut > 0) {
                    this.name = this.name.substring(0, cut);
                }
                this.setText(this.name);
                this.setProgressText(SPMTranslate.text("clickStart"));
                this.okbtn = SPMTranslate.bButton("start", this, "ok");
                this.buttons = new RowContainer();
                this.buttons.add(this.okbtn);
                this.buttons.add(SPMTranslate.bButton("cancel", this, "close"));
                this.okbtn.setActionCommand("ok");
                this.col.add(this.buttons);
                this.pack();
                super.setVisible(true);
            }

            public void close() {
                if (this.worker != null) {
                    this.worker.interrupt();
                }
                this.doClose();
            }

            public void ok(CommandEvent ev) {
                String cmd = ev.getActionCommand();
                this.okbtn.setEnabled(false);
                final BButton okbut = this.okbtn;
                final 1 stat = this;
                if (cmd.equals("ok")) {
                    this.setProgressText(SPMTranslate.text("contacting"));
                    this.setIdle(true);
                    System.out.println("DOWNLOAD: creating ObjectInfo..." + url.toString());
                    this.worker = new Thread(){

                        public void run() {
                            long total;
                            info = new SPMObjectInfo(url);
                            if (info.length == 0L) {
                                System.out.println("DOWNLOAD: no info");
                                info.length = info.getRemoteFileSize(url.toString());
                            }
                            if (info.name == null || info.name.length() == 0) {
                                System.out.println("need path...");
                                RowContainer row = new RowContainer();
                                row.add(SPMTranslate.bLabel("savePath"));
                                savePath = new BTextField("", 25);
                                savePath.addEventLink(ValueChangedEvent.class, (Object)this, "savePath");
                                row.add(savePath);
                                row.add(SPMTranslate.bButton("browse", this, "browse"));
                                col.remove(buttons);
                                col.add(row);
                                col.add(buttons);
                                this.pack();
                            }
                            String sz = (total = info.getTotalLength()) > 1000000L ? " " + total / 1000000L + " MB" : (total > 1000L ? " " + total / 1000L + " kB" : (total > 0L ? " " + total + " bytes" : ""));
                            this.setText(info.getName() + " " + sz);
                            this.setIdle(false);
                            this.setProgressText(SPMTranslate.text("ready"));
                            okbut.setActionCommand("install");
                            okbut.setText(SPMTranslate.text("install"));
                            okbut.setEnabled(true);
                            this.pack();
                        }

                        public void savePath() {
                            String val = savePath.getText();
                            okbtn.setEnabled(val != null && val.length() > 0);
                        }

                        public void browse() {
                            BFileChooser fc = new BFileChooser(BFileChooser.SAVE_FILE, Translate.text("savePath"));
                            File file = null;
                            String path = null;
                            String fname = savePath.getText();
                            if (fname == null || fname.length() == 0) {
                                path = System.getProperty("user.home");
                                fname = filename;
                            }
                            if (fname != null) {
                                file = path != null ? new File(path, fname) : new File(fname);
                                fc.setDirectory(file.getParentFile());
                                fc.setSelectedFile(file);
                            } else {
                                fc.setDirectory(new File(path));
                            }
                            if (fc.showDialog(context)) {
                                savePath.setText(fc.getSelectedFile().getAbsolutePath());
                            }
                        }
                    };
                    this.worker.start();
                } else if (cmd.equals("install")) {
                    System.out.println("DOWNLOAD: downloading " + url.toString());
                    this.setText(SPMTranslate.text("downloading", this.info.getName()));
                    this.pack();
                    final ArrayList errs = new ArrayList();
                    this.worker = new Thread(){

                        public void run() {
                            long total = info.getTotalLength();
                            String path = null;
                            if (savePath != null) {
                                path = savePath.getText();
                            } else if (info.name != null) {
                                path = ArtOfIllusion.PLUGIN_DIRECTORY + File.separatorChar + info.name + ".jar";
                            }
                            if (path == null || path.length() == 0) {
                                System.out.println("DOWNLOAD: no save location");
                                new BStandardDialog("SPManager", SPMTranslate.text("noSaveLocation"), BStandardDialog.ERROR).showMessageDialog(null);
                                this.doClose();
                            }
                            System.out.println("DOWNLOAD: downloading file...");
                            if (total > 0L) {
                                this.setBarValue(total > 0L ? 0 : -1);
                            }
                            long dl = HttpSPMFileSystem.downloadRemoteBinaryFile(url, path, info.length, stat, total, 0L, errs);
                            for (int i = 0; info.files != null && i < info.files.length; ++i) {
                                1 v0 = this;
                                if (v0.worker.interrupted()) {
                                    this.doClose();
                                    return;
                                }
                                name = PLUGIN_DIRECTORY + File.separatorChar + info.destination.get(i) + info.files[i];
                                this.setText(SPMTranslate.text("downloading", info.files[i]));
                                this.pack();
                                dl += HttpSPMFileSystem.downloadRemoteBinaryFile(info.getAddFileURL(i), name, info.fileSizes[i], stat, total, dl, errs);
                            }
                            if (errs != null && errs.size() > 0) {
                                InstallSplitPane.showErrors(errs);
                            } else {
                                new BStandardDialog("SPManager", SPMTranslate.text("modified"), BStandardDialog.ERROR).showMessageDialog(null);
                            }
                            System.out.println("DOWNLOAD: done");
                            this.doClose();
                        }
                    };
                    this.worker.start();
                } else {
                    System.out.println("?? cmd=" + cmd);
                }
            }
        };
    }

    public void doMenu() {
        if (spmFrame == null) {
            spmFrame = new SPManagerFrame();
        }
        spmFrame.getComponent().toFront();
        spmFrame.getComponent().show();
    }

    public static void restart() {
        SPManagerFrame old = spmFrame;
        spmFrame = new SPManagerFrame();
        spmFrame.getComponent().toFront();
        spmFrame.getComponent().show();
        old.dispose();
    }

    public void close() {
        if (spmFrame != null) {
            spmFrame.setVisible(false);
            spmFrame.dispose();
        }
    }

    public String getName() {
        return "Script and Plugin Manager";
    }

    public static SPManagerFrame getFrame() {
        return spmFrame;
    }

    public static void updatePlugin(String name, String action, String target) {
    }

    public static void main(String[] argv) {
        char slash = File.separatorChar;
        APP_DIRECTORY = System.getProperty("user.dir");
        try {
            int cut;
            URL url = SPManagerPlugin.class.getResource("/artofillusion/spmanager/SPManagerPlugin.class");
            System.out.println("SPManager.main: url=" + url);
            System.out.println("SPManager.main: path=" + url.getPath());
            String furl = url.getPath();
            if (furl.indexOf(33) < 0) {
                furl = url.toString();
            }
            if ((cut = furl.indexOf(33)) > 0) {
                if ((cut = (furl = furl.substring(0, cut)).indexOf("jar:")) >= 0) {
                    furl = furl.substring(cut + "jar:".length());
                }
                if (!furl.startsWith("file:")) {
                    furl = "file:" + furl;
                }
                System.out.println("SPManager.main: furl=" + furl);
                File dir = new File(new URL(furl).getPath()).getParentFile().getParentFile();
                System.out.println("SPManager.main: dir=" + dir.getAbsolutePath());
                APP_DIRECTORY = dir.exists() ? dir.getAbsolutePath() : System.getProperty("user.dir");
                System.out.println("SPManager.main: app_dir=" + APP_DIRECTORY);
            }
        }
        catch (Exception ex) {
            System.out.println("Error looking up app_dir: " + ex);
        }
        SPMTranslate.setLocale(Locale.getDefault());
        PLUGIN_DIRECTORY = APP_DIRECTORY + slash + "Plugins";
        TOOL_SCRIPT_DIRECTORY = APP_DIRECTORY + slash + "Scripts" + slash + "Tools";
        OBJECT_SCRIPT_DIRECTORY = APP_DIRECTORY + slash + "Scripts" + slash + "Objects";
        STARTUP_SCRIPT_DIRECTORY = APP_DIRECTORY + slash + "Scripts" + slash + "Startup";
        SPManagerPlugin spm = new SPManagerPlugin();
        spm.init();
        spmFrame = new SPManagerFrame(){

            protected void hideSPManager() {
                this.setVisible(false);
                this.dispose();
            }
        };
        spm.doMenu();
    }
}

