/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.spmanager;

import artofillusion.LayoutWindow;
import artofillusion.PluginRegistry;
import artofillusion.spmanager.HttpSPMFileSystem;
import artofillusion.spmanager.InstallSplitPane;
import artofillusion.spmanager.ManageSplitPane;
import artofillusion.spmanager.SPMObjectInfo;
import artofillusion.spmanager.SPMParameters;
import artofillusion.spmanager.SPMSetupFrame;
import artofillusion.spmanager.SPMSplitPane;
import artofillusion.spmanager.SPMTranslate;
import artofillusion.spmanager.SPManagerPlugin;
import artofillusion.spmanager.StatusDialog;
import artofillusion.ui.UIUtilities;
import buoy.event.SelectionChangedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BStandardDialog;
import buoy.widget.BTabbedPane;
import buoy.widget.ColumnContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.widget.WindowWidget;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SPManagerFrame
extends BFrame {
    private static SPManagerFrame spmFrame;
    private static SPMParameters parameters;
    private BTabbedPane tabbedPane;
    private SPMSplitPane manageSplitPane;
    private InstallSplitPane updateSplitPane;
    private InstallSplitPane installSplitPane;
    private BLabel statusLabel;
    private String statusText;
    private Timer timer;
    private Action statusTextClearAction;
    BButton setupButton;
    BButton quitButton;
    BButton scanButton;
    public static final String[] YES_NO;
    public static final String[] CONTINUE_IGNORE;
    protected static final String version = "1.9";

    public static SPManagerFrame getInstance() {
        return spmFrame;
    }

    public static SPMParameters getParameters() {
        return parameters;
    }

    public SPManagerFrame() {
        super(SPMTranslate.text("SPManager"));
        spmFrame = this;
        parameters = new SPMParameters();
        this.statusLabel = new BLabel(" ");
        this.statusTextClearAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SPManagerFrame.this.statusLabel.setText(" ");
            }
        };
        this.manageSplitPane = new ManageSplitPane();
        this.updateSplitPane = new InstallSplitPane(1, (URL)null);
        this.installSplitPane = new InstallSplitPane(2, this.updateSplitPane.getFileSystem());
        ((HttpSPMFileSystem)this.updateSplitPane.getFileSystem()).setRepository(parameters.getCurrentRepository());
        RowContainer rc = new RowContainer();
        LayoutInfo layout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(5, 3, 3, 3), new Dimension(0, 0));
        ColumnContainer cc = new ColumnContainer();
        LayoutInfo headLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(3, 5, 5, 3), new Dimension(0, 0));
        rc.add(new BLabel(new ImageIcon(this.getClass().getResource("/artofillusion/spmanager/icons/gear.png"))), headLayout);
        rc.add(SPMTranslate.bLabel("Version", new Object[]{version}), headLayout);
        LayoutInfo cclayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(3, 3, 5, 3), new Dimension(0, 0));
        cc.add(rc, cclayout);
        this.tabbedPane = new BTabbedPane();
        this.tabbedPane.add(this.manageSplitPane, SPMTranslate.text("manage"));
        this.tabbedPane.add(this.updateSplitPane, SPMTranslate.text("update"));
        this.tabbedPane.add(this.installSplitPane, SPMTranslate.text("install"));
        this.tabbedPane.addEventLink(SelectionChangedEvent.class, (Object)this, "doTabbedPaneSelection");
        LayoutInfo tabbedPaneLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(0, 0, 0, 0), new Dimension(0, 0));
        cc.add(this.tabbedPane, tabbedPaneLayout);
        RowContainer buttons = new RowContainer();
        this.setupButton = SPMTranslate.bButton("setup", this, "doSetup");
        buttons.add(this.setupButton);
        this.scanButton = SPMTranslate.bButton("rescan", this, "doRescan");
        buttons.add(this.scanButton);
        this.quitButton = SPMTranslate.bButton("close", this, "hideSPManager");
        buttons.add(this.quitButton);
        cc.add(buttons, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(3, 0, 0, 0), null));
        cc.add(new BOutline(this.statusLabel, BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), SPMTranslate.text("remoteStatus"))), new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(1, 1, 1, 1), new Dimension(0, 0)));
        this.setContent(cc);
        this.pack();
        this.centerAndSizeWindow();
        this.setVisible(true);
        this.addEventLink(WindowClosingEvent.class, (Object)this, "hideSPManager");
        this.manageSplitPane.setDividerLocation(this.manageSplitPane.getChild((int)0).getPreferredSize().width);
        this.updateSplitPane.setDividerLocation(this.updateSplitPane.getChild((int)0).getPreferredSize().width);
        this.installSplitPane.setDividerLocation(this.installSplitPane.getChild((int)0).getPreferredSize().width);
    }

    public void printBounds(WidgetContainer wc) {
        for (Widget w : wc.getChildren()) {
            System.out.println("Widget: " + w);
            System.out.println("Bounds: " + w.getBounds());
            System.out.println("Min size: " + w.getMinimumSize());
            System.out.println("Pref size: " + w.getPreferredSize());
            if (!(w instanceof WidgetContainer)) continue;
            this.printBounds((WidgetContainer)w);
        }
    }

    protected void hideSPManager() {
        if (this.manageSplitPane.isModified() || this.updateSplitPane.isModified() || this.installSplitPane.isModified()) {
            JOptionPane.showMessageDialog(null, SPMTranslate.text("modified"), SPMTranslate.text("alert"), 0);
        }
        this.getComponent().setVisible(false);
    }

    private void doTabbedPaneSelection() {
        switch (this.tabbedPane.getSelectedTab()) {
            default: {
                this.manageSplitPane.doSetup();
                break;
            }
            case 1: {
                this.updateSplitPane.doSetup();
                break;
            }
            case 2: {
                this.installSplitPane.doSetup();
            }
        }
    }

    protected void checkForUpdatedMe() {
        int i;
        Vector localList = this.manageSplitPane.getFileSystem().getPlugins();
        Vector remoteList = this.updateSplitPane.getFileSystem().getPlugins();
        SPMObjectInfo localinfo = null;
        SPMObjectInfo remoteinfo = null;
        for (i = 0; i < localList.size() && !"SPManager".equals((localinfo = (SPMObjectInfo)localList.get(i)).getName()); ++i) {
        }
        for (i = 0; i < remoteList.size() && !"SPManager".equals((remoteinfo = (SPMObjectInfo)remoteList.get(i)).getName()); ++i) {
        }
        boolean update = true;
        if (localinfo != null && remoteinfo != null) {
            if (remoteinfo.getMajor() < localinfo.getMajor()) {
                update = false;
            } else if (remoteinfo.getMajor() == localinfo.getMajor()) {
                if (remoteinfo.getMinor() < localinfo.getMinor()) {
                    update = false;
                } else if (remoteinfo.getMinor() == localinfo.getMinor()) {
                    if (localinfo.isBeta()) {
                        if (remoteinfo.isBeta() && remoteinfo.getBeta() <= localinfo.getBeta()) {
                            update = false;
                        }
                    } else {
                        update = false;
                    }
                }
            }
        } else {
            boolean bl = update = remoteinfo != null;
        }
        if (update && new BStandardDialog("SPManager", UIUtilities.breakString(SPMTranslate.text("updateSPManager")), BStandardDialog.QUESTION).showOptionDialog(null, YES_NO, YES_NO[0]) == 0) {
            final StatusDialog status = new StatusDialog(SPManagerPlugin.getFrame());
            final SPMObjectInfo info = remoteinfo;
            new Thread(){

                public void run() {
                    SPManagerFrame.this.updateSplitPane.installFile(info);
                    SPManagerFrame.this.updateSplitPane.showErrors();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            status.dispose();
                            SPManagerFrame.this.hideSPManager();
                        }
                    });
                }
            }.start();
        }
    }

    private void doManage() {
        this.tabbedPane.setSelectedTab(0);
        this.doTabbedPaneSelection();
    }

    private void doUpdate() {
        this.tabbedPane.setSelectedTab(1);
        this.doTabbedPaneSelection();
    }

    private void doInstall() {
        this.tabbedPane.setSelectedTab(2);
        this.doTabbedPaneSelection();
    }

    private void doSetup() {
        new SPMSetupFrame(this);
        if (parameters.hasChanged()) {
            ((HttpSPMFileSystem)this.updateSplitPane.getFileSystem()).setRepository(parameters.getCurrentRepository());
            this.doRescan();
        }
    }

    private void doRescan() {
        parameters.getRepositoriesList(true);
    }

    public void updatePanes() {
        this.manageSplitPane.doUpdate();
        ((HttpSPMFileSystem)this.updateSplitPane.getFileSystem()).setRepository(parameters.getCurrentRepository());
        this.updateSplitPane.doUpdate();
        this.installSplitPane.doUpdate();
    }

    private void centerAndSizeWindow() {
        try {
            WindowWidget root;
            for (root = (WindowWidget)this.getParent(); root != null && !(root instanceof LayoutWindow); root = (WindowWidget)root.getParent()) {
            }
            Rectangle bounds = (Rectangle)PluginRegistry.invokeExportedMethod("nik777.OneFixSizesAll.getChildBounds", root);
            Dimension d2 = this.getComponent().getSize();
            int x = bounds.x + (bounds.width - d2.width) / 2;
            int y = bounds.y + (bounds.height - d2.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.setBounds(new Rectangle(x, y, d2.width, d2.height + 2));
        }
        catch (Exception e) {
            UIUtilities.centerWindow(this);
        }
    }

    public void setRemoteStatusText(String text, int time) {
        this.statusText = text;
        this.setRemoteStatusTextDuration(time);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SPManagerFrame.this.statusLabel.setText(SPManagerFrame.this.statusText);
            }
        });
    }

    public void setRemoteStatusTextDuration(int time) {
        if (time > 0) {
            if (this.timer != null) {
                this.timer.setDelay(time);
                this.timer.restart();
            } else {
                this.timer = new Timer(time, this.statusTextClearAction);
                this.timer.start();
            }
        } else if (this.timer != null) {
            this.timer.stop();
        }
    }

    static {
        YES_NO = new String[]{SPMTranslate.text("Yes"), SPMTranslate.text("No")};
        CONTINUE_IGNORE = new String[]{SPMTranslate.text("Continue"), SPMTranslate.text("Stop"), SPMTranslate.text("Ignore")};
    }
}

