/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.spmanager;

import artofillusion.spmanager.ManageSplitPane;
import artofillusion.spmanager.SPMFileSystem;
import artofillusion.spmanager.SPMObjectInfo;
import artofillusion.spmanager.SPMTranslate;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BScrollBar;
import buoy.widget.BScrollPane;
import buoy.widget.BSplitPane;
import buoy.widget.BTextArea;
import buoy.widget.BTree;
import buoy.widget.ColumnContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class SPMSplitPane
extends BSplitPane {
    protected BTree tree;
    protected BTextArea objectName;
    protected BTextArea objectDescription;
    protected RowContainer buttonRow;
    protected TreePath pluginsPath;
    protected TreePath scriptsPath;
    protected TreePath toolScriptsPath;
    protected TreePath objectScriptsPath;
    protected TreePath startupScriptsPath;
    protected short workMode;
    protected SPMFileSystem fs;
    protected static Vector splitPaneList;
    protected boolean modified;
    protected boolean acceptsFileSelection = true;
    protected Hashtable extMap;
    protected Hashtable pathMap;
    private BScrollPane nameSP;
    private BScrollPane descriptionSP;
    private BComboBox descSelect;
    private Vector descText;
    public static final short BROWSE = 0;
    public static final short UPDATE = 1;
    public static final short INSTALL = 2;
    protected static Icon checkedIcon;
    protected static Icon uncheckedIcon;
    protected static Icon referedIcon;
    protected static Icon disableIcon;
    protected static Icon infoIcon;
    protected static Icon confirmIcon;
    protected static Icon flagIcon;
    protected static Icon alertIcon;

    public SPMSplitPane(String s) {
        super(BSplitPane.HORIZONTAL);
        this.workMode = 0;
        this.initialize(s);
    }

    public SPMSplitPane(String s, short wm) {
        super(BSplitPane.HORIZONTAL);
        this.workMode = wm;
        this.initialize(s);
    }

    private void initialize(String s) {
        uncheckedIcon = UIManager.getDefaults().getIcon("Tree.leafIcon");
        if (uncheckedIcon == null) {
            uncheckedIcon = new ImageIcon(this.getClass().getResource("/artofillusion/spmanager/icons/file.png"));
        }
        checkedIcon = new OverlayIcon(uncheckedIcon, new ImageIcon(this.getClass().getResource("/artofillusion/spmanager/icons/checkCircle.png")));
        referedIcon = new ImageIcon(this.getClass().getResource("/artofillusion/spmanager/icons/Import16.gif"));
        disableIcon = new OverlayIcon(uncheckedIcon, new ImageIcon(this.getClass().getResource("/artofillusion/spmanager/icons/disabled.png")));
        infoIcon = new OverlayIcon(uncheckedIcon, new ImageIcon(this.getClass().getResource("/artofillusion/spmanager/icons/info.png")));
        confirmIcon = new OverlayIcon(uncheckedIcon, new ImageIcon(this.getClass().getResource("/artofillusion/spmanager/icons/confirm.png")));
        flagIcon = new OverlayIcon(uncheckedIcon, new ImageIcon(this.getClass().getResource("/artofillusion/spmanager/icons/flag.png")));
        alertIcon = new OverlayIcon(uncheckedIcon, new ImageIcon(this.getClass().getResource("/artofillusion/spmanager/icons/alert.png")));
        if (splitPaneList == null) {
            splitPaneList = new Vector();
        }
        splitPaneList.add(this);
        ColumnContainer cc = new ColumnContainer();
        this.tree = new BTree(new DefaultMutableTreeNode(SPMTranslate.text(s)));
        BScrollPane sc = new BScrollPane(this.tree);
        this.add(sc, 0);
        this.add(cc, 1);
        LayoutInfo labelLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(3, 3, 3, 3), new Dimension(0, 0));
        LayoutInfo textAreaLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(3, 3, 3, 3), new Dimension(0, 0));
        cc.add(SPMTranslate.bLabel("name"), labelLayout);
        this.objectName = new BTextArea("", 3, 50);
        this.objectName.setWrapStyle(BTextArea.WRAP_WORD);
        this.nameSP = new BScrollPane(this.objectName, BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_ALWAYS);
        cc.add(BOutline.createEtchedBorder(this.nameSP, true), textAreaLayout);
        this.nameSP.setForceWidth(true);
        this.descSelect = new BComboBox();
        this.descSelect.add(SPMTranslate.text("description"));
        this.descSelect.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                int index = SPMSplitPane.this.descSelect.getSelectedIndex();
                if (SPMSplitPane.this.descText != null && index < SPMSplitPane.this.descText.size()) {
                    SPMSplitPane.this.objectDescription.setText((String)SPMSplitPane.this.descText.get(index));
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BScrollBar bar = SPMSplitPane.this.descriptionSP.getVerticalScrollBar();
                            bar.setValue(bar.getMinimum());
                        }
                    });
                }
            }
        });
        RowContainer rc = new RowContainer();
        cc.add(rc, labelLayout);
        rc.add(this.descSelect, labelLayout);
        rc.add(new BLabel(SPMTranslate.text("flags") + ":"));
        rc.add(new BLabel("=" + SPMTranslate.text("alertFlag"), alertIcon, BLabel.CENTER, BLabel.EAST));
        rc.add(new BLabel("=" + SPMTranslate.text("filtMark"), flagIcon, BLabel.CENTER, BLabel.EAST));
        rc.add(new BLabel("=" + SPMTranslate.text("filtDisable"), disableIcon, BLabel.CENTER, BLabel.EAST));
        rc.add(new BLabel("=" + SPMTranslate.text("filtConfirm"), confirmIcon, BLabel.CENTER, BLabel.EAST));
        rc.add(new BLabel("=" + SPMTranslate.text("required"), referedIcon, BLabel.CENTER, BLabel.EAST));
        this.objectDescription = new BTextArea("", 8, 50);
        this.objectDescription.setWrapStyle(BTextArea.WRAP_WORD);
        this.descriptionSP = new BScrollPane(this.objectDescription, BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_ALWAYS);
        cc.add(BOutline.createEtchedBorder(this.descriptionSP, true), textAreaLayout);
        this.descriptionSP.setForceWidth(true);
        this.buttonRow = new RowContainer();
        LayoutInfo buttonRowLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(3, 3, 7, 3), new Dimension(0, 0));
        cc.add(this.buttonRow, buttonRowLayout);
        this.objectName.setEditable(false);
        this.objectDescription.setEditable(false);
        this.tree.getComponent().putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setCellRenderer(new SPMTreeRenderer());
        this.tree.addEventLink(SelectionChangedEvent.class, (Object)this, "doTreeNodeSelection");
        this.tree.setMultipleSelectionEnabled(false);
        this.pluginsPath = this.tree.addNode(this.tree.getRootNode(), new DefaultMutableTreeNode(SPMTranslate.text("plugins")));
        this.scriptsPath = this.tree.addNode(this.tree.getRootNode(), new DefaultMutableTreeNode(SPMTranslate.text("scripts")));
        this.toolScriptsPath = this.tree.addNode(this.scriptsPath, new DefaultMutableTreeNode(SPMTranslate.text("tools")));
        this.objectScriptsPath = this.tree.addNode(this.scriptsPath, new DefaultMutableTreeNode(SPMTranslate.text("objects")));
        this.startupScriptsPath = this.tree.addNode(this.scriptsPath, new DefaultMutableTreeNode(SPMTranslate.text("startup")));
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setOneTouchExpandable(true);
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = SPMSplitPane.this.tree.getComponent().getRowForLocation(e.getX(), e.getY());
                TreePath selPath = SPMSplitPane.this.tree.getComponent().getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 2) {
                    SPMSplitPane.this.treeDoubleClick(selRow, selPath);
                }
            }
        };
        this.tree.getComponent().addMouseListener(ml);
        this.pathMap = new Hashtable(8);
        this.pathMap.put("plugin", this.pluginsPath);
        this.pathMap.put("library", this.pluginsPath);
        this.pathMap.put("script", this.scriptsPath);
    }

    protected void updateTree() {
    }

    public void doTreeNodeSelection() {
        TreePath[] tp = this.tree.getSelectedNodes();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getComponent().getLastSelectedPathComponent();
        if (node != null) {
            if (node.isLeaf() && !node.getAllowsChildren()) {
                if (node.getUserObject() != null) {
                    SPMObjectInfo nodeInfo = (SPMObjectInfo)node.getUserObject();
                    this.displayObjectInfo(nodeInfo);
                    if (nodeInfo.fileName.endsWith(".bsh")) {
                        this.scriptSelection(nodeInfo.deletable);
                    } else {
                        this.pluginSelection(nodeInfo.deletable);
                    }
                }
            } else {
                this.voidSelection();
            }
        }
    }

    public SPMObjectInfo getSelectedNodeInfo() {
        TreePath[] tp = this.tree.getSelectedNodes();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getComponent().getLastSelectedPathComponent();
        if (node != null) {
            if (node.isLeaf() && !node.getAllowsChildren()) {
                if (node.getUserObject() != null) {
                    SPMObjectInfo nodeInfo = (SPMObjectInfo)node.getUserObject();
                    return nodeInfo;
                }
            } else {
                return null;
            }
        }
        return null;
    }

    private void displayObjectInfo(SPMObjectInfo info) {
        this.objectName.setBackground(Color.WHITE);
        if (info != null) {
            this.objectName.setBackground(Color.WHITE);
            this.descText = info.getDetails();
            String name = info.getFullName();
            if (info.refcount > 0) {
                name = name + "\n\nRequired by " + info.refcount + " other(s).";
            }
            String extList = "\n";
            boolean missing = false;
            Collection externals = info.getExternals();
            if (externals != null) {
                for (String ext : externals) {
                    String extType;
                    String extName;
                    if (ext.endsWith("= required") && this.getInfo(extName = ext.substring(0, ext.indexOf(58)), (TreePath)this.pathMap.get(extType = ext.substring(ext.indexOf(58) + 1, ext.indexOf(61)).trim())) == null) {
                        SPMSplitPane man = null;
                        for (int j = splitPaneList.size() - 1; j >= 0; --j) {
                            if (!(splitPaneList.get(j) instanceof ManageSplitPane)) continue;
                            man = (ManageSplitPane)splitPaneList.get(j);
                            break;
                        }
                        if (man.getInfo(extName, ((ManageSplitPane)man).pluginsPath) == null) {
                            missing = true;
                            ext = ext + " **Not Available**";
                        }
                    }
                    extList = extList + "\n-External " + ext;
                }
                if (missing) {
                    name = name + "\n" + SPMTranslate.text("missingFile", SPMTranslate.text("otherFiles"));
                    this.objectName.setBackground(Color.PINK);
                }
                if (info.invalid) {
                    name = name + "\n" + SPMTranslate.text("failedRequirement", SPMTranslate.text("flags"));
                    this.objectName.setBackground(Color.PINK);
                }
                info.setLog(SPMTranslate.text("otherFiles"), extList, 2);
            }
            this.objectName.setText(name);
            if (this.descText != null && this.descText.size() > 0) {
                this.objectDescription.setText((String)this.descText.get(0));
            } else {
                this.objectDescription.setText("");
            }
            Vector changeLog = info.getChangeLog();
            if (changeLog != null) {
                this.descSelect.setContents(changeLog);
            } else {
                this.descSelect.removeAll();
                this.descSelect.add(SPMTranslate.text("description"));
                this.descSelect.add(SPMTranslate.text("history"));
            }
        } else {
            this.objectName.setText("");
            this.objectDescription.setText("");
            this.descSelect.removeAll();
            this.descSelect.add(SPMTranslate.text("description"));
        }
        this.descriptionSP.layoutChildren();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BScrollBar bar = SPMSplitPane.this.descriptionSP.getVerticalScrollBar();
                bar.setValue(bar.getMinimum());
            }
        });
    }

    public SPMObjectInfo getInfo(String name, String type) {
        TreePath path = (TreePath)this.pathMap.get(type);
        return this.getInfo(name, path);
    }

    public SPMObjectInfo getInfo(String name, TreePath path) {
        if (path == null) {
            System.out.println("SPManager: poor XML content: invalid external type (" + name + ")");
            return null;
        }
        int max = this.tree.getChildNodeCount(path);
        for (int j = 0; j < max; ++j) {
            Object info = ((DefaultMutableTreeNode)this.tree.getChildNode(path, j).getLastPathComponent()).getUserObject();
            if (!name.equals(info.toString())) continue;
            return (SPMObjectInfo)info;
        }
        return null;
    }

    public void scriptSelection(boolean deletable) {
        this.layoutChildren();
    }

    public void pluginSelection(boolean deletable) {
        this.layoutChildren();
    }

    public void voidSelection() {
        this.displayObjectInfo(null);
        this.layoutChildren();
    }

    public void doSetup() {
    }

    public void doUpdate() {
        this.clearTree();
        this.updateTree();
        this.layoutChildren();
        this.voidSelection();
    }

    public SPMSplitPane getManager() {
        for (int i = 0; i < splitPaneList.size(); ++i) {
            if (((SPMSplitPane)SPMSplitPane.splitPaneList.elementAt((int)i)).workMode != 0) continue;
            return (SPMSplitPane)splitPaneList.elementAt(i);
        }
        return null;
    }

    public SPMFileSystem getFileSystem() {
        return this.fs;
    }

    protected void clearTree() {
        this.clearPath(this.pluginsPath);
        this.clearPath(this.toolScriptsPath);
        this.clearPath(this.objectScriptsPath);
        this.clearPath(this.startupScriptsPath);
    }

    private void clearPath(TreePath path) {
        int count = this.tree.getChildNodeCount(path);
        if (count > 0) {
            for (int j = count - 1; j >= 0; --j) {
                this.tree.removeNode(this.tree.getChildNode(path, j));
            }
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void treeDoubleClick(int selRow, TreePath selPath) {
        if (!this.acceptsFileSelection) {
            return;
        }
        SPMObjectInfo nodeInfo = this.getSelectedNodeInfo();
        if (nodeInfo != null) {
            nodeInfo.setSelected(!nodeInfo.isSelected());
            this.notifyObjectInfoSelection(nodeInfo);
        }
        this.repaint();
    }

    protected void notifyObjectInfoSelection(SPMObjectInfo info) {
        if (this.extMap != null) {
            this.extMap.clear();
        }
        this.selectExternals(info);
    }

    protected void selectExternals(SPMObjectInfo info) {
        if (this.extMap == null) {
            this.extMap = new Hashtable(32);
        }
        if (this.extMap.containsKey(info)) {
            System.out.println("SPMSplitPane: dependency loop detected: " + info.getName());
            return;
        }
        this.extMap.put(info, info);
        Collection externals = info.getExternals();
        if (externals == null || externals.size() == 0) {
            return;
        }
        for (String extName : externals) {
            if (!extName.endsWith("= required")) continue;
            String extType = extName.substring(extName.indexOf(58) + 1, extName.indexOf(61)).trim();
            SPMObjectInfo ext = this.getInfo(extName = extName.substring(0, extName.indexOf(58)), (TreePath)this.pathMap.get(extType));
            if (ext == null) continue;
            ext.refcount = info.isSelected() ? ++ext.refcount : --ext.refcount;
            this.selectExternals(ext);
        }
    }

    public class OverlayIcon
    implements Icon {
        private Icon originalIcon;
        private Icon overlayIcon;

        public OverlayIcon(Icon originalIcon, Icon overlayIcon) {
            this.originalIcon = originalIcon;
            this.overlayIcon = overlayIcon;
        }

        public int getIconHeight() {
            return this.originalIcon.getIconHeight();
        }

        public int getIconWidth() {
            return this.originalIcon.getIconWidth();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.originalIcon.paintIcon(c, g, x, y);
            this.overlayIcon.paintIcon(c, g, x, y);
        }
    }

    private class SPMTreeRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof SPMObjectInfo) {
                SPMObjectInfo nodeInfo = (SPMObjectInfo)node.getUserObject();
                if (nodeInfo.refcount > 0) {
                    this.setIcon(referedIcon);
                } else if (SPMSplitPane.this.workMode != 0 && nodeInfo.restriction == 4) {
                    this.setIcon(disableIcon);
                } else if (nodeInfo.invalid) {
                    this.setIcon(alertIcon);
                } else if (nodeInfo.isSelected()) {
                    this.setIcon(checkedIcon);
                } else if (nodeInfo.restriction == 2) {
                    this.setIcon(flagIcon);
                } else if (nodeInfo.restriction == 3) {
                    this.setIcon(confirmIcon);
                } else if (this.getIcon() == null) {
                    this.setIcon(uncheckedIcon);
                }
            }
            return this;
        }
    }
}

