/*
 * Decompiled with CFR 0.152.
 */
package buoyx.docking;

import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BDialog;
import buoy.widget.BTabbedPane;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.widget.WindowWidget;
import buoyx.docking.DockableWidget;
import buoyx.docking.DockingContainer;
import buoyx.docking.DockingEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Iterator;
import java.util.WeakHashMap;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class DragManager {
    private boolean inDrag;
    private DockableWidget draggedWidget;
    private DockingContainer originalContainer;
    private int originalTab;
    private int originalIndex;
    private Rectangle outline;
    private DragTarget dragTarget;
    private DragMarker dragMarker;
    private static DragManager manager;
    private static TexturePaint ditheredPaint;
    private static WeakHashMap<WidgetContainer, HashSet<DetachedDockingContainer>> detachedDocks;

    private DragManager() {
    }

    static DragManager getDragManager() {
        if (manager == null) {
            manager = new DragManager();
        }
        return manager;
    }

    void beginDraggingWidget(MousePressedEvent ev) {
        this.draggedWidget = (DockableWidget)ev.getWidget();
        if (ev.getButton() == 1 && this.draggedWidget.isInDragRegion(ev.getPoint())) {
            this.inDrag = true;
            this.originalContainer = (DockingContainer)this.draggedWidget.getParent();
            this.originalTab = this.originalContainer.getChildTabIndex(this.draggedWidget);
            this.originalIndex = this.originalContainer.getChildIndexInTab(this.draggedWidget);
            this.outline = this.draggedWidget.getBounds();
            Point pos = ev.getPoint();
            this.outline.x = -pos.x;
            this.outline.y = -pos.y;
        }
    }

    void beginDraggingTab(DockingContainer container, int tab, Rectangle outline) {
        this.inDrag = true;
        this.originalContainer = container;
        this.originalTab = tab;
        this.originalIndex = -1;
        this.outline = outline;
    }

    void mouseDragged(MouseDraggedEvent ev) {
        Component targetComponent;
        Rectangle targetBounds;
        if (!this.inDrag) {
            return;
        }
        if (this.dragMarker == null) {
            this.dragMarker = new DragMarker(ev.getComponent());
        }
        this.dragTarget = this.findDragTarget(ev);
        if (this.dragTarget != null) {
            DockingContainer dock = this.dragTarget.container;
            targetBounds = this.dragTarget.index > -1 && this.dragTarget.tab == dock.getSelectedTab() ? (dock == this.originalContainer && this.dragTarget.tab == this.originalTab && (this.originalIndex == -1 || this.originalIndex == this.dragTarget.index || this.originalIndex == this.dragTarget.index - 1 || this.dragTarget.index == -1) ? dock.getChild(this.dragTarget.tab, this.originalIndex != -1 && this.dragTarget.index == this.originalIndex + 1 || this.dragTarget.index == dock.getTabChildCount(this.dragTarget.tab) ? this.dragTarget.index - 1 : this.dragTarget.index).getBounds() : DragManager.findInsertionAreaBounds(this.dragTarget.container, this.dragTarget.tab, this.dragTarget.index)) : dock.getTabBounds(this.dragTarget.tab);
            this.dragMarker.setHilighted(true);
            targetComponent = dock.getComponent();
        } else {
            Point pos = ev.getPoint();
            targetBounds = new Rectangle(this.outline.x + pos.x, this.outline.y + pos.y, this.outline.width, this.outline.height);
            this.dragMarker.setHilighted(false);
            targetComponent = ev.getComponent().getParent();
        }
        Point targetOrigin = new Point(targetBounds.x, targetBounds.y);
        SwingUtilities.convertPointToScreen(targetOrigin, targetComponent);
        this.dragMarker.setBounds(targetOrigin.x, targetOrigin.y, targetBounds.width, targetBounds.height);
        this.dragMarker.setVisible(true);
        this.dragMarker.repaint();
    }

    void mouseReleased(WidgetMouseEvent ev) {
        if (!this.inDrag) {
            return;
        }
        if (this.dragMarker == null) {
            return;
        }
        this.dragMarker.dispose();
        this.dragMarker = null;
        DockingEvent event = null;
        BDialog detachedWindow = null;
        Point newWindowPos = null;
        if (this.dragTarget == null) {
            WidgetContainer parent = this.draggedWidget.getParent();
            while (!(parent instanceof WindowWidget)) {
                parent = parent.getParent();
            }
            if (parent instanceof DetachedDockingContainer) {
                parent = ((DetachedDockingContainer)parent).getParent();
            }
            detachedWindow = new DetachedDockingContainer((WindowWidget)parent);
            this.dragTarget = new DragTarget(((DetachedDockingContainer)detachedWindow).dock, 0, 0);
            newWindowPos = ev.getPoint();
            newWindowPos.x += this.outline.x;
            newWindowPos.y += this.outline.y;
            SwingUtilities.convertPointToScreen(newWindowPos, ev.getWidget().getComponent());
        }
        if (this.dragTarget != null) {
            DockingContainer dock = this.dragTarget.container;
            if (dock == this.originalContainer && this.dragTarget.tab == this.originalTab && (this.originalIndex == -1 || this.originalIndex == this.dragTarget.index || this.originalIndex == this.dragTarget.index - 1 || this.dragTarget.index == -1)) {
                return;
            }
            int tabToDisplay = dock.getSelectedTab();
            if (this.dragTarget.index == -1) {
                int n = this.dragTarget.index = this.dragTarget.tab == dock.getTabCount() ? 0 : dock.getTabChildCount(this.dragTarget.tab);
            }
            if (this.originalIndex == -1) {
                int i;
                DockableWidget[] widget = new DockableWidget[this.originalContainer.getTabChildCount(this.originalTab)];
                for (i = 0; i < widget.length; ++i) {
                    widget[i] = this.originalContainer.getChild(this.originalTab, i);
                }
                for (i = 0; i < widget.length; ++i) {
                    this.originalContainer.remove(widget[i]);
                }
                if (this.originalContainer == dock && this.originalTab < this.dragTarget.tab) {
                    --this.dragTarget.tab;
                }
                for (i = 0; i < widget.length; ++i) {
                    dock.addDockableWidget(widget[i], this.dragTarget.tab, this.dragTarget.index + i);
                }
                event = new DockingEvent(this.originalContainer, dock, widget);
            } else {
                if (this.originalContainer == dock) {
                    if (this.originalTab == this.dragTarget.tab && this.originalIndex < this.dragTarget.index) {
                        --this.dragTarget.index;
                    } else if (this.originalTab < this.dragTarget.tab && dock.getTabChildCount(this.originalTab) == 1) {
                        --this.dragTarget.tab;
                    }
                }
                this.originalContainer.remove(this.draggedWidget);
                dock.addDockableWidget(this.draggedWidget, this.dragTarget.tab, this.dragTarget.index);
                event = new DockingEvent(this.originalContainer, dock, new DockableWidget[]{this.draggedWidget});
            }
            if (tabToDisplay > -1 && tabToDisplay < dock.getTabCount()) {
                dock.setSelectedTab(tabToDisplay);
            }
        }
        this.originalContainer.layoutChildren();
        if (detachedWindow != null) {
            detachedWindow.pack();
            detachedWindow.setBounds(new Rectangle(newWindowPos.x, newWindowPos.y, detachedWindow.getBounds().width, detachedWindow.getBounds().height));
            detachedWindow.setVisible(true);
        }
        if (this.originalContainer.getChildCount() == 0 && this.originalContainer.getParent() instanceof DetachedDockingContainer) {
            ((DetachedDockingContainer)this.originalContainer.getParent()).dispose();
        }
        this.dragTarget = null;
        this.inDrag = false;
        if (event != null) {
            event.getSourceContainer().dispatchEvent(event);
            if (event.getTargetContainer() != event.getSourceContainer()) {
                event.getTargetContainer().dispatchEvent(event);
            }
        }
    }

    private DragTarget findDragTarget(WidgetMouseEvent ev) {
        WidgetContainer parent = ev.getWidget().getParent();
        while (!(parent instanceof WindowWidget)) {
            parent = parent.getParent();
        }
        if (parent instanceof DetachedDockingContainer) {
            parent = ((DetachedDockingContainer)parent).getParent();
        }
        DragTarget target = null;
        HashSet<DetachedDockingContainer> detached = detachedDocks.get(parent);
        if (detached != null) {
            DetachedDockingContainer dock;
            Iterator<DetachedDockingContainer> i$ = detached.iterator();
            while (i$.hasNext() && (target = this.findDragTargetInWindow(ev, dock = i$.next())) == null) {
            }
        }
        if (target == null) {
            target = this.findDragTargetInWindow(ev, (WindowWidget)parent);
        }
        return target;
    }

    private DragTarget findDragTargetInWindow(WidgetMouseEvent ev, WindowWidget window) {
        boolean found;
        Point pos = ev.getPoint();
        DragManager.tranformPointToWindow(ev.getWidget(), window, pos);
        DockingContainer dock = null;
        DragTarget target = null;
        WidgetContainer container = window;
        block0: do {
            found = false;
            for (Widget w : container.getChildren()) {
                if (!w.getComponent().isShowing()) continue;
                Rectangle bounds = w.getComponent().getBounds();
                DragManager.tranformRectangleToWindow(w, bounds);
                if (!bounds.contains(pos)) continue;
                if (w instanceof DockingContainer) {
                    int i;
                    dock = (DockingContainer)w;
                    int tab = dock.getSelectedTab();
                    if (tab > -1) {
                        for (i = 0; i <= dock.getTabChildCount(tab); ++i) {
                            Rectangle insertionBounds = DragManager.findInsertionAreaBounds(dock, tab, i);
                            DragManager.tranformRectangleToWindow(dock, insertionBounds);
                            if (!insertionBounds.contains(pos)) continue;
                            target = new DragTarget(dock, tab, i);
                        }
                    }
                    for (i = 0; i <= dock.getTabCount(); ++i) {
                        Rectangle tabBounds = dock.getTabBounds(i);
                        if (tabBounds == null) continue;
                        DragManager.tranformRectangleToWindow(dock, tabBounds);
                        if (!tabBounds.contains(pos)) continue;
                        target = new DragTarget(dock, i, -1);
                    }
                }
                if (!(w instanceof WidgetContainer)) continue block0;
                container = (WidgetContainer)w;
                found = true;
                continue block0;
            }
        } while (found && target == null);
        return target;
    }

    private static Rectangle findInsertionAreaBounds(DockingContainer dock, int tab, int index) {
        boolean vertical;
        Rectangle bounds = dock.getChild(tab, index == 0 ? 0 : index - 1).getBounds();
        boolean bl = vertical = dock.getTabPosition() == BTabbedPane.LEFT || dock.getTabPosition() == BTabbedPane.RIGHT;
        if (index > 0) {
            if (vertical) {
                bounds.y += bounds.height / 2;
            } else {
                bounds.x += bounds.width / 2;
            }
        }
        if (vertical) {
            bounds.height /= 2;
        } else {
            bounds.width /= 2;
        }
        if (index > 0 && index < dock.getTabChildCount(tab)) {
            Rectangle nextBounds = dock.getChild(tab, index).getBounds();
            if (vertical) {
                bounds.height = nextBounds.y + nextBounds.height / 2 - bounds.y;
            } else {
                bounds.width = nextBounds.x + nextBounds.width / 2 - bounds.x;
            }
        }
        return bounds;
    }

    private static void tranformPointToWindow(Widget widget, WindowWidget window, Point point) {
        SwingUtilities.convertPointToScreen(point, widget.getComponent());
        SwingUtilities.convertPointFromScreen(point, window.getComponent());
    }

    private static void tranformRectangleToWindow(Widget widget, Rectangle rect) {
        Container parent = widget.getComponent().getParent();
        while (!(parent instanceof Window)) {
            rect.x += parent.getX();
            rect.y += parent.getY();
            parent = parent.getParent();
        }
    }

    static {
        BufferedImage dithered = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(2, 2);
        dithered.setRGB(0, 0, -1);
        dithered.setRGB(1, 1, -1);
        dithered.setRGB(0, 1, -16777216);
        dithered.setRGB(1, 0, -16777216);
        ditheredPaint = new TexturePaint(dithered, new Rectangle(2, 2));
        detachedDocks = new WeakHashMap();
    }

    public static class DetachedDockingContainer
    extends BDialog {
        private DockingContainer dock = new DockingContainer();

        public DetachedDockingContainer(WindowWidget parentWindow) {
            super(parentWindow, false);
            this.setContent(this.dock);
            HashSet<DetachedDockingContainer> detached = (HashSet<DetachedDockingContainer>)detachedDocks.get(parentWindow);
            if (detached == null) {
                detached = new HashSet<DetachedDockingContainer>();
                detachedDocks.put(parentWindow, detached);
            }
            detached.add(this);
            this.dock.addEventLink(DockingEvent.class, new Object(){

                void processEvent() {
                    DetachedDockingContainer.this.dock.getSplitPane().getComponent().setDividerSize(0);
                }
            });
        }

        public DockingContainer getDockingContainer() {
            return this.dock;
        }

        public void dispose() {
            ((HashSet)detachedDocks.get(this.getParent())).remove(this);
            super.dispose();
        }
    }

    private static class DragMarker
    extends JWindow {
        private boolean hilight;

        DragMarker(Component parent) {
            super(SwingUtilities.getWindowAncestor(parent));
            if (System.getProperty("os.name", "").toLowerCase().startsWith("mac os x")) {
                this.setBackground(new Color(0, 0, 0, 0));
            } else {
                this.setBackground(Color.WHITE);
            }
            this.add((Component)new JPanel(){

                public void paintComponent(Graphics g) {
                    Dimension size = this.getSize();
                    Graphics2D g2 = (Graphics2D)g;
                    g2.clearRect(0, 0, this.getWidth(), this.getHeight());
                    if (DragMarker.this.hilight) {
                        g2.setPaint(ditheredPaint);
                        g2.setStroke(new BasicStroke(2.0f));
                        g2.drawRect(1, 1, size.width - 2, size.height - 2);
                    } else {
                        g2.setColor(Color.black);
                        g2.setStroke(new BasicStroke(1.0f));
                        g2.drawRect(0, 0, size.width - 1, size.height - 1);
                    }
                }
            }, "Center");
        }

        public void setHilighted(boolean hilight) {
            this.hilight = hilight;
        }
    }

    private static class DragTarget {
        public DockingContainer container;
        public int tab;
        public int index;

        DragTarget(DockingContainer container, int tab, int index) {
            this.container = container;
            this.tab = tab;
            this.index = index;
        }
    }
}

