/*
 * Decompiled with CFR 0.152.
 */
package buoyx.docking;

import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.internal.SingleWidgetPanel;
import buoy.internal.WidgetContainerPanel;
import buoy.widget.BSplitPane;
import buoy.widget.BTabbedPane;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoyx.docking.DockableWidget;
import buoyx.docking.DragManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockingContainer
extends WidgetContainer {
    private Widget content;
    private ArrayList<ArrayList<DockableWidget>> childrenInTab;
    private BTabbedPane.TabPosition tabPosition;
    private BSplitPane splitPane;
    private BTabbedPane tabs;
    private boolean hideSingleTab;
    private int visibleDividerSize;

    public DockingContainer() {
        this.component = new WidgetContainerPanel(this);
        this.splitPane = new BSplitPane(BSplitPane.HORIZONTAL);
        this.splitPane.getComponent().setBorder(null);
        this.tabPosition = BTabbedPane.TOP;
        ((Container)this.getComponent()).add(this.splitPane.getComponent());
        this.setAsParent(this.splitPane);
        this.childrenInTab = new ArrayList();
        this.visibleDividerSize = this.splitPane.getComponent().getDividerSize();
    }

    public DockingContainer(Widget content, BTabbedPane.TabPosition tabPosition) {
        this();
        this.setTabPosition(tabPosition);
        this.setContent(content);
    }

    public Widget getContent() {
        return this.content;
    }

    public void setContent(Widget widget) {
        if (widget != null && widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        if (this.content != null) {
            this.splitPane.remove(this.content);
        }
        this.content = widget;
        if (this.content != null) {
            this.splitPane.add(this.content, this.tabPosition == BTabbedPane.BOTTOM || this.tabPosition == BTabbedPane.RIGHT ? 0 : 1);
            this.setAsParent(this.content);
        }
    }

    public void addDockableWidget(DockableWidget widget) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        ArrayList<DockableWidget> newTab = new ArrayList<DockableWidget>();
        newTab.add(widget);
        this.childrenInTab.add(newTab);
        this.rebuildContents(this.getDockedChildCount() > 1 && (this.content == null || !this.content.getBounds().equals(this.splitPane.getBounds())));
    }

    public void addDockableWidget(DockableWidget widget, int tab, int indexInTab) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        if (tab == this.childrenInTab.size() && indexInTab == 0) {
            this.addDockableWidget(widget);
            return;
        }
        this.childrenInTab.get(tab).add(indexInTab, widget);
        this.rebuildContents(this.getDockedChildCount() > 1 && (this.content == null || !this.content.getBounds().equals(this.splitPane.getBounds())));
    }

    public int getChildTabIndex(DockableWidget widget) {
        for (int i = 0; i < this.childrenInTab.size(); ++i) {
            if (!this.childrenInTab.get(i).contains(widget)) continue;
            return i;
        }
        return -1;
    }

    public int getChildIndexInTab(DockableWidget widget) {
        for (ArrayList<DockableWidget> children : this.childrenInTab) {
            int index = children.indexOf(widget);
            if (index <= -1) continue;
            return index;
        }
        return -1;
    }

    public int getTabCount() {
        return this.childrenInTab.size();
    }

    public int getTabChildCount(int tabIndex) {
        return this.childrenInTab.get(tabIndex).size();
    }

    public BTabbedPane.TabPosition getTabPosition() {
        return this.tabPosition;
    }

    public void setTabPosition(BTabbedPane.TabPosition position) {
        this.tabPosition = position;
        this.splitPane.setOrientation(this.tabPosition == BTabbedPane.TOP || this.tabPosition == BTabbedPane.BOTTOM ? BSplitPane.VERTICAL : BSplitPane.HORIZONTAL);
        if (this.content != null) {
            Widget theContent = this.content;
            this.remove(this.content);
            this.setContent(theContent);
        }
        this.rebuildContents(true);
    }

    public int getSelectedTab() {
        if (this.tabs == null) {
            return this.childrenInTab.size() == 0 ? -1 : 0;
        }
        return this.tabs.getSelectedTab();
    }

    public void setSelectedTab(int index) {
        if (this.tabs != null) {
            this.tabs.setSelectedTab(index);
        }
    }

    public boolean getHideSingleTab() {
        return this.hideSingleTab;
    }

    public void setHideSingleTab(boolean hide) {
        this.hideSingleTab = hide;
        if (this.childrenInTab.size() == 1) {
            this.rebuildContents(true);
        }
    }

    public void resetToPreferredSizes(int tabIndex) {
        Widget child;
        if (this.tabs == null) {
            int dockPosition = this.tabPosition == BTabbedPane.BOTTOM || this.tabPosition == BTabbedPane.RIGHT ? 1 : 0;
            child = this.splitPane.getChild(dockPosition);
        } else {
            child = this.tabs.getChild(tabIndex);
        }
        if (child != null) {
            this.recursivelyResetToPreferredSizes(child.getComponent());
        }
    }

    private void recursivelyResetToPreferredSizes(Component c) {
        if (c instanceof SingleWidgetPanel) {
            c = ((SingleWidgetPanel)c).getComponent(0);
        }
        if (c instanceof JSplitPane) {
            JSplitPane js = (JSplitPane)c;
            js.resetToPreferredSizes();
            this.recursivelyResetToPreferredSizes(js.getTopComponent());
            this.recursivelyResetToPreferredSizes(js.getBottomComponent());
        }
    }

    Rectangle getTabBounds(int index) {
        Rectangle tabBounds;
        if (this.tabs == null) {
            Rectangle bounds = this.getBounds();
            int TAB_REGION_SIZE = 30;
            if (this.tabPosition == BTabbedPane.TOP) {
                return new Rectangle(0, 0, bounds.width, 30);
            }
            if (this.tabPosition == BTabbedPane.BOTTOM) {
                return new Rectangle(0, bounds.height - 30, bounds.width, 30);
            }
            if (this.tabPosition == BTabbedPane.LEFT) {
                return new Rectangle(0, 0, 30, bounds.height);
            }
            return new Rectangle(bounds.width - 30, 0, 30, bounds.height);
        }
        if (index < this.getTabCount()) {
            tabBounds = this.tabs.getComponent().getBoundsAt(index);
        } else {
            Rectangle lastTabBounds;
            int lastVisibleTab = this.getTabCount() - 1;
            do {
                if ((lastTabBounds = this.tabs.getComponent().getBoundsAt(lastVisibleTab)) == null) {
                    --lastVisibleTab;
                }
                if (lastVisibleTab != -1) continue;
                return null;
            } while (lastTabBounds == null);
            Rectangle bounds = this.tabs.getBounds();
            tabBounds = this.tabPosition == BTabbedPane.TOP || this.tabPosition == BTabbedPane.BOTTOM ? new Rectangle(lastTabBounds.x + lastTabBounds.width, lastTabBounds.y, bounds.x + bounds.width - lastTabBounds.x - lastTabBounds.width, lastTabBounds.height) : new Rectangle(lastTabBounds.x, lastTabBounds.y + lastTabBounds.height, lastTabBounds.width, bounds.y + bounds.height - lastTabBounds.y - lastTabBounds.height);
        }
        if (tabBounds == null) {
            return null;
        }
        if (this.tabs != null) {
            for (Container parent = this.tabs.getComponent().getParent(); parent != this.getComponent(); parent = parent.getParent()) {
                tabBounds.x += parent.getX();
                tabBounds.y += parent.getY();
            }
        }
        return tabBounds;
    }

    private void rebuildContents(boolean preserveSize) {
        int mainPosition = this.tabPosition == BTabbedPane.BOTTOM || this.tabPosition == BTabbedPane.RIGHT ? 0 : 1;
        BSplitPane.Orientation splitOrient = this.tabPosition == BTabbedPane.LEFT || this.tabPosition == BTabbedPane.RIGHT ? BSplitPane.VERTICAL : BSplitPane.HORIZONTAL;
        this.splitPane.setResizeWeight(this.tabPosition == BTabbedPane.BOTTOM || this.tabPosition == BTabbedPane.RIGHT ? 1.0 : 0.0);
        int splitLocation = this.splitPane.getDividerLocation();
        for (Widget child : this.getChildren()) {
            if (child == this.content) continue;
            this.removeAsParent(child);
        }
        this.splitPane.remove(1 - mainPosition);
        if (this.getDockedChildCount() == 0) {
            this.tabs = null;
            this.splitPane.remove(1 - mainPosition);
            this.splitPane.getComponent().setDividerSize(0);
            return;
        }
        this.splitPane.getComponent().setDividerSize(this.visibleDividerSize);
        Widget[] tabContents = new Widget[this.childrenInTab.size()];
        for (int i = 0; i < tabContents.length; ++i) {
            ArrayList<DockableWidget> children = this.childrenInTab.get(i);
            if (children.size() == 1) {
                tabContents[i] = children.get(0);
                continue;
            }
            BSplitPane split = new BSplitPane(splitOrient);
            split.setResizeWeight(1.0 / (double)children.size());
            tabContents[i] = split;
            split.add(children.get(0), 0);
            for (int j = 1; j < children.size() - 1; ++j) {
                BSplitPane nextSplit = new BSplitPane(splitOrient);
                nextSplit.getComponent().setBorder(null);
                nextSplit.setResizeWeight(1.0 / (double)(children.size() - j));
                split.add(nextSplit, 1);
                split = nextSplit;
                split.add(children.get(j), 0);
            }
            split.add(children.get(children.size() - 1), 1);
        }
        if (tabContents.length == 1 && this.hideSingleTab) {
            this.splitPane.add(tabContents[0], 1 - mainPosition);
            this.tabs = null;
        } else if (tabContents.length > 0) {
            this.tabs = new BTabbedPane(this.tabPosition);
            DragManager manager = DragManager.getDragManager();
            this.tabs.addEventLink(MousePressedEvent.class, (Object)this, "mousePressedOnTab");
            this.tabs.addEventLink(MouseDraggedEvent.class, (Object)manager, "mouseDragged");
            this.tabs.addEventLink(MouseReleasedEvent.class, (Object)manager, "mouseReleased");
            for (int i = 0; i < tabContents.length; ++i) {
                ArrayList<DockableWidget> children = this.childrenInTab.get(i);
                StringBuffer label = new StringBuffer();
                for (int j = 0; j < children.size(); ++j) {
                    if (j > 0) {
                        label.append(", ");
                    }
                    label.append(children.get(j).getLabel());
                }
                this.tabs.add(tabContents[i], label.toString());
            }
            this.splitPane.add(this.tabs, 1 - mainPosition);
        }
        for (ArrayList<DockableWidget> children : this.childrenInTab) {
            for (DockableWidget widget : children) {
                this.setAsParent(widget);
            }
        }
        if (preserveSize) {
            this.splitPane.setDividerLocation(splitLocation);
        } else {
            this.splitPane.resetToPreferredSizes();
        }
        this.invalidateSize();
    }

    private void mousePressedOnTab(MousePressedEvent ev) {
        Point pos = ev.getPoint();
        JTabbedPane tp = this.tabs.getComponent();
        for (int i = 0; i < this.getTabCount(); ++i) {
            Rectangle bounds = tp.getBoundsAt(i);
            if (!bounds.contains(pos)) continue;
            bounds.x -= pos.x;
            bounds.y -= pos.y;
            DragManager.getDragManager().beginDraggingTab(this, i, bounds);
        }
    }

    @Override
    public int getChildCount() {
        int count = this.content == null ? 0 : 1;
        for (ArrayList<DockableWidget> tab : this.childrenInTab) {
            count += tab.size();
        }
        return count;
    }

    private int getDockedChildCount() {
        return this.getChildCount() - (this.content == null ? 0 : 1);
    }

    @Override
    public Collection<Widget> getChildren() {
        ArrayList<Widget> children = new ArrayList<Widget>(0);
        if (this.content != null) {
            children.add(this.content);
        }
        for (ArrayList<DockableWidget> thisTab : this.childrenInTab) {
            children.addAll(thisTab);
        }
        return children;
    }

    public DockableWidget getChild(int tab, int index) {
        return this.childrenInTab.get(tab).get(index);
    }

    @Override
    public void remove(Widget widget) {
        if (widget == this.content) {
            this.setContent(null);
        } else {
            for (int i = 0; i < this.childrenInTab.size(); ++i) {
                ArrayList<DockableWidget> thisTab = this.childrenInTab.get(i);
                int index = thisTab.indexOf(widget);
                if (index <= -1) continue;
                thisTab.remove(index);
                this.removeAsParent(widget);
                if (thisTab.size() == 0) {
                    this.childrenInTab.remove(i);
                }
                this.rebuildContents(this.getDockedChildCount() > 0);
                return;
            }
        }
    }

    @Override
    public void removeAll() {
        for (ArrayList<DockableWidget> thisTab : this.childrenInTab) {
            for (DockableWidget widget : thisTab) {
                this.removeAsParent(widget);
            }
        }
        this.childrenInTab.clear();
        this.setContent(null);
    }

    @Override
    public void layoutChildren() {
        this.splitPane.getComponent().setBounds(this.getBounds());
        this.splitPane.layoutChildren();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.splitPane.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.splitPane.getPreferredSize();
    }

    public BSplitPane getSplitPane() {
        return this.splitPane;
    }
}

