/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.util;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadManager {
    private int numIndices;
    private AtomicInteger nextIndex;
    private Thread[] thread;
    private HashSet<Thread> waitingThreads;
    private Task task;
    private Object controller;
    private boolean controllerWaiting;
    private int maxThreads;

    public ThreadManager() {
        this(0, null);
    }

    public ThreadManager(int numIndices, Task task) {
        this.numIndices = numIndices;
        this.task = task;
        this.nextIndex = new AtomicInteger(numIndices);
        this.controller = new Object();
        this.controllerWaiting = false;
        this.waitingThreads = new HashSet();
        this.maxThreads = -1;
    }

    private void createThreads() {
        int numThreads = Runtime.getRuntime().availableProcessors();
        if (this.maxThreads > 0 && this.maxThreads < numThreads) {
            numThreads = this.maxThreads;
        }
        this.thread = new Thread[numThreads];
        for (int i = 0; i < this.thread.length; ++i) {
            this.thread[i] = new Thread("Worker thread " + (i + 1)){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                int index = ThreadManager.this.nextIndex();
                                ThreadManager.this.task.execute(index);
                            }
                        }
                        catch (InterruptedException ex) {
                            ThreadManager.this.task.cleanup();
                            return;
                        }
                        catch (Exception ex) {
                            ThreadManager.this.cancel();
                            ex.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            this.thread[i].start();
        }
    }

    public void setNumIndices(int numIndices) {
        this.numIndices = numIndices;
        this.nextIndex.set(numIndices);
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.controllerWaiting = false;
        this.nextIndex.set(0);
        this.waitingThreads.clear();
        if (this.thread == null) {
            this.createThreads();
        }
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = this.controller;
        synchronized (object) {
            try {
                this.controllerWaiting = true;
                this.controller.wait();
            }
            catch (InterruptedException ex) {
                this.finish();
            }
        }
    }

    public void cancel() {
        this.nextIndex.set(this.numIndices);
    }

    public void finish() {
        if (this.thread != null) {
            for (int i = 0; i < this.thread.length; ++i) {
                this.thread[i].interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextIndex() throws InterruptedException {
        int index;
        while ((index = this.nextIndex.getAndIncrement()) >= this.numIndices) {
            ThreadManager threadManager = this;
            synchronized (threadManager) {
                this.waitingThreads.add(Thread.currentThread());
                if (this.waitingThreads.size() == this.thread.length) {
                    while (!this.controllerWaiting) {
                        this.wait(1L);
                    }
                    Object object = this.controller;
                    synchronized (object) {
                        this.controller.notify();
                    }
                }
                this.wait();
            }
        }
        return index;
    }

    public static interface Task {
        public void execute(int var1);

        public void cleanup();
    }
}

