/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.Property;
import artofillusion.math.RGBColor;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueChecker;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSelector;
import buoy.event.FocusLostEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.MouseClickedEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BTextField;
import buoy.widget.CustomWidget;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class PropertyEditor {
    private final Property property;
    private final Widget widget;

    public PropertyEditor(Property property, Object value) {
        this.property = property;
        if (property.getType() == Property.DOUBLE) {
            this.widget = new ValueSelector(0.0, property.getMinimum(), property.getMaximum(), 0.005);
        } else if (property.getType() == Property.INTEGER) {
            this.widget = new ValueField(0.0, 4);
            final Property prop = property;
            ((ValueField)this.widget).setValueChecker(new ValueChecker(){

                public boolean isValid(double val) {
                    return val >= prop.getMinimum() && val <= prop.getMaximum();
                }
            });
        } else if (property.getType() == Property.BOOLEAN) {
            this.widget = new BCheckBox(property.getName(), false);
        } else if (property.getType() == Property.STRING) {
            this.widget = new BTextField(15);
        } else if (property.getType() == Property.COLOR) {
            this.widget = new ColorSelector(property.getName());
        } else if (property.getType() == Property.ENUMERATION) {
            this.widget = new BComboBox(property.getAllowedValues());
        } else {
            throw new IllegalArgumentException("Unknown Property type");
        }
        if (this.widget instanceof BTextField) {
            this.widget.addEventLink(FocusLostEvent.class, (Object)this, "stringValueChanged");
            this.widget.addEventLink(KeyPressedEvent.class, (Object)this, "stringValueChanged");
        }
        if (value != null) {
            this.setValue(value);
        }
    }

    public Property getProperty() {
        return this.property;
    }

    public Widget getWidget() {
        return this.widget;
    }

    public String getLabel() {
        if (this.property.getType() == Property.BOOLEAN) {
            return null;
        }
        return this.property.getName();
    }

    public Object getValue() {
        if (this.widget instanceof ValueSelector) {
            return ((ValueSelector)this.widget).getValue();
        }
        if (this.widget instanceof ValueField) {
            return (int)((ValueField)this.widget).getValue();
        }
        if (this.widget instanceof BCheckBox) {
            return ((BCheckBox)this.widget).getState();
        }
        if (this.widget instanceof BTextField) {
            return ((BTextField)this.widget).getText();
        }
        if (this.widget instanceof ColorSelector) {
            return ((ColorSelector)this.widget).getColor();
        }
        if (this.widget instanceof BComboBox) {
            return ((BComboBox)this.widget).getSelectedValue();
        }
        throw new AssertionError((Object)"Unexpected Widget type");
    }

    public void setValue(Object value) {
        if (this.widget instanceof ValueSelector) {
            ((ValueSelector)this.widget).setValue(value == null ? Double.NaN : (Double)value);
        } else if (this.widget instanceof ValueField) {
            ((ValueField)this.widget).setValue(value == null ? Double.NaN : (double)((Integer)value).intValue());
        } else if (this.widget instanceof BCheckBox) {
            ((BCheckBox)this.widget).setState(value == null ? false : (Boolean)value);
        } else if (this.widget instanceof BTextField) {
            ((BTextField)this.widget).setText((String)value);
        } else if (this.widget instanceof ColorSelector) {
            ((ColorSelector)this.widget).setColor((RGBColor)value);
        } else if (this.widget instanceof BComboBox) {
            ((BComboBox)this.widget).setSelectedValue(value);
        }
    }

    private void stringValueChanged(WidgetEvent ev) {
        if (ev instanceof FocusLostEvent || ev instanceof KeyPressedEvent && ((KeyPressedEvent)ev).getKeyCode() == 10) {
            this.widget.dispatchEvent(new ValueChangedEvent(ev.getWidget(), false));
        }
    }

    private class ColorSelector
    extends CustomWidget {
        private String title;
        private RGBColor color;

        ColorSelector(String title) {
            this.title = title;
            this.color = new RGBColor();
            this.setPreferredSize(new Dimension(30, 15));
            this.setMaximumSize(new Dimension(30, 15));
            this.setBackground(this.color.getColor());
            ((JComponent)this.getComponent()).setBorder(BorderFactory.createLoweredBevelBorder());
            this.addEventLink(MouseClickedEvent.class, this);
        }

        public RGBColor getColor() {
            return this.color.duplicate();
        }

        public void setColor(RGBColor color) {
            if (color == null) {
                this.color = null;
                this.setBackground(Color.GRAY);
            } else {
                this.color = color.duplicate();
                this.setBackground(color.getColor());
            }
        }

        private void processEvent() {
            if (this.color != null) {
                RGBColor oldColor = this.color.duplicate();
                new ColorChooser(UIUtilities.findFrame(this), this.title, this.color);
                if (!this.color.equals(oldColor)) {
                    this.setBackground(this.color.getColor());
                    this.dispatchEvent(new ValueChangedEvent(this));
                }
            }
        }
    }
}

