/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.CommandEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Insets;

public class ComponentsDialog
extends BDialog {
    private Widget[] comp;
    private boolean ok;
    private Runnable okCallback;
    private Runnable cancelCallback;
    private BButton okButton;
    private BButton cancelButton;

    public ComponentsDialog(WindowWidget parent, String prompt, Widget[] components, String[] labels) {
        this(parent, prompt, components, labels, null, null);
    }

    public ComponentsDialog(WindowWidget parent, String prompt, Widget[] components, String[] labels, Runnable onOK, Runnable onCancel) {
        super(parent, onOK == null && onCancel == null);
        this.comp = components;
        this.okCallback = onOK;
        this.cancelCallback = onCancel;
        BorderContainer content = new BorderContainer();
        this.setContent(content);
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(10, 10, 10, 10), null));
        content.add(new BLabel(prompt), BorderContainer.NORTH);
        FormContainer center = new FormContainer(new double[]{0.0, 1.0}, new double[components.length]);
        content.add(center, BorderContainer.CENTER);
        for (int i = 0; i < components.length; ++i) {
            if (labels[i] == null) {
                center.add(components[i], 0, i, 2, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(2, 0, 2, 0), null));
            } else {
                center.add(new BLabel(labels[i]), 0, i, new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(2, 0, 2, 5), null));
                center.add(components[i], 1, i, new LayoutInfo(LayoutInfo.WEST, LayoutInfo.BOTH, new Insets(2, 0, 2, 0), null));
            }
            components[i].addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
        }
        RowContainer buttons = new RowContainer();
        content.add(buttons, BorderContainer.SOUTH);
        this.okButton = Translate.button("ok", this, "buttonPressed");
        buttons.add(this.okButton);
        this.cancelButton = Translate.button("cancel", this, "buttonPressed");
        buttons.add(this.cancelButton);
        this.okButton.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
        this.cancelButton.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
        this.addEventLink(WindowClosingEvent.class, new Object(){

            void processEvent() {
                ComponentsDialog.this.ok = false;
                ComponentsDialog.this.closeWindow();
            }
        });
        this.setDefaultButton(this.okButton);
        this.pack();
        this.setResizable(false);
        UIUtilities.centerDialog(this, parent);
        this.setVisible(true);
    }

    public boolean clickedOk() {
        return this.ok;
    }

    public void setOkEnabled(boolean enabled) {
        this.okButton.setEnabled(enabled);
    }

    private void buttonPressed(CommandEvent e) {
        String command = e.getActionCommand();
        this.ok = !command.equals("cancel");
        this.closeWindow();
    }

    private void closeWindow() {
        if (this.ok && this.okCallback != null) {
            this.okCallback.run();
        }
        if (!this.ok && this.cancelCallback != null) {
            this.cancelCallback.run();
        }
        this.dispose();
        for (int i = 0; i < this.comp.length; ++i) {
            this.comp[i].removeEventLink(KeyPressedEvent.class, this);
        }
    }

    private void keyPressed(KeyPressedEvent ev) {
        int code = ev.getKeyCode();
        if (code == 27) {
            this.closeWindow();
        }
    }
}

