/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.RenderingTriangle;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformTexture;
import artofillusion.texture.UniformTriangle;
import artofillusion.ui.Translate;
import buoy.event.ValueChangedEvent;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class UniformMapping
extends TextureMapping {
    Object3D object;
    UniformTexture texture;

    public UniformMapping(Object3D theObject, Texture theTexture) {
        this.object = theObject;
        this.texture = (UniformTexture)theTexture;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public Object3D getObject() {
        return this.object;
    }

    public RenderingTriangle mapTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3[] vert) {
        return new UniformTriangle(v1, v2, v3, n1, n2, n3);
    }

    public void getTextureSpec(Vec3 pos, TextureSpec spec, double angle, double size, double t, double[] param) {
        if (!this.appliesToFace(angle > 0.0)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        this.texture.getTextureSpec(spec);
    }

    public void getTransparency(Vec3 pos, RGBColor trans, double angle, double size, double t, double[] param) {
        if (!this.appliesToFace(angle > 0.0)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        this.texture.getTransparency(trans);
    }

    public double getDisplacement(Vec3 pos, double size, double t, double[] param) {
        return 0.0;
    }

    public static boolean legalMapping(Object3D obj, Texture tex) {
        return tex instanceof UniformTexture;
    }

    public TextureMapping duplicate() {
        UniformMapping map = new UniformMapping(this.object, this.texture);
        map.setAppliesTo(this.appliesTo());
        return map;
    }

    public TextureMapping duplicate(Object3D obj, Texture tex) {
        UniformMapping map = new UniformMapping(obj, tex);
        map.setAppliesTo(this.appliesTo());
        return map;
    }

    public void copy(TextureMapping map) {
        this.setAppliesTo(map.appliesTo());
    }

    public Widget getEditingPanel(Object3D obj, final MaterialPreviewer preview) {
        RowContainer row = new RowContainer();
        final BComboBox c = new BComboBox(new String[]{Translate.text("frontAndBackFaces"), Translate.text("frontFacesOnly"), Translate.text("backFacesOnly")});
        row.add(new BLabel(Translate.text("applyTo") + ":"));
        row.add(c);
        c.setSelectedIndex(this.appliesTo());
        c.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                UniformMapping.this.setAppliesTo((short)c.getSelectedIndex());
                preview.setTexture(UniformMapping.this.getTexture(), UniformMapping.this);
                preview.render();
            }
        });
        return row;
    }

    public UniformMapping(DataInputStream in, Object3D theObject, Texture theTexture) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        if (version == 1) {
            this.setAppliesTo(in.readShort());
        }
        this.object = theObject;
        this.texture = (UniformTexture)theTexture;
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeShort(1);
        out.writeShort(this.appliesTo());
    }
}

