/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.FastMath;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueSlider;
import buoy.widget.BFrame;
import buoy.widget.Widget;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class BrickModule
extends Module {
    boolean valueOk;
    boolean gradOk;
    double value;
    double error;
    double gap = 0.1;
    double offset = 0.5;
    double height = 0.5;
    double lastBlur;
    PointInfo point;
    Vec3 gradient = new Vec3();

    public BrickModule(Point position) {
        super(Translate.text("menu.bricksModule"), new IOPort[]{new IOPort(0, 0, 2, new String[]{"X", "(X)"}), new IOPort(0, 0, 2, new String[]{"Y", "(Y)"}), new IOPort(0, 0, 2, new String[]{"Z", "(Z)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Value"})}, position);
    }

    public double getBrickHeight() {
        return this.height;
    }

    public void setBrickHeight(double h) {
        this.height = h;
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double g) {
        this.gap = g;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double o) {
        this.offset = o;
    }

    public void init(PointInfo p) {
        this.point = p;
        this.gradOk = false;
        this.valueOk = false;
    }

    public double getAverageValue(int which, double blur) {
        double zsize;
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        this.valueOk = true;
        this.lastBlur = blur;
        double hinv = 1.0 / this.height;
        double xsize = this.linkFrom[0] == null ? 0.5 * this.point.xsize + blur : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        double ysize = this.linkFrom[1] == null ? 0.5 * hinv * this.point.ysize + blur : hinv * this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
        double d = zsize = this.linkFrom[2] == null ? 0.5 * this.point.zsize + blur : this.linkFrom[2].getValueError(this.linkFromIndex[2], blur);
        if (xsize >= 0.5 || ysize >= 0.5 || zsize >= 0.5) {
            this.value = 1.0 - 3.0 * this.gap;
            this.error = 0.5;
            this.gradient.set(0.0, 0.0, 0.0);
            this.gradOk = true;
            return this.value;
        }
        double x = this.linkFrom[0] == null ? this.point.x : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double y = this.linkFrom[1] == null ? hinv * this.point.y : hinv * this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        double z = this.linkFrom[2] == null ? this.point.z : this.linkFrom[2].getAverageValue(this.linkFromIndex[2], blur);
        double d2 = (FastMath.floor(y) & 1) == 0 ? 0.5 * this.offset : -0.5 * this.offset;
        double x1 = (x += d2) - (double)FastMath.round(x);
        double y1 = y - (double)FastMath.round(y);
        double z1 = (z += d2 + 0.5) - (double)FastMath.round(z);
        double xf = Math.abs(x1);
        double yf = Math.abs(y1);
        double zf = Math.abs(z1);
        double halfgap = 0.5 * this.gap;
        if (xf > halfgap + xsize && yf > hinv * halfgap + ysize && zf > halfgap + zsize) {
            this.value = 1.0;
            this.error = 0.0;
            this.gradient.set(0.0, 0.0, 0.0);
            this.gradOk = true;
        } else if (xf < halfgap - xsize || yf < hinv * halfgap - ysize || zf < halfgap - zsize) {
            this.error = 0.0;
            this.value = 0.0;
            this.gradient.set(0.0, 0.0, 0.0);
            this.gradOk = true;
        } else {
            double weight;
            double e1 = (xf - halfgap) / xsize;
            double e2 = (yf - hinv * halfgap) / ysize;
            double e3 = (zf - halfgap) / zsize;
            if (e1 < e2 && e1 < e3) {
                weight = 0.5 - 0.5 * e1;
                this.gradient.set((x1 > 0.0 ? 1.0 : -1.0) / xsize, 0.0, 0.0);
            } else if (e2 < e1 && e2 < e3) {
                weight = 0.5 - 0.5 * e2;
                this.gradient.set(0.0, (y1 > 0.0 ? 1.0 : -1.0) / ysize, 0.0);
            } else {
                weight = 0.5 - 0.5 * e3;
                this.gradient.set(0.0, 0.0, (z1 > 0.0 ? 1.0 : -1.0) / zsize);
            }
            this.error = Math.abs(this.error);
            this.value = 1.0 - weight;
        }
        return this.value;
    }

    public double getValueError(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        return this.error;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        if (this.gradOk) {
            grad.set(this.gradient);
            return;
        }
        double dx = this.gradient.x;
        double dy = this.gradient.y;
        double dz = this.gradient.z;
        if (dx != 0.0) {
            if (this.linkFrom[0] == null) {
                this.gradient.set(dx, 0.0, 0.0);
            } else {
                this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
                this.gradient.x = dx * grad.x;
                this.gradient.y = dx * grad.y;
                this.gradient.z = dx * grad.z;
            }
        } else {
            this.gradient.set(0.0, 0.0, 0.0);
        }
        if (dy != 0.0) {
            if (this.linkFrom[1] == null) {
                this.gradient.y += dy;
            } else {
                this.linkFrom[1].getValueGradient(this.linkFromIndex[1], grad, blur);
                this.gradient.x += dy * grad.x;
                this.gradient.y += dy * grad.y;
                this.gradient.z += dy * grad.z;
            }
        }
        if (dz != 0.0) {
            if (this.linkFrom[2] == null) {
                this.gradient.z += dz;
            } else {
                this.linkFrom[2].getValueGradient(this.linkFromIndex[2], grad, blur);
                this.gradient.x += dz * grad.x;
                this.gradient.y += dz * grad.y;
                this.gradient.z += dz * grad.z;
            }
        }
        this.gradOk = true;
        grad.set(this.gradient);
    }

    public boolean edit(BFrame fr, Scene theScene) {
        ValueSlider heightSlider = new ValueSlider(0.0, 1.0, 100, this.height);
        ValueSlider gapSlider = new ValueSlider(0.0, 0.5, 50, this.gap);
        ValueSlider offsetSlider = new ValueSlider(0.0, 0.5, 50, this.offset);
        ComponentsDialog dlg = new ComponentsDialog(fr, "Set brick properties:", new Widget[]{heightSlider, gapSlider, offsetSlider}, new String[]{"Brick Height", "Gap Width", "Row Offset"});
        if (!dlg.clickedOk()) {
            return false;
        }
        this.height = heightSlider.getValue();
        this.gap = gapSlider.getValue();
        this.offset = offsetSlider.getValue();
        return true;
    }

    public Module duplicate() {
        BrickModule mod = new BrickModule(new Point(this.bounds.x, this.bounds.y));
        mod.height = this.height;
        mod.gap = this.gap;
        mod.offset = this.offset;
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeDouble(this.height);
        out.writeDouble(this.gap);
        out.writeDouble(this.offset);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.height = in.readDouble();
        this.gap = in.readDouble();
        this.offset = in.readDouble();
    }
}

