/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.ExternalObjectEditingWindow;
import artofillusion.Scene;
import artofillusion.animation.Keyframe;
import artofillusion.math.Mat4;
import artofillusion.object.NullObject;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectInfo;
import artofillusion.object.ObjectWrapper;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalObject
extends ObjectWrapper {
    private File externalFile;
    private int objectId;
    private String objectName;
    private String loadingError;
    private boolean includeChildren;

    public ExternalObject(File file, String name) {
        this.externalFile = file;
        this.objectName = name;
        this.theObject = new NullObject();
        this.includeChildren = true;
    }

    private ExternalObject() {
        this.theObject = new NullObject();
    }

    public String getExternalObjectName() {
        return this.objectName;
    }

    public void setExternalObjectName(String name) {
        this.objectName = name;
    }

    public int getExternalObjectId() {
        return this.objectId;
    }

    public void setExternalObjectId(int id) {
        this.objectId = id;
    }

    public boolean getIncludeChildren() {
        return this.includeChildren;
    }

    public void setIncludeChildren(boolean include) {
        this.includeChildren = include;
    }

    public File getExternalSceneFile() {
        return this.externalFile;
    }

    public void setExternalSceneFile(File file) {
        this.externalFile = file;
    }

    public String getLoadingError() {
        return this.loadingError;
    }

    public void reloadObject() {
        this.theObject = new NullObject();
        this.loadingError = null;
        try {
            if (!this.externalFile.isFile()) {
                this.loadingError = Translate.text("externalObject.sceneNotFound", this.externalFile.getAbsolutePath());
                return;
            }
            Scene scene = new Scene(this.externalFile, true);
            ObjectInfo foundObject = null;
            for (int i = 0; i < scene.getNumObjects(); ++i) {
                ObjectInfo info = scene.getObject(i);
                if (!info.getName().equals(this.objectName)) continue;
                if (info.getId() == this.objectId) {
                    foundObject = info;
                    break;
                }
                if (foundObject != null) continue;
                foundObject = info;
            }
            if (foundObject == null) {
                this.loadingError = Translate.text("externalObject.objectNotFound", this.externalFile.getAbsolutePath(), this.objectName);
            } else if (this.includeChildren && foundObject.getChildren().length > 0) {
                ArrayList<ObjectInfo> allObjects = new ArrayList<ObjectInfo>();
                this.addObjectsToList(foundObject, allObjects, foundObject.getCoords().toLocal());
                this.theObject = new ExternalObjectCollection(allObjects);
            } else {
                this.theObject = foundObject.getObject();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.loadingError = ex.getMessage();
        }
    }

    private void addObjectsToList(ObjectInfo obj, ArrayList<ObjectInfo> allObjects, Mat4 transform) {
        obj.getCoords().transformCoordinates(transform);
        allObjects.add(obj);
        for (ObjectInfo child : obj.getChildren()) {
            this.addObjectsToList(child, allObjects, transform);
        }
    }

    @Override
    public Object3D duplicate() {
        ExternalObject obj = new ExternalObject();
        obj.externalFile = this.externalFile;
        obj.objectName = this.objectName;
        obj.theObject = this.theObject;
        obj.includeChildren = this.includeChildren;
        return obj;
    }

    @Override
    public void copyObject(Object3D obj) {
        ExternalObject eo = (ExternalObject)obj;
        this.externalFile = eo.externalFile;
        this.objectName = eo.objectName;
        this.theObject = eo.theObject;
        this.includeChildren = eo.includeChildren;
    }

    @Override
    public void setSize(double xsize, double ysize, double zsize) {
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        new ExternalObjectEditingWindow(parent, this, info, cb);
    }

    @Override
    public boolean canSetTexture() {
        return false;
    }

    @Override
    public boolean canSetMaterial() {
        return false;
    }

    @Override
    public boolean canConvertToActor() {
        return false;
    }

    @Override
    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(1);
        out.writeUTF(this.externalFile.getAbsolutePath());
        out.writeUTF(this.findRelativePath(theScene));
        out.writeUTF(this.objectName);
        out.writeInt(this.objectId);
        out.writeBoolean(this.includeChildren);
    }

    private String findRelativePath(Scene theScene) {
        int i;
        int numCommon;
        String scenePath = null;
        String externalPath = null;
        try {
            scenePath = new File(theScene.getDirectory()).getCanonicalPath();
            externalPath = this.externalFile.getCanonicalPath();
        }
        catch (IOException ex) {
            return "";
        }
        String splitExpr = File.separator;
        if ("\\".equals(splitExpr)) {
            splitExpr = "\\\\";
        }
        String[] scenePathParts = scenePath.split(splitExpr);
        String[] externalPathParts = externalPath.split(splitExpr);
        for (numCommon = 0; numCommon < scenePathParts.length && numCommon < externalPathParts.length && scenePathParts[numCommon].equals(externalPathParts[numCommon]); ++numCommon) {
        }
        StringBuffer relPath = new StringBuffer();
        for (i = numCommon; i < scenePathParts.length; ++i) {
            relPath.append("..").append(File.separator);
        }
        for (i = numCommon; i < externalPathParts.length; ++i) {
            if (i > numCommon) {
                relPath.append(File.separator);
            }
            relPath.append(externalPathParts[i]);
        }
        return relPath.toString();
    }

    public ExternalObject(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        File f;
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("Unknown version: " + version);
        }
        this.externalFile = new File(in.readUTF());
        String relPath = in.readUTF();
        if (!this.externalFile.isFile() && (f = new File(theScene.getDirectory(), relPath)).isFile()) {
            this.externalFile = f;
        }
        this.objectName = in.readUTF();
        this.objectId = version > 0 ? in.readInt() : -1;
        this.includeChildren = version > 0 ? in.readBoolean() : false;
        this.reloadObject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExternalObjectCollection
    extends ObjectCollection {
        private ArrayList<ObjectInfo> objects;

        ExternalObjectCollection(ArrayList<ObjectInfo> objects) {
            this.objects = objects;
        }

        @Override
        protected Enumeration enumerateObjects(ObjectInfo info, boolean interactive, Scene scene) {
            return Collections.enumeration(this.objects);
        }

        @Override
        public Object3D duplicate() {
            return new ExternalObjectCollection(this.objects);
        }

        @Override
        public void copyObject(Object3D obj) {
            this.objects = ((ExternalObjectCollection)obj).objects;
        }

        @Override
        public void setSize(double xsize, double ysize, double zsize) {
        }

        @Override
        public Keyframe getPoseKeyframe() {
            return null;
        }

        @Override
        public void applyPoseKeyframe(Keyframe k) {
        }
    }
}

