/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.math;

import artofillusion.math.FastMath;
import artofillusion.math.FastRandom;
import artofillusion.math.Vec3;
import java.util.Random;

public class Cells {
    private double[] dx;
    private double[] dy;
    private double[] dz;
    private Vec3 feature;
    private Vec3 diff;
    private Random random = new FastRandom(0L);
    private int metric = 0;
    private static double[] prob;
    public static final int EUCLIDEAN = 0;
    public static final int CITY_BLOCK = 1;
    public static final int CHESS_BOARD = 2;
    private static final double DENSITY = 3.0;
    private static final int[][] cellIndex;

    public Cells() {
        this.dx = new double[3];
        this.dy = new double[3];
        this.dz = new double[3];
        this.feature = new Vec3();
        this.diff = new Vec3();
    }

    public int getMetric() {
        return this.metric;
    }

    public void setMetric(int metric) {
        this.metric = metric;
    }

    public void calcFunctions(Vec3 p, double[] value, Vec3[] grad, int[] id) {
        double dist2;
        int num;
        int i;
        int a = Cells.floor(p.x);
        int b = Cells.floor(p.y);
        int c = Cells.floor(p.z);
        double x = p.x - (double)a;
        double y = p.y - (double)b;
        double z = p.z - (double)c;
        for (i = 0; i < value.length; ++i) {
            value[i] = Double.MAX_VALUE;
        }
        int seed = Cells.randSeed(a, b, c);
        this.random.setSeed(seed);
        this.random.nextInt();
        double rand = this.random.nextDouble();
        for (num = 1; num < 9 && rand > prob[num]; ++num) {
        }
        for (i = 0; i < num; ++i) {
            this.feature.x = this.random.nextDouble();
            this.feature.y = this.random.nextDouble();
            this.feature.z = this.random.nextDouble();
            this.diff.x = x - this.feature.x;
            this.diff.y = y - this.feature.y;
            this.diff.z = z - this.feature.z;
            dist2 = this.distance(this.diff);
            this.sortIntoList(dist2, seed + i, value, grad, id);
        }
        this.dx[0] = x * x;
        this.dy[0] = y * y;
        this.dz[0] = z * z;
        this.dx[2] = (1.0 - x) * (1.0 - x);
        this.dy[2] = (1.0 - y) * (1.0 - y);
        this.dz[2] = (1.0 - z) * (1.0 - z);
        double r = value[value.length - 1];
        for (int cell = 0; cell < cellIndex.length; ++cell) {
            i = cellIndex[cell][0];
            int j = cellIndex[cell][1];
            int k = cellIndex[cell][2];
            if (r < this.dx[i] + this.dy[j] + this.dz[k]) continue;
            seed = Cells.randSeed(a + --i, b + --j, c + --k);
            this.random.setSeed(seed);
            this.random.nextInt();
            rand = this.random.nextDouble();
            for (num = 1; num < 9 && rand > prob[num]; ++num) {
            }
            for (int m = 0; m < num; ++m) {
                this.feature.x = this.random.nextDouble() + (double)i;
                this.feature.y = this.random.nextDouble() + (double)j;
                this.feature.z = this.random.nextDouble() + (double)k;
                this.diff.x = x - this.feature.x;
                this.diff.y = y - this.feature.y;
                this.diff.z = z - this.feature.z;
                dist2 = this.distance(this.diff);
                if (!(dist2 < value[value.length - 1])) continue;
                this.sortIntoList(dist2, seed + m, value, grad, id);
            }
            r = value[value.length - 1];
        }
        if (this.metric == 0) {
            for (i = 0; i < value.length; ++i) {
                value[i] = Math.sqrt(value[i]);
                if (grad == null) continue;
                grad[i].scale(1.0 / value[i]);
            }
        }
    }

    private static final int randSeed(int i, int j, int k) {
        return i * 10 + j * 1000 + k * 100000;
    }

    private final void sortIntoList(double dist2, int newid, double[] value, Vec3[] grad, int[] id) {
        for (int i = 0; i < value.length; ++i) {
            if (!(dist2 < value[i])) continue;
            for (int j = value.length - 1; j > i; --j) {
                value[j] = value[j - 1];
                id[j] = id[j - 1];
                if (grad == null) continue;
                grad[j].set(grad[j - 1]);
            }
            value[i] = dist2;
            id[i] = newid;
            if (grad != null) {
                if (this.metric == 0) {
                    grad[i].set(this.diff);
                } else if (this.metric == 1) {
                    grad[i].set(this.diff.x > 0.0 ? 1.0 : -1.0, this.diff.y > 0.0 ? 1.0 : -1.0, this.diff.z > 0.0 ? 1.0 : -1.0);
                } else {
                    double ax = Math.abs(this.diff.x);
                    double ay = Math.abs(this.diff.y);
                    double az = Math.abs(this.diff.z);
                    if (ax > ay) {
                        if (ax > az) {
                            grad[i].set(this.diff.x > 0.0 ? 1.0 : -1.0, 0.0, 0.0);
                        } else {
                            grad[i].set(0.0, 0.0, this.diff.z > 0.0 ? 1.0 : -1.0);
                        }
                    } else if (ay > az) {
                        grad[i].set(0.0, this.diff.y > 0.0 ? 1.0 : -1.0, 0.0);
                    } else {
                        grad[i].set(0.0, 0.0, this.diff.z > 0.0 ? 1.0 : -1.0);
                    }
                }
            }
            return;
        }
    }

    private final double distance(Vec3 diff) {
        if (this.metric == 0) {
            return diff.length2();
        }
        double ax = Math.abs(diff.x);
        double ay = Math.abs(diff.y);
        double az = Math.abs(diff.z);
        if (this.metric == 1) {
            return ax + ay + az;
        }
        if (ax > ay) {
            return ax > az ? ax : az;
        }
        return ay > az ? ay : az;
    }

    private static int floor(double d) {
        if (d < 0.0) {
            int f = (int)d;
            if ((double)f != d) {
                --f;
            }
            return f;
        }
        return (int)d;
    }

    static {
        int i;
        cellIndex = new int[][]{{0, 1, 1}, {2, 1, 1}, {1, 0, 1}, {1, 2, 1}, {1, 1, 0}, {1, 1, 2}, {0, 0, 1}, {0, 2, 1}, {0, 1, 0}, {0, 1, 2}, {2, 0, 1}, {2, 2, 1}, {2, 1, 0}, {2, 1, 2}, {1, 0, 0}, {1, 0, 2}, {1, 2, 0}, {1, 2, 2}, {0, 0, 0}, {0, 0, 2}, {0, 2, 0}, {0, 2, 2}, {2, 0, 0}, {2, 0, 2}, {2, 2, 0}, {2, 2, 2}};
        prob = new double[10];
        for (i = 0; i < 10; ++i) {
            Cells.prob[i] = FastMath.pow(3.0, i) * Math.exp(-3.0);
            for (int j = 2; j <= i; ++j) {
                int n = i;
                prob[n] = prob[n] / (double)j;
            }
        }
        for (i = 1; i < 10; ++i) {
            int n = i;
            prob[n] = prob[n] + prob[i - 1];
        }
    }
}

