/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image.filter;

import artofillusion.Property;
import artofillusion.Scene;
import artofillusion.image.ComplexImage;
import artofillusion.image.filter.ImageFilter;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.object.SceneCamera;
import artofillusion.ui.Translate;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TintFilter
extends ImageFilter {
    public String getName() {
        return Translate.text("Tint");
    }

    public void filterImage(ComplexImage image, Scene scene, SceneCamera camera, CoordinateSystem cameraPos) {
        RGBColor color = (RGBColor)this.getPropertyValue(0);
        this.filterComponent(image, 4, color.getRed());
        this.filterComponent(image, 2, color.getGreen());
        this.filterComponent(image, 1, color.getBlue());
    }

    private void filterComponent(ComplexImage image, int component, float scale) {
        int width = image.getWidth();
        int height = image.getHeight();
        float[] filtered = new float[width * height];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                filtered[i + j * width] = image.getPixelComponent(i, j, component) * scale;
            }
        }
        image.setComponentValues(component, filtered);
    }

    public Property[] getProperties() {
        return new Property[]{new Property(this.getName(), new RGBColor(1.0, 1.0, 1.0))};
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        RGBColor color = (RGBColor)this.getPropertyValue(0);
        out.writeDouble(color.getRed());
        out.writeDouble(color.getGreen());
        out.writeDouble(color.getBlue());
    }

    public void initFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.setPropertyValue(0, new RGBColor(in.readDouble(), in.readDouble(), in.readDouble()));
    }
}

