/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image.filter;

import artofillusion.Property;
import artofillusion.Scene;
import artofillusion.image.ComplexImage;
import artofillusion.image.filter.ImageFilter;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.SceneCamera;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public class DepthOfFieldFilter
extends ImageFilter {
    public String getName() {
        return Translate.text("depthOfField");
    }

    public int getDesiredComponents() {
        return 23;
    }

    public void filterImage(ComplexImage image, Scene scene, SceneCamera camera, CoordinateSystem cameraPos) {
        int i;
        if (!image.hasFloatData(16) || camera.getDepthOfField() == 0.0) {
            return;
        }
        int[] radius = this.findBlurRadius(image, camera);
        Thread currentThread = Thread.currentThread();
        int width = image.getWidth();
        int height = image.getHeight();
        float[] red = new float[width * height];
        float[] green = new float[width * height];
        float[] blue = new float[width * height];
        float[] weight = new float[width * height];
        for (i = 0; i < width; ++i) {
            if (currentThread.isInterrupted()) {
                return;
            }
            for (int j = 0; j < height; ++j) {
                int pixelRadius = radius[i + j * width];
                int radius2 = pixelRadius * pixelRadius;
                int mstart = Math.max(0, i - pixelRadius);
                int mend = Math.min(width - 1, i + pixelRadius);
                int nstart = Math.max(0, j - pixelRadius);
                int nend = Math.min(height - 1, j + pixelRadius);
                float scale = pixelRadius == 0 ? 1.0f : 1.0f / (float)radius2;
                for (int m = mstart; m < mend; ++m) {
                    for (int n = nstart; n < nend; ++n) {
                        int index;
                        int dist2 = (m - i) * (m - i) + (n - j) * (n - j);
                        if (dist2 > radius2) continue;
                        float w = ((float)pixelRadius - (float)Math.sqrt(dist2)) * scale;
                        int n2 = index = m + n * width;
                        weight[n2] = weight[n2] + w;
                        int n3 = index;
                        red[n3] = red[n3] + w * image.getPixelComponent(i, j, 4);
                        int n4 = index;
                        green[n4] = green[n4] + w * image.getPixelComponent(i, j, 2);
                        int n5 = index;
                        blue[n5] = blue[n5] + w * image.getPixelComponent(i, j, 1);
                    }
                }
            }
        }
        i = 0;
        while (i < red.length) {
            float invWeight = 1.0f / weight[i];
            int n = i;
            red[n] = red[n] * invWeight;
            int n6 = i;
            green[n6] = green[n6] * invWeight;
            int n7 = i++;
            blue[n7] = blue[n7] * invWeight;
        }
        image.setComponentValues(4, red);
        image.setComponentValues(1, blue);
        image.setComponentValues(2, green);
    }

    private int[] findBlurRadius(ComplexImage image, SceneCamera camera) {
        int width = image.getWidth();
        int height = image.getHeight();
        boolean useCameraParams = (Boolean)this.getPropertyValue(0);
        double dof = useCameraParams ? camera.getDepthOfField() : ((Double)this.getPropertyValue(1)).doubleValue();
        double focalDist = useCameraParams ? camera.getFocalDistance() : ((Double)this.getPropertyValue(2)).doubleValue();
        double dofScale = 0.25 * (double)height * focalDist / (dof * camera.getFieldOfView());
        int[] radius = new int[width * height];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                float depth = image.getPixelComponent(i, j, 16);
                radius[i + j * width] = depth == Float.MAX_VALUE ? 1 : Math.max(1, (int)Math.round(Math.abs((double)depth - focalDist) * dofScale / (double)depth));
            }
        }
        return radius;
    }

    public Property[] getProperties() {
        return new Property[]{new Property(Translate.text("useParamsFromCamera"), true), new Property(Translate.text("depthOfField"), Double.MIN_VALUE, Double.MAX_VALUE, 10.0), new Property(Translate.text("focalDist"), Double.MIN_VALUE, Double.MAX_VALUE, 20.0)};
    }

    public Widget getConfigPanel(Runnable changeCallback) {
        Widget panel = super.getConfigPanel(changeCallback);
        final List<Widget> children = UIUtilities.findAllChildren(panel);
        BCheckBox cb = null;
        for (Widget w : children) {
            if (!(w instanceof BCheckBox)) continue;
            cb = (BCheckBox)w;
        }
        final BCheckBox checkbox = cb;
        Runnable listener = new Runnable(){

            public void run() {
                boolean enable = !checkbox.getState();
                for (Widget w : children) {
                    if (w == checkbox) continue;
                    w.setEnabled(enable);
                }
            }
        };
        checkbox.addEventLink(ValueChangedEvent.class, (Object)listener, "run");
        listener.run();
        return panel;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(0);
        out.writeBoolean((Boolean)this.getPropertyValue(0));
        out.writeDouble((Double)this.getPropertyValue(1));
        out.writeDouble((Double)this.getPropertyValue(2));
    }

    public void initFromStream(DataInputStream in, Scene theScene) throws IOException {
        short version = in.readShort();
        if (version != 0) {
            throw new IOException("Unknown version " + version);
        }
        this.setPropertyValue(0, in.readBoolean());
        this.setPropertyValue(1, in.readDouble());
        this.setPropertyValue(2, in.readDouble());
    }
}

