/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.Scene;
import artofillusion.image.ImageMap;
import artofillusion.image.ImagesDialog;
import artofillusion.math.Vec2;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueSlider;
import buoy.event.MouseClickedEvent;
import buoy.event.RepaintEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BComboBox;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.CustomWidget;
import buoy.widget.FormContainer;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ImageOrValue {
    private ImageMap map;
    private float value;
    private int component;

    public ImageOrValue(float val) {
        this.value = val;
    }

    public ImageOrValue(float scale, ImageMap theMap, int whichComponent) {
        this.value = scale;
        this.map = theMap;
        this.component = whichComponent;
    }

    public ImageMap getImage() {
        return this.map;
    }

    public int getComponent() {
        return this.component;
    }

    public float getValue() {
        return this.value;
    }

    public float getValue(boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        if (this.map == null) {
            return this.value;
        }
        return this.map.getComponent(this.component, wrapx, wrapy, x, y, xsize, ysize) * this.value;
    }

    public void getGradient(Vec2 grad, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        if (this.map == null) {
            grad.set(0.0, 0.0);
        } else {
            this.map.getGradient(grad, this.component, wrapx, wrapy, x, y, xsize, ysize);
            grad.scale(this.value);
        }
    }

    public float getAverageValue() {
        if (this.map == null) {
            return this.value;
        }
        return this.map.getAverageComponent(this.component) * this.value;
    }

    public ImageOrValue duplicate() {
        ImageOrValue copy = new ImageOrValue(this.value);
        copy.map = this.map;
        copy.component = this.component;
        return copy;
    }

    public void copy(ImageOrValue obj) {
        this.value = obj.value;
        this.map = obj.map;
        this.component = obj.component;
    }

    public ImageOrValue(DataInputStream in, Scene theScene) throws IOException {
        int index = in.readInt();
        if (index > -1) {
            this.map = theScene.getImage(index);
        }
        this.value = in.readFloat();
        this.component = in.readInt();
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        if (this.map == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(theScene.indexOf(this.map));
        }
        out.writeFloat(this.value);
        out.writeInt(this.component);
    }

    public Widget getEditingPanel(BFrame parent, Scene theScene) {
        return new EditingPanel(parent, theScene);
    }

    private class EditingPanel
    extends FormContainer {
        BFrame fr;
        Scene sc;
        CustomWidget preview;
        BComboBox componentChoice;
        BLabel componentLabel;
        BLabel valueLabel;
        ValueSlider slider;

        public EditingPanel(BFrame parent, Scene theScene) {
            super(new double[]{0.0, 1.0, 0.0}, new double[]{1.0, 1.0});
            this.fr = parent;
            this.sc = theScene;
            this.preview = new CustomWidget();
            this.preview.setPreferredSize(new Dimension(50, 50));
            this.preview.addEventLink(RepaintEvent.class, (Object)this, "paint");
            this.preview.addEventLink(MouseClickedEvent.class, (Object)this, "previewClicked");
            this.componentChoice = new BComboBox(new String[]{Translate.text("Red"), Translate.text("Green"), Translate.text("Blue")});
            this.componentChoice.addEventLink(ValueChangedEvent.class, (Object)this, "valueChanged");
            this.componentLabel = new BLabel(Translate.text("Component") + ":");
            this.valueLabel = new BLabel();
            this.slider = new ValueSlider(0.0, 1.0, 100, ImageOrValue.this.value);
            this.slider.addEventLink(ValueChangedEvent.class, (Object)this, "valueChanged");
            this.add(this.preview, 0, 0, 1, 2);
            this.add(this.valueLabel, 1, 0);
            this.add(this.componentLabel, 2, 0);
            this.add(this.slider, 1, 1);
            this.add(this.componentChoice, 2, 1);
            this.updateComponents();
        }

        private void updateComponents() {
            this.dispatchEvent(new ValueChangedEvent(this));
            if (ImageOrValue.this.map == null) {
                this.valueLabel.setText(Translate.text("Value") + ":");
            } else {
                this.valueLabel.setText(Translate.text("Scale") + ":");
            }
            if (ImageOrValue.this.map != null && ImageOrValue.this.map.getComponentCount() > this.componentChoice.getItemCount()) {
                this.componentChoice.add(Translate.text("Mask"));
            } else if (this.componentChoice.getItemCount() == 4) {
                this.componentChoice.remove(3);
            }
            if (ImageOrValue.this.map == null || ImageOrValue.this.map.getComponentCount() == 1) {
                this.componentChoice.setEnabled(false);
                ImageOrValue.this.component = 0;
                return;
            }
            this.componentChoice.setEnabled(true);
            if (ImageOrValue.this.component >= this.componentChoice.getItemCount()) {
                ImageOrValue.this.component = 0;
            }
            this.componentChoice.setSelectedIndex(ImageOrValue.this.component);
        }

        private void paint(RepaintEvent ev) {
            Graphics2D g = ev.getGraphics();
            if (ImageOrValue.this.map != null) {
                g.drawImage(ImageOrValue.this.map.getPreview(), 0, 0, null);
            } else {
                g.drawRect(1, 1, 48, 48);
            }
        }

        private void previewClicked() {
            ImagesDialog dlg = new ImagesDialog(this.fr, this.sc, ImageOrValue.this.map);
            ImageOrValue.this.map = dlg.getSelection();
            this.updateComponents();
            this.preview.repaint();
        }

        private void valueChanged() {
            ImageOrValue.this.value = (float)this.slider.getValue();
            ImageOrValue.this.component = this.componentChoice.getSelectedIndex();
            this.dispatchEvent(new ValueChangedEvent(this));
        }
    }
}

