/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.Track;
import artofillusion.animation.distortion.ShatterDistortion;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.widget.BComboBox;
import buoy.widget.BTextField;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ShatterTrack
extends Track {
    ObjectInfo info;
    double startTime;
    double size;
    double speed;
    double randomness;
    double gravity;
    double spin;
    double disappear;
    int gravityAxis;
    boolean worldCoords;

    public ShatterTrack(ObjectInfo info) {
        super("Shatter");
        this.info = info;
        this.gravityAxis = 1;
        this.startTime = 0.0;
        this.size = 0.2;
        this.speed = 1.0;
        this.randomness = 0.2;
        this.gravity = 1.0;
        this.spin = 5.0;
        this.disappear = 0.0;
        this.worldCoords = true;
    }

    public void apply(double time) {
        if (time <= this.startTime) {
            return;
        }
        if (this.worldCoords) {
            this.info.addDistortion(new ShatterDistortion(time - this.startTime, this.size, this.speed, this.randomness, this.gravity, this.spin, this.disappear, this.gravityAxis, this.info.getCoords().toLocal()));
        } else {
            this.info.addDistortion(new ShatterDistortion(time - this.startTime, this.size, this.speed, this.randomness, this.gravity, this.spin, this.disappear, this.gravityAxis, null));
        }
    }

    public Track duplicate(Object obj) {
        ShatterTrack t = new ShatterTrack((ObjectInfo)obj);
        t.name = this.name;
        t.enabled = this.enabled;
        t.quantized = this.quantized;
        t.startTime = this.startTime;
        t.size = this.size;
        t.speed = this.speed;
        t.randomness = this.randomness;
        t.gravity = this.gravity;
        t.spin = this.spin;
        t.disappear = this.disappear;
        t.gravityAxis = this.gravityAxis;
        t.worldCoords = this.worldCoords;
        return t;
    }

    public void copy(Track tr) {
        ShatterTrack t = (ShatterTrack)tr;
        this.name = t.name;
        this.enabled = t.enabled;
        this.quantized = t.quantized;
        this.startTime = t.startTime;
        this.size = t.size;
        this.speed = t.speed;
        this.randomness = t.randomness;
        this.gravity = t.gravity;
        this.spin = t.spin;
        this.disappear = t.disappear;
        this.gravityAxis = t.gravityAxis;
        this.worldCoords = t.worldCoords;
    }

    public double[] getKeyTimes() {
        return new double[0];
    }

    public int moveKeyframe(int which, double time) {
        return -1;
    }

    public void deleteKeyframe(int which) {
    }

    public boolean isNullTrack() {
        return false;
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeDouble(this.startTime);
        out.writeDouble(this.size);
        out.writeDouble(this.speed);
        out.writeDouble(this.randomness);
        out.writeDouble(this.gravity);
        out.writeDouble(this.spin);
        out.writeDouble(this.disappear);
        out.writeInt(this.gravityAxis);
    }

    public void initFromStream(DataInputStream in, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.startTime = in.readDouble();
        this.size = in.readDouble();
        this.speed = in.readDouble();
        this.randomness = in.readDouble();
        this.gravity = in.readDouble();
        this.spin = in.readDouble();
        this.disappear = in.readDouble();
        this.gravityAxis = in.readInt();
    }

    public void edit(LayoutWindow win) {
        BTextField nameField = new BTextField(this.getName());
        BComboBox axisChoice = new BComboBox(new String[]{"X", "Y", "Z"});
        axisChoice.setSelectedIndex(this.gravityAxis);
        BComboBox coordsChoice = new BComboBox(new String[]{Translate.text("Local"), Translate.text("World")});
        coordsChoice.setSelectedIndex(this.worldCoords ? 1 : 0);
        ValueField timeField = new ValueField(this.startTime, 0, 5);
        ValueField sizeField = new ValueField(this.size, 0, 5);
        ValueField speedField = new ValueField(this.speed, 0, 5);
        ValueSlider randomSlider = new ValueSlider(0.0, 1.0, 100, this.randomness);
        ValueField gravityField = new ValueField(this.gravity, 0, 5);
        ValueField spinField = new ValueField(this.spin, 1, 5);
        ValueField disappearField = new ValueField(this.disappear, 1, 5);
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("shatterTrackTitle"), new Widget[]{nameField, timeField, sizeField, speedField, spinField, disappearField, gravityField, axisChoice, randomSlider, coordsChoice}, new String[]{Translate.text("trackName"), Translate.text("StartTime"), Translate.text("maxFragmentSize"), Translate.text("explodeSpeed"), Translate.text("fragmentSpinRate"), Translate.text("disappearanceTime"), Translate.text("gravity"), Translate.text("gravityAxis"), Translate.text("randomness"), Translate.text("CoordinateSystem")});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 2, new Object[]{this.info, this.info.duplicate()}));
        this.setName(nameField.getText());
        this.startTime = timeField.getValue();
        this.size = sizeField.getValue();
        this.speed = speedField.getValue();
        this.randomness = randomSlider.getValue();
        this.spin = spinField.getValue();
        this.disappear = disappearField.getValue();
        this.gravity = gravityField.getValue();
        this.gravityAxis = axisChoice.getSelectedIndex();
        this.worldCoords = coordsChoice.getSelectedIndex() == 1;
    }
}

