/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.UndoRecord;
import artofillusion.animation.ArrayKeyframe;
import artofillusion.animation.Joint;
import artofillusion.animation.Keyframe;
import artofillusion.animation.ObjectRef;
import artofillusion.animation.ObjectRefSelector;
import artofillusion.animation.Skeleton;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.WeightTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.procedural.Module;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.ParameterModule;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.Procedure;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.procedural.ProcedureOwner;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ProceduralPositionTrack
extends Track
implements ProcedureOwner {
    ObjectInfo info;
    Procedure proc;
    Timecourse tc;
    TextureParameter[] parameter;
    int smoothingMethod;
    int mode;
    int relCoords;
    int joint;
    ObjectRef relObject;
    WeightTrack theWeight;
    public static final int ABSOLUTE = 0;
    public static final int RELATIVE = 1;
    public static final int WORLD = 0;
    public static final int PARENT = 1;
    public static final int OBJECT = 2;
    public static final int LOCAL = 3;

    public ProceduralPositionTrack(ObjectInfo info) {
        super("Position (procedural)");
        this.info = info;
        this.proc = new Procedure(new OutputModule[]{new OutputModule("X", "0", 0.0, null, 0), new OutputModule("Y", "0", 0.0, null, 0), new OutputModule("Z", "0", 0.0, null, 0)});
        this.parameter = new TextureParameter[0];
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
        this.mode = 0;
        this.relCoords = 0;
        this.relObject = new ObjectRef();
        this.theWeight = new WeightTrack(this);
        this.joint = -1;
    }

    public void apply(double time) {
        Joint j;
        PointInfo point = new PointInfo();
        Vec3 v = this.info.getCoords().getOrigin();
        Vec3 jointDelta = null;
        OutputModule[] output = this.proc.getOutputModules();
        point.x = v.x;
        point.y = v.y;
        point.z = v.z;
        if (this.joint > -1 && this.mode == 0 && (j = this.info.getSkeleton().getJoint(this.joint)) != null) {
            if (this.info.getPose() != null && !this.info.getPose().equals(this.info.getObject().getPoseKeyframe())) {
                this.info.getObject().applyPoseKeyframe(this.info.getPose());
                j = this.info.getSkeleton().getJoint(this.joint);
            }
            jointDelta = new ObjectRef(this.info, j).getCoords().getOrigin().minus(this.info.getCoords().getOrigin());
            point.x += jointDelta.x;
            point.y += jointDelta.y;
            point.z += jointDelta.z;
        }
        point.t = time;
        ArrayKeyframe params = (ArrayKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        if (params != null) {
            point.param = params.val;
        }
        this.proc.initForPoint(point);
        Vec3 pos = new Vec3(output[0].getAverageValue(0, 0.0), output[1].getAverageValue(0, 0.0), output[2].getAverageValue(0, 0.0));
        double weight = this.theWeight.getWeight(time);
        if (this.mode == 0) {
            double w = 1.0 - weight;
            v.x *= w;
            v.y *= w;
            v.z *= w;
        }
        if (this.mode == 0 && this.relCoords == 1) {
            if (this.info.getParent() != null) {
                pos = this.info.getParent().getCoords().fromLocal().times(pos);
            }
        } else if (this.mode == 0 && this.relCoords == 2) {
            CoordinateSystem coords = this.relObject.getCoords();
            if (coords != null) {
                pos = coords.fromLocal().times(pos);
            }
        } else if (this.mode == 1 && this.relCoords == 1) {
            if (this.info.getParent() != null) {
                pos = this.info.getParent().getCoords().fromLocal().timesDirection(pos);
            }
        } else if (this.mode == 1 && this.relCoords == 2) {
            CoordinateSystem coords = this.relObject.getCoords();
            if (coords != null) {
                pos = coords.fromLocal().timesDirection(pos);
            }
        } else if (this.mode == 1 && this.relCoords == 3) {
            pos = this.info.getCoords().fromLocal().timesDirection(pos);
        }
        if (jointDelta != null) {
            pos.subtract(jointDelta);
        }
        v.x += pos.x * weight;
        v.y += pos.y * weight;
        v.z += pos.z * weight;
        this.info.getCoords().setOrigin(v);
    }

    public Track duplicate(Object obj) {
        ProceduralPositionTrack t = new ProceduralPositionTrack((ObjectInfo)obj);
        t.name = this.name;
        t.enabled = this.enabled;
        t.quantized = this.quantized;
        t.proc.copy(this.proc);
        t.mode = this.mode;
        t.relCoords = this.relCoords;
        t.smoothingMethod = this.smoothingMethod;
        t.tc = this.tc.duplicate((ObjectInfo)obj);
        t.relObject = this.relObject.duplicate();
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        t.joint = this.joint;
        return t;
    }

    public void copy(Track tr) {
        ProceduralPositionTrack t = (ProceduralPositionTrack)tr;
        this.name = t.name;
        this.enabled = t.enabled;
        this.quantized = t.quantized;
        this.proc.copy(t.proc);
        this.mode = t.mode;
        this.relCoords = t.relCoords;
        this.smoothingMethod = t.smoothingMethod;
        this.tc = t.tc.duplicate(this.info);
        this.relObject = t.relObject.duplicate();
        this.theWeight = (WeightTrack)t.theWeight.duplicate(this);
        this.joint = t.joint;
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    public Keyframe setKeyframe(double time, Scene sc) {
        double[] p;
        if (this.parameter.length == 0) {
            return null;
        }
        ArrayKeyframe params = (ArrayKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        if (params == null) {
            p = this.getDefaultGraphValues();
        } else {
            p = new double[params.val.length];
            System.arraycopy(params.val, 0, p, 0, p.length);
        }
        ArrayKeyframe k = new ArrayKeyframe(p);
        this.tc.addTimepoint(k, time, new Smoothness());
        return k;
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return false;
    }

    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public boolean isRelative() {
        return this.mode == 1;
    }

    public void setRelative(boolean rel) {
        this.mode = rel ? 1 : 0;
    }

    public int getCoordinateSystem() {
        return this.relCoords;
    }

    public void setCoordinateSystem(int system) {
        this.relCoords = system;
    }

    public ObjectRef getCoordsObject() {
        return this.relObject;
    }

    public void setCoordsObject(ObjectRef obj) {
        this.relObject = obj;
        this.relCoords = 2;
    }

    public int getApplyToJoint() {
        return this.joint;
    }

    public void setApplyToJoint(int jointID) {
        this.joint = jointID;
    }

    public String[] getValueNames() {
        String[] names = new String[this.parameter.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.parameter[i].name;
        }
        return names;
    }

    public double[] getDefaultGraphValues() {
        double[] val = new double[this.parameter.length];
        for (int i = 0; i < val.length; ++i) {
            val[i] = this.parameter[i].defaultVal;
        }
        return val;
    }

    public double[][] getValueRange() {
        double[][] range = new double[this.parameter.length][2];
        for (int i = 0; i < range.length; ++i) {
            range[i][0] = this.parameter[i].minVal;
            range[i][1] = this.parameter[i].maxVal;
        }
        return range;
    }

    public ObjectInfo[] getDependencies() {
        if (this.relCoords == 2) {
            ObjectInfo relInfo = this.relObject.getObject();
            if (relInfo != null) {
                return new ObjectInfo[]{relInfo};
            }
        } else if (this.relCoords == 1 && this.info.getParent() != null) {
            return new ObjectInfo[]{this.info.getParent()};
        }
        return new ObjectInfo[0];
    }

    public void deleteDependencies(ObjectInfo obj) {
        if (this.relObject.getObject() == obj) {
            this.relObject = new ObjectRef();
        }
    }

    private TextureParameter[] findParameters() {
        Module[] module = this.proc.getModules();
        int count = 0;
        for (int i = 0; i < module.length; ++i) {
            if (!(module[i] instanceof ParameterModule)) continue;
            ++count;
        }
        TextureParameter[] params = new TextureParameter[count];
        count = 0;
        for (int i = 0; i < module.length; ++i) {
            if (!(module[i] instanceof ParameterModule)) continue;
            params[count] = ((ParameterModule)module[i]).getParameter(this);
            ((ParameterModule)module[i]).setIndex(count++);
        }
        return params;
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(1);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        this.proc.writeToStream(out, scene);
        out.writeInt(this.smoothingMethod);
        out.writeInt(this.mode);
        out.writeInt(this.relCoords);
        out.writeInt(this.joint);
        out.writeInt(t.length);
        for (int i = 0; i < t.length; ++i) {
            out.writeDouble(t[i]);
            ((ArrayKeyframe)v[i]).writeToStream(out);
            s[i].writeToStream(out);
        }
        if (this.relCoords == 2) {
            this.relObject.writeToStream(out);
        }
        this.theWeight.writeToStream(out, scene);
    }

    public void initFromStream(DataInputStream in, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.proc.readFromStream(in, scene);
        this.smoothingMethod = in.readInt();
        this.mode = in.readInt();
        this.relCoords = in.readInt();
        this.joint = version == 0 ? -1 : in.readInt();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        for (int i = 0; i < keys; ++i) {
            t[i] = in.readDouble();
            v[i] = new ArrayKeyframe(in, this);
            s[i] = new Smoothness(in);
        }
        this.tc = new Timecourse(v, t, s);
        this.relObject = this.relCoords == 2 ? new ObjectRef(in, scene) : new ObjectRef();
        this.theWeight.initFromStream(in, scene);
        this.parameter = this.findParameters();
    }

    public void editKeyframe(LayoutWindow win, int which) {
        ArrayKeyframe key = (ArrayKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final BCheckBox sameBox = new BCheckBox(Translate.text("separateSmoothness"), !s.isForceSame());
        Widget[] widget = new Widget[this.parameter.length + 5];
        String[] label = new String[this.parameter.length + 5];
        for (int i = 0; i < this.parameter.length; ++i) {
            widget[i] = this.parameter[i].getEditingWidget(key.val[i]);
            label[i] = this.parameter[i].name;
        }
        sameBox.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        s2Slider.setEnabled(sameBox.getState());
        int n = this.parameter.length;
        widget[n] = timeField;
        widget[n + 1] = sameBox;
        widget[n + 2] = new BLabel(Translate.text("Smoothness") + ':');
        widget[n + 3] = s1Slider;
        widget[n + 4] = s2Slider;
        label[n] = Translate.text("Time");
        label[n + 3] = "(" + Translate.text("left") + ")";
        label[n + 4] = "(" + Translate.text("right") + ")";
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("editKeyframe"), widget, label);
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        for (int i = 0; i < this.parameter.length; ++i) {
            key.val[i] = widget[i] instanceof ValueField ? ((ValueField)widget[i]).getValue() : ((ValueSlider)widget[i]).getValue();
        }
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    public void edit(LayoutWindow win) {
        ProcedureEditor editor = new ProcedureEditor(this.proc, this, win.getScene());
        editor.setEditingWindow(win);
    }

    public String getWindowTitle() {
        return Translate.text("procPosTrackTitle");
    }

    public Object getPreview(ProcedureEditor editor) {
        return null;
    }

    public void updatePreview(Object preview) {
    }

    public void disposePreview(Object preview) {
    }

    public boolean allowViewAngle() {
        return false;
    }

    public boolean allowParameters() {
        return true;
    }

    public boolean canEditName() {
        return true;
    }

    public void acceptEdits(ProcedureEditor editor) {
        EditingWindow win = editor.getEditingWindow();
        win.setUndoRecord(new UndoRecord(win, false, 2, new Object[]{this.info, this.info.duplicate()}));
        TextureParameter[] newparams = this.findParameters();
        int[] index = new int[newparams.length];
        for (int i = 0; i < newparams.length; ++i) {
            index[i] = -1;
            for (int j = 0; j < this.parameter.length; ++j) {
                if (!this.parameter[j].equals(newparams[i])) continue;
                index[i] = j;
            }
        }
        this.parameter = newparams;
        Keyframe[] key = this.tc.getValues();
        for (int i = 0; i < key.length; ++i) {
            double[] newval = new double[this.parameter.length];
            for (int j = 0; j < newval.length; ++j) {
                newval[j] = index[j] > -1 ? ((ArrayKeyframe)key[i]).val[index[j]] : this.parameter[j].defaultVal;
            }
            ((ArrayKeyframe)key[i]).val = newval;
        }
        ((LayoutWindow)win).getScore().finishEditingTrack(this);
    }

    public void editProperties(ProcedureEditor editor) {
        Skeleton s = this.info.getSkeleton();
        Joint[] j = s == null ? null : s.getJoints();
        BComboBox smoothChoice = new BComboBox(new String[]{Translate.text("Discontinuous"), Translate.text("Linear"), Translate.text("Interpolating"), Translate.text("Approximating")});
        smoothChoice.setSelectedIndex(this.smoothingMethod);
        final BComboBox modeChoice = new BComboBox(new String[]{Translate.text("Absolute"), Translate.text("Relative")});
        modeChoice.setSelectedIndex(this.mode);
        BComboBox jointChoice = new BComboBox();
        jointChoice.add(Translate.text("objectOrigin"));
        if (j != null) {
            int i;
            for (i = 0; i < j.length; ++i) {
                jointChoice.add(j[i].name);
            }
            for (i = 0; i < j.length; ++i) {
                if (j[i].id != this.joint) continue;
                jointChoice.setSelectedIndex(i + 1);
            }
        }
        final BComboBox coordsChoice = new BComboBox(new String[]{Translate.text("World"), Translate.text("Parent"), Translate.text("OtherObject")});
        if (this.mode == 1) {
            coordsChoice.add(Translate.text("Local"));
        }
        coordsChoice.setSelectedIndex(this.relCoords);
        final ObjectRefSelector objSelector = new ObjectRefSelector(this.relObject, (LayoutWindow)editor.getEditingWindow(), Translate.text("positionRelativeTo"), this.info);
        objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
        modeChoice.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                int sel = modeChoice.getSelectedIndex();
                if (sel == 0 && coordsChoice.getItemCount() == 4) {
                    coordsChoice.remove(3);
                }
                if (sel == 1 && coordsChoice.getItemCount() == 3) {
                    coordsChoice.add(Translate.text("Local"));
                }
                objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
            }
        });
        coordsChoice.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(editor.getParentFrame(), Translate.text("positionTrackTitle"), new Widget[]{smoothChoice, modeChoice, jointChoice, coordsChoice, objSelector}, new String[]{Translate.text("paramSmoothingMethod"), Translate.text("trackMode"), Translate.text("applyTo"), Translate.text("CoordinateSystem"), ""});
        if (!dlg.clickedOk()) {
            return;
        }
        editor.saveState(false);
        this.smoothingMethod = smoothChoice.getSelectedIndex();
        this.mode = modeChoice.getSelectedIndex();
        this.relCoords = coordsChoice.getSelectedIndex();
        this.relObject = objSelector.getSelection();
        this.joint = jointChoice.getSelectedIndex() == 0 ? -1 : j[jointChoice.getSelectedIndex() - 1].id;
    }
}

