/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.Actor;
import artofillusion.animation.Joint;
import artofillusion.animation.ObjectRef;
import artofillusion.animation.ObjectRefSelector;
import artofillusion.animation.Skeleton;
import artofillusion.animation.Track;
import artofillusion.animation.WeightTrack;
import artofillusion.animation.distortion.IKDistortion;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.MouseClickedEvent;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BDialog;
import buoy.widget.BList;
import buoy.widget.BRadioButton;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextField;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RadioButtonGroup;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Vector;

public class IKTrack
extends Track {
    private ObjectInfo info;
    private Vector constraints;
    private boolean useGestures;
    private WeightTrack theWeight;

    public IKTrack(ObjectInfo info) {
        super("Inverse Kinematics");
        this.info = info;
        this.theWeight = new WeightTrack(this);
        this.constraints = new Vector();
        this.useGestures = true;
    }

    public boolean getUseGestures() {
        return this.useGestures;
    }

    public void setUseGestures(boolean use) {
        this.useGestures = use;
    }

    public void edit(LayoutWindow win) {
        if (this.info.getSkeleton() == null) {
            new BStandardDialog("", Translate.text("ikNotApplyWarning"), BStandardDialog.INFORMATION).showMessageDialog(win);
        } else {
            new Editor(win);
        }
    }

    public void apply(double time) {
        double weight = this.theWeight.getWeight(time);
        Skeleton skeleton = this.info.getSkeleton();
        if (skeleton == null) {
            return;
        }
        Joint[] joint = skeleton.getJoints();
        if (joint.length == 0) {
            return;
        }
        boolean[] locked = new boolean[joint.length];
        Vec3[] target = new Vec3[joint.length];
        Mat4 toLocal = this.info.getCoords().toLocal();
        for (int i = 0; i < this.constraints.size(); ++i) {
            Constraint c = (Constraint)this.constraints.elementAt(i);
            int index = skeleton.findJointIndex(c.jointID);
            if (index == -1) continue;
            if (c.target == null) {
                locked[index] = true;
                continue;
            }
            CoordinateSystem coords = c.target.getCoords();
            if (coords == null) {
                locked[index] = true;
                continue;
            }
            target[index] = toLocal.times(coords.getOrigin());
        }
        Actor actor = Actor.getActor(this.info.getObject());
        this.info.addDistortion(new IKDistortion(locked, target, weight, actor));
    }

    public Track duplicate(Object obj) {
        IKTrack t = new IKTrack((ObjectInfo)obj);
        t.name = this.name;
        t.enabled = this.enabled;
        t.quantized = this.quantized;
        t.constraints = new Vector();
        for (int i = 0; i < this.constraints.size(); ++i) {
            Constraint c = (Constraint)this.constraints.elementAt(i);
            t.constraints.addElement(c.duplicate());
        }
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        return t;
    }

    public void copy(Track tr) {
        IKTrack t = (IKTrack)tr;
        this.name = t.name;
        this.enabled = t.enabled;
        this.quantized = t.quantized;
        this.constraints = new Vector();
        for (int i = 0; i < t.constraints.size(); ++i) {
            Constraint c = (Constraint)t.constraints.elementAt(i);
            this.constraints.addElement(c.duplicate());
        }
        this.theWeight = (WeightTrack)t.theWeight.duplicate(t);
    }

    public double[] getKeyTimes() {
        return new double[0];
    }

    public int moveKeyframe(int which, double time) {
        return -1;
    }

    public void deleteKeyframe(int which) {
    }

    public boolean isNullTrack() {
        for (int i = 0; i < this.constraints.size(); ++i) {
            if (((Constraint)this.constraints.elementAt((int)i)).target == null) continue;
            return false;
        }
        return true;
    }

    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo && ((ObjectInfo)obj).getObject() instanceof Mesh;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public ObjectInfo[] getDependencies() {
        Vector<ObjectInfo> v = new Vector<ObjectInfo>();
        for (int i = 0; i < this.constraints.size(); ++i) {
            Constraint c = (Constraint)this.constraints.elementAt(i);
            if (c.target == null) continue;
            v.addElement(c.target.getObject());
        }
        Object[] ref = new ObjectInfo[v.size()];
        v.copyInto(ref);
        return ref;
    }

    public void deleteDependencies(ObjectInfo obj) {
        for (int i = this.constraints.size() - 1; i >= 0; --i) {
            Constraint c = (Constraint)this.constraints.elementAt(i);
            if (c.target == null || c.target.getObject() != obj) continue;
            this.constraints.removeElementAt(i);
        }
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        out.writeShort(1);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeBoolean(this.useGestures);
        out.writeInt(this.constraints.size());
        for (int i = 0; i < this.constraints.size(); ++i) {
            Constraint c = (Constraint)this.constraints.elementAt(i);
            out.writeInt(c.jointID);
            out.writeBoolean(c.target != null);
            if (c.target == null) continue;
            c.target.writeToStream(out);
        }
        this.theWeight.writeToStream(out, scene);
    }

    public void initFromStream(DataInputStream in, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        if (version > 0) {
            this.useGestures = in.readBoolean();
        }
        int numConstraints = in.readInt();
        this.constraints = new Vector();
        for (int i = 0; i < numConstraints; ++i) {
            Constraint c = new Constraint(in.readInt(), in.readBoolean() ? new ObjectRef(in, scene) : null);
            this.constraints.addElement(c);
        }
        this.theWeight.initFromStream(in, scene);
    }

    private class Editor
    extends BDialog {
        LayoutWindow window;
        BList constraintList;
        BTextField nameField;
        BCheckBox gesturesBox;
        Vector tempConstraints;
        int[] tempJointID;
        ObjectRef[] tempTarget;
        BButton editButton;
        BButton deleteButton;

        public Editor(LayoutWindow win) {
            super(win, Translate.text("ikTrackTitle"), true);
            this.window = win;
            this.tempConstraints = new Vector();
            for (int i = 0; i < IKTrack.this.constraints.size(); ++i) {
                this.tempConstraints.addElement(((Constraint)IKTrack.this.constraints.elementAt(i)).duplicate());
            }
            FormContainer content = new FormContainer(new double[]{0.0, 1.0}, new double[]{0.0, 1.0, 0.0, 0.0});
            this.setContent(content);
            content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
            content.add(Translate.label("trackName"), 0, 0);
            content.add(Translate.label("constraints"), 0, 1);
            this.nameField = new BTextField(IKTrack.this.getName(), 30);
            content.add(this.nameField, 1, 0);
            this.constraintList = new BList();
            content.add(UIUtilities.createScrollingList(this.constraintList), 1, 1);
            this.constraintList.setPreferredVisibleRows(5);
            this.constraintList.addEventLink(SelectionChangedEvent.class, (Object)this, "selectionChanged");
            this.constraintList.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
            this.buildConstraintList();
            this.gesturesBox = new BCheckBox(Translate.text("useGesturesToShapeMesh"), IKTrack.this.useGestures);
            content.add(this.gesturesBox, 0, 2, 2, 1);
            this.gesturesBox.setEnabled(Actor.getActor(IKTrack.this.info.getObject()) != null);
            RowContainer buttons = new RowContainer();
            content.add(buttons, 0, 3, 2, 1, new LayoutInfo());
            buttons.add(Translate.button("add", "...", this, "doAdd"));
            this.editButton = Translate.button("edit", "...", this, "doEdit");
            buttons.add(this.editButton);
            this.deleteButton = Translate.button("delete", this, "doDelete");
            buttons.add(this.deleteButton);
            buttons.add(Translate.button("ok", this, "doOk"));
            buttons.add(Translate.button("cancel", this, "dispose"));
            this.pack();
            UIUtilities.centerDialog(this, win);
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.setVisible(true);
        }

        private void buildConstraintList() {
            Skeleton skeleton = IKTrack.this.info.getSkeleton();
            this.constraintList.removeAll();
            if (this.tempConstraints.size() == 0) {
                this.constraintList.add("(No Constraints)");
                this.constraintList.setEnabled(false);
                return;
            }
            this.constraintList.setEnabled(true);
            for (int i = 0; i < this.tempConstraints.size(); ++i) {
                Constraint c = (Constraint)this.tempConstraints.elementAt(i);
                Joint j = skeleton.getJoint(c.jointID);
                if (c.target == null) {
                    this.constraintList.add(Translate.text("jointIsLocked", j.name));
                    continue;
                }
                this.constraintList.add(Translate.text("jointFollowsTarget", j.name, c.target.toString()));
            }
        }

        private void doAdd() {
            Constraint c = new Constraint(-1, null);
            if (this.editConstraint(c)) {
                this.tempConstraints.addElement(c);
                this.buildConstraintList();
            }
        }

        private void doEdit() {
            Constraint c;
            if (this.constraintList.getSelectedIndex() > -1 && this.editConstraint(c = (Constraint)this.tempConstraints.elementAt(this.constraintList.getSelectedIndex()))) {
                this.buildConstraintList();
            }
        }

        private void doDelete() {
            if (this.constraintList.getSelectedIndex() > -1) {
                this.tempConstraints.removeElementAt(this.constraintList.getSelectedIndex());
            }
            this.buildConstraintList();
        }

        private void doOk() {
            this.window.setUndoRecord(new UndoRecord(this.window, false, 2, new Object[]{IKTrack.this.info, IKTrack.this.info.duplicate()}));
            IKTrack.this.setName(this.nameField.getText());
            IKTrack.this.setUseGestures(this.gesturesBox.getState());
            IKTrack.this.constraints = this.tempConstraints;
            this.window.getScore().repaintAll();
            this.dispose();
        }

        private void mouseClicked(MouseClickedEvent ev) {
            if (ev.getClickCount() == 2) {
                this.doEdit();
            }
        }

        private void selectionChanged() {
            this.editButton.setEnabled(this.constraintList.getSelectedIndex() > -1);
            this.deleteButton.setEnabled(this.constraintList.getSelectedIndex() > -1);
        }

        private boolean editConstraint(Constraint c) {
            Skeleton skeleton = IKTrack.this.info.getSkeleton();
            Joint[] joint = skeleton.getJoints();
            BList jointList = new BList();
            for (int i = 0; i < joint.length; ++i) {
                jointList.add(joint[i].name);
            }
            if (skeleton.findJointIndex(c.jointID) > -1) {
                jointList.setSelected(skeleton.findJointIndex(c.jointID), true);
            }
            jointList.setPreferredVisibleRows(8);
            RadioButtonGroup group = new RadioButtonGroup();
            BRadioButton lockedBox = new BRadioButton(Translate.text("locked"), c.target == null, group);
            final BRadioButton targetBox = new BRadioButton(Translate.text("followsTarget"), c.target != null, group);
            RowContainer targetRow = new RowContainer();
            targetRow.add(lockedBox);
            targetRow.add(targetBox);
            ObjectRef tempRef = c.target == null ? new ObjectRef() : c.target;
            final ObjectRefSelector selector = new ObjectRefSelector(tempRef, this.window, Translate.text("targetForJoint"), IKTrack.this.info);
            Object listener = new Object(){

                private void processEvent(ValueChangedEvent ev) {
                    selector.setEnabled(ev.getWidget() == targetBox);
                }
            };
            lockedBox.addEventLink(ValueChangedEvent.class, listener);
            targetBox.addEventLink(ValueChangedEvent.class, listener);
            selector.setEnabled(c.target != null);
            ComponentsDialog dlg = new ComponentsDialog(this.window, Translate.text("editConstraint"), new Widget[]{UIUtilities.createScrollingList(jointList), targetRow, selector}, new String[]{Translate.text("applyConstraintTo"), Translate.text("constraintType"), Translate.text("targetForJoint")});
            if (!dlg.clickedOk() || jointList.getSelectedIndex() == -1) {
                return false;
            }
            if (jointList.getSelectedIndex() > -1) {
                c.jointID = joint[jointList.getSelectedIndex()].id;
            }
            c.target = lockedBox.getState() ? null : selector.getSelection();
            return true;
        }
    }

    private class Constraint {
        public int jointID;
        public ObjectRef target;

        public Constraint(int id, ObjectRef t) {
            this.jointID = id;
            this.target = t;
        }

        public Constraint duplicate() {
            if (this.target == null) {
                return new Constraint(this.jointID, null);
            }
            return new Constraint(this.jointID, this.target.duplicate());
        }
    }
}

