/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.ObjectRef;
import artofillusion.animation.ObjectRefSelector;
import artofillusion.animation.Track;
import artofillusion.animation.WeightTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.ValueChangedEvent;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BTextField;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.OverlayContainer;
import buoy.widget.RowContainer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ConstraintTrack
extends Track {
    ObjectInfo info;
    int xType;
    int yType;
    int zType;
    int orientType;
    int orientMode;
    ObjectRef faceToward;
    Vec3 pos;
    Vec3 orient;
    WeightTrack theWeight;
    private static final int NONE = 0;
    private static final int LESS_THAN = 1;
    private static final int EQUAL_TO = 2;
    private static final int GREATER_THAN = 3;
    private static final int FORCE_X = 1;
    private static final int FORCE_Y = 2;
    private static final int FORCE_Z = 3;
    private static final int PARALLEL = 0;
    private static final int PERPENDICULAR = 1;
    private static final int FACES_OBJECT = 2;

    public ConstraintTrack(ObjectInfo info) {
        super("Constraint");
        this.info = info;
        this.theWeight = new WeightTrack(this);
        this.orientType = 0;
        this.zType = 0;
        this.yType = 0;
        this.xType = 0;
        this.orientMode = 0;
        this.faceToward = new ObjectRef();
        this.pos = new Vec3();
        this.orient = Vec3.vx();
    }

    public void edit(LayoutWindow win) {
        new Editor(win);
    }

    public void apply(double time) {
        double weight = this.theWeight.getWeight(time);
        Vec3 v = this.info.getCoords().getOrigin();
        v.x = this.findCoordinate(v.x, this.pos.x, this.xType, weight);
        v.y = this.findCoordinate(v.y, this.pos.y, this.yType, weight);
        v.z = this.findCoordinate(v.z, this.pos.z, this.zType, weight);
        if (this.orientType != 0) {
            Vec3 zdir = this.info.getCoords().getZDirection();
            Vec3 ydir = this.info.getCoords().getUpDirection();
            Vec3 xdir = ydir.cross(zdir);
            Vec3 oldy = new Vec3(ydir);
            Vec3 oldz = new Vec3(zdir);
            if (this.orientType == 1) {
                this.adjustAxes(xdir, ydir, zdir);
            } else if (this.orientType == 2) {
                this.adjustAxes(ydir, zdir, xdir);
            } else {
                this.adjustAxes(zdir, xdir, ydir);
            }
            if (weight < 1.0) {
                double w1 = 1.0 - weight;
                ydir.set(weight * ydir.x + w1 * oldy.x, weight * ydir.y + w1 * oldy.y, weight * ydir.z + w1 * oldy.z);
                zdir.set(weight * zdir.x + w1 * oldz.x, weight * zdir.y + w1 * oldz.y, weight * zdir.z + w1 * oldz.z);
            }
            this.info.getCoords().setOrientation(zdir, ydir);
        }
        this.info.getCoords().setOrigin(v);
    }

    private double findCoordinate(double current, double con, int type, double weight) {
        if (type == 0) {
            return current;
        }
        if (type == 3 && current > con) {
            con = current;
        } else if (type == 1 && current < con) {
            con = current;
        }
        return (1.0 - weight) * current + weight * con;
    }

    private void adjustAxes(Vec3 xdir, Vec3 ydir, Vec3 zdir) {
        Vec3 v;
        if (this.orientMode == 2) {
            CoordinateSystem target = this.faceToward.getCoords();
            if (target == null) {
                return;
            }
            v = target.getOrigin().minus(this.info.getCoords().getOrigin());
        } else {
            v = new Vec3(this.orient);
        }
        double len = v.length();
        if (len == 0.0) {
            return;
        }
        v.scale(1.0 / len);
        if (this.orientMode == 1) {
            double dot = xdir.dot(v);
            xdir.subtract(v.times(dot));
            xdir.normalize();
        } else {
            xdir.set(v);
        }
        ydir.set(zdir.cross(xdir));
        zdir.set(xdir.cross(ydir));
        zdir.normalize();
        ydir.normalize();
    }

    public Track duplicate(Object obj) {
        ConstraintTrack t = new ConstraintTrack((ObjectInfo)obj);
        t.name = this.name;
        t.enabled = this.enabled;
        t.quantized = this.quantized;
        t.xType = this.xType;
        t.yType = this.yType;
        t.zType = this.zType;
        t.orientType = this.orientType;
        t.orientMode = this.orientMode;
        t.pos = new Vec3(this.pos);
        t.orient = new Vec3(this.orient);
        t.faceToward = this.faceToward.duplicate();
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        return t;
    }

    public void copy(Track tr) {
        ConstraintTrack t = (ConstraintTrack)tr;
        this.name = t.name;
        this.enabled = t.enabled;
        this.quantized = t.quantized;
        this.xType = t.xType;
        this.yType = t.yType;
        this.zType = t.zType;
        this.orientType = t.orientType;
        this.orientMode = t.orientMode;
        this.pos = new Vec3(t.pos);
        this.orient = new Vec3(t.orient);
        this.faceToward.copy(t.faceToward);
        this.theWeight = (WeightTrack)t.theWeight.duplicate(t);
    }

    public double[] getKeyTimes() {
        return new double[0];
    }

    public int moveKeyframe(int which, double time) {
        return -1;
    }

    public void deleteKeyframe(int which) {
    }

    public boolean isNullTrack() {
        return false;
    }

    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public ObjectInfo[] getDependencies() {
        ObjectInfo info;
        if (this.orientType != 0 && this.orientMode == 2 && (info = this.faceToward.getObject()) != null) {
            return new ObjectInfo[]{info};
        }
        return new ObjectInfo[0];
    }

    public void deleteDependencies(ObjectInfo obj) {
        if (this.faceToward.getObject() == obj) {
            this.faceToward = new ObjectRef();
        }
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.xType);
        out.writeInt(this.yType);
        out.writeInt(this.zType);
        out.writeInt(this.orientType);
        out.writeInt(this.orientMode);
        this.pos.writeToFile(out);
        this.orient.writeToFile(out);
        if (this.orientType != 0 && this.orientMode == 2) {
            this.faceToward.writeToStream(out);
        }
        this.theWeight.writeToStream(out, scene);
    }

    public void initFromStream(DataInputStream in, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.xType = in.readInt();
        this.yType = in.readInt();
        this.zType = in.readInt();
        this.orientType = in.readInt();
        this.orientMode = in.readInt();
        this.pos = new Vec3(in);
        this.orient = new Vec3(in);
        this.faceToward = this.orientType != 0 && this.orientMode == 2 ? new ObjectRef(in, scene) : new ObjectRef();
        this.theWeight.initFromStream(in, scene);
    }

    private class Editor
    extends BDialog {
        LayoutWindow window;
        BComboBox xChoice;
        BComboBox yChoice;
        BComboBox zChoice;
        BComboBox orientChoice;
        BComboBox orientModeChoice;
        ValueField xField;
        ValueField yField;
        ValueField zField;
        ValueField orientXField;
        ValueField orientYField;
        ValueField orientZField;
        OverlayContainer orientPanel;
        ObjectRefSelector objSelector;
        BTextField nameField;

        public Editor(LayoutWindow win) {
            super(win, Translate.text("constraintTrackTitle"), true);
            this.window = win;
            FormContainer content = new FormContainer(3, 7);
            this.setContent(BOutline.createEmptyBorder(content, UIUtilities.getStandardDialogInsets()));
            content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, null, null));
            content.add(Translate.label("trackName"), 0, 0);
            this.nameField = new BTextField(ConstraintTrack.this.getName());
            content.add(this.nameField, 1, 0, 2, 1);
            String constraint = Translate.text("constraint");
            Object[] constraintOpt = new String[]{Translate.text("none"), Translate.text("lessThan"), Translate.text("equalTo"), Translate.text("greaterThan")};
            content.add(new BLabel("X " + constraint), 0, 1);
            content.add(new BLabel("Y " + constraint), 0, 2);
            content.add(new BLabel("Z " + constraint), 0, 3);
            this.xChoice = new BComboBox(constraintOpt);
            content.add(this.xChoice, 1, 1);
            this.yChoice = new BComboBox(constraintOpt);
            content.add(this.yChoice, 1, 2);
            this.zChoice = new BComboBox(constraintOpt);
            content.add(this.zChoice, 1, 3);
            this.xChoice.setSelectedIndex(ConstraintTrack.this.xType);
            this.yChoice.setSelectedIndex(ConstraintTrack.this.yType);
            this.zChoice.setSelectedIndex(ConstraintTrack.this.zType);
            this.xChoice.addEventLink(ValueChangedEvent.class, (Object)this, "updateComponents");
            this.yChoice.addEventLink(ValueChangedEvent.class, (Object)this, "updateComponents");
            this.zChoice.addEventLink(ValueChangedEvent.class, (Object)this, "updateComponents");
            this.xField = new ValueField(ConstraintTrack.this.pos.x, 0, 5);
            content.add(this.xField, 2, 1);
            this.yField = new ValueField(ConstraintTrack.this.pos.y, 0, 5);
            content.add(this.yField, 2, 2);
            this.zField = new ValueField(ConstraintTrack.this.pos.z, 0, 5);
            content.add(this.zField, 2, 3);
            content.add(Translate.label("Orientation"), 0, 4);
            this.orientChoice = new BComboBox(new String[]{Translate.text("none"), Translate.text("xAxis"), Translate.text("yAxis"), Translate.text("zAxis")});
            content.add(this.orientChoice, 1, 4);
            this.orientChoice.setSelectedIndex(ConstraintTrack.this.orientType);
            this.orientChoice.addEventLink(ValueChangedEvent.class, (Object)this, "updateComponents");
            this.orientModeChoice = new BComboBox(new String[]{Translate.text("parallelTo"), Translate.text("perpTo"), Translate.text("facesToward")});
            content.add(this.orientModeChoice, 2, 4);
            this.orientModeChoice.setSelectedIndex(ConstraintTrack.this.orientMode);
            this.orientModeChoice.addEventLink(ValueChangedEvent.class, (Object)this, "updateComponents");
            this.orientPanel = new OverlayContainer();
            RowContainer xyzRow = new RowContainer();
            this.orientPanel.add(xyzRow);
            xyzRow.add(new BLabel("X"));
            this.orientXField = new ValueField(ConstraintTrack.this.orient.x, 0, 5);
            xyzRow.add(this.orientXField);
            xyzRow.add(new BLabel("Y"));
            this.orientYField = new ValueField(ConstraintTrack.this.orient.y, 0, 5);
            xyzRow.add(this.orientYField);
            xyzRow.add(new BLabel("Z"));
            this.orientZField = new ValueField(ConstraintTrack.this.orient.z, 0, 5);
            xyzRow.add(this.orientZField);
            this.objSelector = new ObjectRefSelector(ConstraintTrack.this.faceToward, win, Translate.text("axisFacesToward"), ConstraintTrack.this.info);
            this.orientPanel.add(this.objSelector);
            content.add(this.orientPanel, 0, 5, 3, 1, new LayoutInfo());
            RowContainer buttons = new RowContainer();
            buttons.add(Translate.button("ok", this, "doOk"));
            buttons.add(Translate.button("cancel", this, "dispose"));
            content.add(buttons, 0, 6, 3, 1, new LayoutInfo());
            this.pack();
            UIUtilities.centerDialog(this, win);
            this.updateComponents();
            this.setVisible(true);
        }

        private void doOk() {
            this.window.setUndoRecord(new UndoRecord(this.window, false, 2, new Object[]{ConstraintTrack.this.info, ConstraintTrack.this.info.duplicate()}));
            ConstraintTrack.this.setName(this.nameField.getText());
            ConstraintTrack.this.xType = this.xChoice.getSelectedIndex();
            ConstraintTrack.this.yType = this.yChoice.getSelectedIndex();
            ConstraintTrack.this.zType = this.zChoice.getSelectedIndex();
            ConstraintTrack.this.orientType = this.orientChoice.getSelectedIndex();
            ConstraintTrack.this.orientMode = this.orientModeChoice.getSelectedIndex();
            ConstraintTrack.this.pos.set(this.xField.getValue(), this.yField.getValue(), this.zField.getValue());
            ConstraintTrack.this.orient.set(this.orientXField.getValue(), this.orientYField.getValue(), this.orientZField.getValue());
            ConstraintTrack.this.faceToward = this.objSelector.getSelection();
            this.window.getScore().repaintAll();
            this.dispose();
        }

        private void updateComponents() {
            this.xField.setEnabled(this.xChoice.getSelectedIndex() > 0);
            this.yField.setEnabled(this.yChoice.getSelectedIndex() > 0);
            this.zField.setEnabled(this.zChoice.getSelectedIndex() > 0);
            boolean orientEnabled = this.orientChoice.getSelectedIndex() > 0;
            this.orientXField.setEnabled(orientEnabled);
            this.orientYField.setEnabled(orientEnabled);
            this.orientZField.setEnabled(orientEnabled);
            this.objSelector.setEnabled(orientEnabled);
            this.orientModeChoice.setEnabled(orientEnabled);
            this.orientPanel.setVisibleChild(this.orientModeChoice.getSelectedIndex() == 2 ? 0 : 1);
        }
    }
}

