/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.ArtOfIllusion;
import artofillusion.Property;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.animation.ActorEditorWindow;
import artofillusion.animation.Gesture;
import artofillusion.animation.Joint;
import artofillusion.animation.Keyframe;
import artofillusion.animation.MeshGesture;
import artofillusion.animation.PoseTrack;
import artofillusion.animation.Skeleton;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.SVD;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.ObjectWrapper;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.ui.EditingWindow;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Actor
extends ObjectWrapper {
    Gesture[] gesture;
    String[] gestureName;
    int[] gestureID;
    int nextPoseID;
    private ActorKeyframe currentPose;

    public Actor(Object3D obj) {
        this.theObject = obj;
        this.gesture = new Gesture[]{(Gesture)obj.getPoseKeyframe()};
        this.gestureName = new String[]{"Default Pose"};
        this.gestureID = new int[]{0};
        this.nextPoseID = 1;
        this.currentPose = new ActorKeyframe();
    }

    public void addGesture(Gesture p, String name) {
        int num = this.gesture.length;
        Gesture[] newpose = new Gesture[num + 1];
        String[] newname = new String[num + 1];
        int[] newID = new int[num + 1];
        System.arraycopy(this.gesture, 0, newpose, 0, num);
        System.arraycopy(this.gestureName, 0, newname, 0, num);
        System.arraycopy(this.gestureID, 0, newID, 0, num);
        newpose[num] = p;
        newname[num] = name;
        ++this.nextPoseID;
        this.gesture = newpose;
        this.gestureName = newname;
        this.gestureID = newID;
    }

    public void deleteGestureWithID(int id) {
        int which = this.getGestureIndex(id);
        if (which == -1) {
            return;
        }
        int num = this.gesture.length;
        Gesture[] newpose = new Gesture[num - 1];
        String[] newname = new String[num - 1];
        int[] newID = new int[num - 1];
        int j = 0;
        for (int i = 0; i < num; ++i) {
            if (i == which) continue;
            newpose[j] = this.gesture[i];
            newname[j] = this.gestureName[i];
            newID[j] = this.gestureID[i];
            ++j;
        }
        this.gesture = newpose;
        this.gestureName = newname;
        this.gestureID = newID;
    }

    public int getNumGestures() {
        return this.gesture.length;
    }

    public Gesture getGesture(int i) {
        return this.gesture[i];
    }

    public Gesture getGestureWithID(int id) {
        int index = this.getGestureIndex(id);
        return index == -1 ? null : this.gesture[index];
    }

    public String getGestureName(int i) {
        return this.gestureName[i];
    }

    public void setGestureName(int i, String name) {
        this.gestureName[i] = name;
    }

    public int getGestureID(int i) {
        return this.gestureID[i];
    }

    public int getGestureIndex(int id) {
        int which;
        for (which = 0; which < this.gestureID.length && this.gestureID[which] != id; ++which) {
        }
        if (which == this.gestureID.length) {
            return -1;
        }
        return which;
    }

    public Object3D duplicate() {
        Actor a = new Actor(this.theObject.duplicate());
        a.gesture = new Gesture[this.gesture.length];
        a.gestureName = new String[this.gesture.length];
        a.gestureID = new int[this.gesture.length];
        for (int i = 0; i < this.gesture.length; ++i) {
            a.gesture[i] = (Gesture)this.gesture[i].duplicate(a.theObject);
            a.gestureName[i] = this.gestureName[i];
            a.gestureID[i] = this.gestureID[i];
        }
        a.nextPoseID = this.nextPoseID;
        a.currentPose = (ActorKeyframe)this.currentPose.duplicate(a);
        return a;
    }

    public void copyObject(Object3D obj) {
        Actor a = (Actor)obj;
        this.theObject = a.theObject.duplicate();
        this.gesture = new Gesture[a.gesture.length];
        this.gestureName = new String[a.gesture.length];
        this.gestureID = new int[a.gesture.length];
        for (int i = 0; i < this.gesture.length; ++i) {
            this.gesture[i] = (Gesture)a.gesture[i].duplicate(this.theObject);
            this.gestureName[i] = a.gestureName[i];
            this.gestureID[i] = a.gestureID[i];
        }
        this.nextPoseID = a.nextPoseID;
        this.currentPose = (ActorKeyframe)a.currentPose.duplicate(this);
    }

    public void setSize(double xsize, double ysize, double zsize) {
    }

    public boolean isEditable() {
        return true;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        new ActorEditorWindow(parent, info, this, null, cb);
    }

    public boolean canSetTexture() {
        return this.theObject.canSetTexture();
    }

    public boolean canSetMaterial() {
        return this.theObject.canSetMaterial();
    }

    public void setTexture(Texture tex, TextureMapping map) {
        TextureParameter[] oldParam = this.getParameters();
        this.theObject.setTexture(tex, map);
        TextureParameter[] newParam = map.getParameters();
        for (int i = 0; i < this.gesture.length; ++i) {
            this.gesture[i].textureChanged(oldParam, newParam);
        }
    }

    public void setMaterial(Material mat, MaterialMapping map) {
        this.theObject.setMaterial(mat, map);
    }

    public void setParameterValues(ParameterValue[] val) {
        this.theObject.setParameterValues(val);
        TextureParameter[] params = this.getParameters();
        for (int i = 0; i < this.gesture.length; ++i) {
            for (int j = 0; j < params.length; ++j) {
                this.gesture[i].setTextureParameter(params[j], val[j].duplicate());
            }
        }
    }

    public void setParameterValue(TextureParameter param, ParameterValue value) {
        this.theObject.setParameterValue(param, value);
        for (int i = 0; i < this.gesture.length; ++i) {
            this.gesture[i].setTextureParameter(param, value.duplicate());
        }
    }

    public void shapeMeshFromGestures(Object3D obj) {
        Skeleton skeleton = obj.getSkeleton();
        Skeleton defaultSkeleton = this.gesture[0].getSkeleton();
        Joint[] currentJoint = skeleton.getJoints();
        Joint[] defaultJoint = defaultSkeleton.getJoints();
        int numDof = currentJoint.length * 4;
        double[][] coeff = new double[numDof][this.gesture.length - 1];
        double[] goal = new double[numDof];
        double d = Math.PI / 180;
        for (int i = 0; i < defaultJoint.length; ++i) {
            goal[i * 4] = d * (currentJoint[i].angle1.pos - defaultJoint[i].angle1.pos);
            goal[i * 4 + 1] = d * (currentJoint[i].angle2.pos - defaultJoint[i].angle2.pos);
            goal[i * 4 + 2] = d * (currentJoint[i].twist.pos - defaultJoint[i].twist.pos);
            goal[i * 4 + 3] = currentJoint[i].length.pos - defaultJoint[i].length.pos;
        }
        for (int j = 1; j < this.gesture.length; ++j) {
            Joint[] gestureJoint = this.gesture[j].getSkeleton().getJoints();
            for (int i = 0; i < defaultJoint.length; ++i) {
                coeff[i * 4][j - 1] = d * (gestureJoint[i].angle1.pos - defaultJoint[i].angle1.pos);
                coeff[i * 4 + 1][j - 1] = d * (gestureJoint[i].angle2.pos - defaultJoint[i].angle2.pos);
                coeff[i * 4 + 2][j - 1] = d * (gestureJoint[i].twist.pos - defaultJoint[i].twist.pos);
                coeff[i * 4 + 3][j - 1] = gestureJoint[i].length.pos - defaultJoint[i].length.pos;
            }
        }
        boolean converged = false;
        boolean[] negative = new boolean[this.gesture.length - 1];
        double[] weight = new double[this.gesture.length - 1];
        while (!converged) {
            int i;
            int numGesture = 0;
            for (int i2 = 0; i2 < negative.length; ++i2) {
                if (negative[i2]) continue;
                ++numGesture;
            }
            if (numGesture == 0) {
                MeshGesture average = (MeshGesture)obj.getPoseKeyframe();
                ((MeshGesture)this.gesture[0]).blendSurface(average, new MeshGesture[0], new double[0]);
                obj.applyPoseKeyframe(average);
                return;
            }
            double[] rhs = new double[Math.max(numDof, numGesture)];
            for (int i3 = 0; i3 < numDof; ++i3) {
                rhs[i3] = goal[i3];
            }
            double[][] matrix = new double[numDof][numGesture];
            int j = 0;
            for (i = 0; i < negative.length; ++i) {
                if (negative[i]) continue;
                for (int k = 0; k < numDof; ++k) {
                    matrix[k][j] = coeff[k][i];
                }
                ++j;
            }
            SVD.solve(matrix, rhs, 0.1);
            converged = true;
            j = 0;
            for (i = 0; i < negative.length; ++i) {
                weight[i] = 0.0;
                if (negative[i]) continue;
                if (rhs[j] < -0.001) {
                    negative[i] = true;
                    converged = false;
                } else if (rhs[j] > 0.001) {
                    weight[i] = rhs[j];
                }
                ++j;
            }
        }
        Vector<Gesture> gestureList = new Vector<Gesture>();
        Vector<Double> weightList = new Vector<Double>();
        for (int i = 0; i < weight.length; ++i) {
            if (!(weight[i] > 0.0)) continue;
            gestureList.addElement(this.gesture[i + 1]);
            weightList.addElement(new Double(weight[i]));
        }
        MeshGesture[] poseGesture = new MeshGesture[gestureList.size()];
        double[] poseWeight = new double[weightList.size()];
        for (int i = 0; i < poseGesture.length; ++i) {
            poseGesture[i] = (MeshGesture)gestureList.elementAt(i);
            poseWeight[i] = (Double)weightList.elementAt(i);
        }
        MeshGesture average = (MeshGesture)obj.getPoseKeyframe();
        ((MeshGesture)this.gesture[0]).blendSurface(average, poseGesture, poseWeight);
        obj.applyPoseKeyframe(average);
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(0);
        out.writeUTF(this.theObject.getClass().getName());
        this.theObject.writeToFile(out, theScene);
        out.writeInt(this.nextPoseID);
        out.writeUTF(this.gesture[0].getClass().getName());
        out.writeInt(this.gesture.length);
        for (int i = 0; i < this.gesture.length; ++i) {
            out.writeInt(this.gestureID[i]);
            out.writeUTF(this.gestureName[i]);
            this.gesture[i].writeToStream(out);
        }
        this.currentPose.writeToStream(out);
    }

    public Actor(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        try {
            Class cls = ArtOfIllusion.getClass(in.readUTF());
            Constructor con = cls.getConstructor(DataInputStream.class, Scene.class);
            this.theObject = (Object3D)con.newInstance(in, theScene);
            this.nextPoseID = in.readInt();
            cls = ArtOfIllusion.getClass(in.readUTF());
            con = cls.getConstructor(DataInputStream.class, Object.class);
            int num = in.readInt();
            this.gesture = new Gesture[num];
            this.gestureName = new String[num];
            this.gestureID = new int[num];
            for (int i = 0; i < num; ++i) {
                this.gestureID[i] = in.readInt();
                this.gestureName[i] = in.readUTF();
                this.gesture[i] = (Gesture)con.newInstance(in, this.theObject);
            }
            this.currentPose = new ActorKeyframe(in, this);
        }
        catch (InvocationTargetException ex) {
            ex.getTargetException().printStackTrace();
            throw new IOException();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException();
        }
    }

    public Property[] getProperties() {
        Property[] prop = new Property[this.currentPose.getNumGestures()];
        for (int i = 0; i < prop.length; ++i) {
            prop[i] = new Property(this.getGestureName(this.getGestureIndex(this.currentPose.getGestureID(i))), -1.7976931348623157E308, Double.MAX_VALUE, this.currentPose.getGestureWeight(i));
        }
        return prop;
    }

    public Object getPropertyValue(int index) {
        return new Double(this.currentPose.getGestureWeight(index));
    }

    public void setPropertyValue(int index, Object value) {
        this.currentPose.weight[index] = (Double)value;
        this.applyPoseKeyframe(this.currentPose);
    }

    public Keyframe getPoseKeyframe() {
        return this.currentPose.duplicate(this);
    }

    public void applyPoseKeyframe(Keyframe k) {
        this.currentPose = (ActorKeyframe)k.duplicate(this);
        this.theObject.applyPoseKeyframe(this.currentPose.createObjectKeyframe(this));
    }

    public void configurePoseTrack(PoseTrack track) {
        track.setGraphableValues(new String[0], new double[0], new double[0][2]);
    }

    int findPoseIndex(int id) {
        int min = 0;
        int max = this.gestureID.length - 1;
        int current = min + max >> 1;
        while (this.gestureID[current] != id) {
            if (this.gestureID[current] > id) {
                max = current - 1;
            } else {
                min = current + 1;
            }
            if (min >= max) {
                if (min < this.gestureID.length && this.gestureID[min] == id) {
                    return min;
                }
                return -1;
            }
            current = min + max >> 1;
        }
        return current;
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        new ActorEditorWindow(parent, info, this, (ActorKeyframe)k, null);
    }

    public static Actor getActor(Object3D obj) {
        while (obj instanceof ObjectWrapper) {
            if (obj instanceof Actor) {
                return (Actor)obj;
            }
            obj = ((ObjectWrapper)obj).getWrappedObject();
        }
        return null;
    }

    public static class ActorKeyframe
    implements Keyframe {
        int[] id;
        double[] weight;

        public ActorKeyframe() {
            this.id = new int[0];
            this.weight = new double[0];
        }

        public ActorKeyframe(int[] id, double[] weight) {
            this.id = id;
            this.weight = weight;
        }

        public int getNumGestures() {
            return this.id.length;
        }

        public int getGestureID(int index) {
            return this.id[index];
        }

        public double getGestureWeight(int index) {
            return this.weight[index];
        }

        public void addGesture(int addID, double addWeight) {
            int[] newid = new int[this.id.length + 1];
            double[] newweight = new double[this.weight.length + 1];
            System.arraycopy(this.id, 0, newid, 0, this.id.length);
            System.arraycopy(this.weight, 0, newweight, 0, this.weight.length);
            newid[this.id.length] = addID;
            newweight[this.weight.length] = addWeight;
            this.id = newid;
            this.weight = newweight;
        }

        public void deleteGesture(int which) {
            int[] newid = new int[this.id.length - 1];
            double[] newweight = new double[this.weight.length - 1];
            int j = 0;
            for (int i = 0; i < this.id.length; ++i) {
                if (i == which) continue;
                newid[j] = this.id[i];
                newweight[j++] = this.weight[i];
            }
            this.id = newid;
            this.weight = newweight;
        }

        public Keyframe duplicate(Object owner) {
            return this.duplicate();
        }

        public Keyframe duplicate() {
            ActorKeyframe k = new ActorKeyframe();
            k.id = new int[this.id.length];
            k.weight = new double[this.weight.length];
            System.arraycopy(this.id, 0, k.id, 0, this.id.length);
            System.arraycopy(this.weight, 0, k.weight, 0, this.weight.length);
            return k;
        }

        public void copy(ActorKeyframe key) {
            this.id = new int[key.id.length];
            this.weight = new double[key.weight.length];
            System.arraycopy(key.id, 0, this.id, 0, this.id.length);
            System.arraycopy(key.weight, 0, this.weight, 0, this.weight.length);
        }

        public double[] getGraphValues() {
            return new double[0];
        }

        public void setGraphValues(double[] values) {
        }

        private void addWeightsToTable(ActorKeyframe k, Hashtable table, double scale) {
            for (int i = 0; i < k.id.length; ++i) {
                Integer key = new Integer(k.id[i]);
                Double weight = (Double)table.get(key);
                weight = weight == null ? new Double(k.weight[i] * scale) : new Double(k.weight[i] * scale + weight);
                table.put(key, weight);
            }
        }

        private ActorKeyframe getKeyframeFromTable(Hashtable table) {
            ActorKeyframe k = new ActorKeyframe();
            k.id = new int[table.size()];
            k.weight = new double[k.id.length];
            Enumeration keys = table.keys();
            int j = 0;
            for (int i = 0; i < k.id.length; ++i) {
                Integer key = (Integer)keys.nextElement();
                Double weight = (Double)table.get(key);
                k.id[j] = key;
                k.weight[j] = weight;
                if (k.weight[j] == 0.0) continue;
                ++j;
            }
            if (j < k.id.length) {
                int[] id = new int[j];
                double[] weight = new double[j];
                System.arraycopy(k.id, 0, id, 0, j);
                System.arraycopy(k.weight, 0, weight, 0, j);
                k.id = id;
                k.weight = weight;
            }
            return k;
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            Hashtable table = new Hashtable();
            this.addWeightsToTable(this, table, weight1);
            this.addWeightsToTable((ActorKeyframe)o2, table, weight2);
            return this.getKeyframeFromTable(table);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            Hashtable table = new Hashtable();
            this.addWeightsToTable(this, table, weight1);
            this.addWeightsToTable((ActorKeyframe)o2, table, weight2);
            this.addWeightsToTable((ActorKeyframe)o3, table, weight3);
            return this.getKeyframeFromTable(table);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            Hashtable table = new Hashtable();
            this.addWeightsToTable(this, table, weight1);
            this.addWeightsToTable((ActorKeyframe)o2, table, weight2);
            this.addWeightsToTable((ActorKeyframe)o3, table, weight3);
            this.addWeightsToTable((ActorKeyframe)o4, table, weight4);
            return this.getKeyframeFromTable(table);
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof ActorKeyframe)) {
                return false;
            }
            ActorKeyframe key = (ActorKeyframe)k;
            if (this.id.length != key.id.length) {
                return false;
            }
            for (int i = 0; i < this.id.length; ++i) {
                if (this.id[i] == key.id[i] && this.weight[i] == key.weight[i]) continue;
                return false;
            }
            return true;
        }

        public Keyframe createObjectKeyframe(Actor actor) {
            Vector<Gesture> poseVec = new Vector<Gesture>();
            Vector<Double> weightVec = new Vector<Double>();
            for (int i = 0; i < this.id.length; ++i) {
                int which = actor.findPoseIndex(this.id[i]);
                if (which <= -1) continue;
                poseVec.addElement(actor.gesture[which]);
                weightVec.addElement(new Double(this.weight[i]));
            }
            Gesture[] blendPose = new Gesture[poseVec.size()];
            double[] blendWeight = new double[poseVec.size()];
            for (int i = 0; i < blendPose.length; ++i) {
                blendPose[i] = (Gesture)poseVec.elementAt(i);
                blendWeight[i] = (Double)weightVec.elementAt(i);
            }
            return actor.gesture[0].blend(blendPose, blendWeight);
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            out.writeInt(this.id.length);
            for (int i = 0; i < this.id.length; ++i) {
                out.writeInt(this.id[i]);
                out.writeDouble(this.weight[i]);
            }
        }

        public ActorKeyframe(DataInputStream in, Object parent) throws IOException {
            int num = in.readInt();
            this.id = new int[num];
            this.weight = new double[num];
            for (int i = 0; i < num; ++i) {
                this.id[i] = in.readInt();
                this.weight[i] = in.readDouble();
            }
        }
    }
}

