/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.UndoRecord;
import java.util.LinkedList;

public class UndoStack {
    private LinkedList undoList = new LinkedList();
    private LinkedList redoList = new LinkedList();

    public boolean canUndo() {
        return this.undoList.size() > 0;
    }

    public boolean canRedo() {
        return this.redoList.size() > 0;
    }

    public void addRecord(UndoRecord record) {
        int levels = ArtOfIllusion.getPreferences().getUndoLevels();
        if (levels < 1) {
            levels = 1;
        }
        while (this.undoList.size() >= levels) {
            this.undoList.removeFirst();
        }
        this.undoList.add(record);
        this.redoList.clear();
    }

    public void executeUndo() {
        if (this.undoList.size() == 0) {
            return;
        }
        UndoRecord record = (UndoRecord)this.undoList.removeLast();
        this.redoList.add(record.execute());
    }

    public void executeRedo() {
        if (this.redoList.size() == 0) {
            return;
        }
        UndoRecord record = (UndoRecord)this.redoList.removeLast();
        this.undoList.add(record.execute());
    }
}

