/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MeshViewer;
import artofillusion.RenderingMesh;
import artofillusion.TextureParameter;
import artofillusion.TriMeshEditorWindow;
import artofillusion.UndoRecord;
import artofillusion.animation.SkeletonTool;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.FaceParameterValue;
import artofillusion.ui.MeshEditController;
import artofillusion.view.ConstantVertexShader;
import artofillusion.view.FlatVertexShader;
import artofillusion.view.ParameterVertexShader;
import artofillusion.view.SelectionVertexShader;
import artofillusion.view.SmoothVertexShader;
import artofillusion.view.TexturedVertexShader;
import artofillusion.view.VertexShader;
import buoy.event.WidgetMouseEvent;
import buoy.widget.RowContainer;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public class TriMeshViewer
extends MeshViewer {
    private boolean draggingSelectionBox;
    private boolean dragging;
    private int deselect;
    private Point[] screenVert;
    private double[] screenZ;
    boolean[] visible;

    public TriMeshViewer(MeshEditController window, RowContainer p) {
        super(window, p);
        TriangleMesh mesh = (TriangleMesh)window.getObject().getObject();
        this.visible = new boolean[mesh.getVertices().length];
    }

    protected void drawObject() {
        Color selectedColor;
        Color meshColor;
        TriangleMesh mesh = (TriangleMesh)this.getController().getObject().getObject();
        MeshVertex[] v = mesh.getVertices();
        RenderingMesh previewMesh = this.getController().getObject().getPreviewMesh();
        boolean project = this.controller instanceof TriMeshEditorWindow ? ((TriMeshEditorWindow)this.controller).getProjectOntoSurface() : false;
        this.screenVert = new Point[v.length];
        this.screenZ = new double[v.length];
        if (this.visible.length != v.length) {
            this.visible = new boolean[v.length];
        }
        Vec2[] p = new Vec2[v.length];
        double clipDist = this.theCamera.getClipDistance();
        boolean[] hideVert = this.controller instanceof TriMeshEditorWindow ? ((TriMeshEditorWindow)this.controller).hideVert : new boolean[v.length];
        for (int i = 0; i < v.length; ++i) {
            Vec3 pos = project ? previewMesh.vert[i] : v[i].r;
            p[i] = this.theCamera.getObjectToScreen().timesXY(pos);
            this.screenVert[i] = new Point((int)p[i].x, (int)p[i].y);
            this.screenZ[i] = this.theCamera.getObjectToView().timesZ(pos);
            this.visible[i] = !hideVert[i] && this.screenZ[i] > clipDist;
        }
        this.drawSurface();
        if (this.currentTool instanceof SkeletonTool) {
            meshColor = disabledColor;
            selectedColor = new Color(255, 127, 255);
        } else {
            meshColor = lineColor;
            selectedColor = highlightColor;
            if (this.showSkeleton && mesh.getSkeleton() != null) {
                mesh.getSkeleton().draw(this, false);
            }
        }
        if (this.controller.getSelectionMode() == 0) {
            this.drawEdges(p, disabledColor, disabledColor);
            this.drawVertices(meshColor, this.currentTool.hilightSelection() ? selectedColor : meshColor);
        } else {
            this.drawEdges(p, meshColor, this.currentTool.hilightSelection() ? selectedColor : meshColor);
        }
        if (this.currentTool instanceof SkeletonTool && this.showSkeleton && mesh.getSkeleton() != null) {
            mesh.getSkeleton().draw(this, true);
        }
    }

    private void drawSurface() {
        int i;
        if (!this.showSurface) {
            return;
        }
        boolean[] hide = null;
        int[] faceIndex = null;
        ObjectInfo objInfo = this.controller.getObject();
        if (this.controller instanceof TriMeshEditorWindow && ((TriMeshEditorWindow)this.controller).getFaceIndexParameter() != null) {
            int i2;
            RenderingMesh mesh = objInfo.getPreviewMesh();
            TextureParameter faceIndexParameter = ((TriMeshEditorWindow)this.controller).getFaceIndexParameter();
            double[] param = null;
            for (i2 = 0; i2 < mesh.param.length; ++i2) {
                if (objInfo.getObject().getParameters()[i2] != faceIndexParameter) continue;
                param = ((FaceParameterValue)mesh.param[i2]).getValue();
            }
            faceIndex = new int[param.length];
            for (i2 = 0; i2 < faceIndex.length; ++i2) {
                faceIndex[i2] = (int)param[i2];
            }
            boolean[] hideFace = ((TriMeshEditorWindow)this.controller).hideFace;
            if (hideFace != null) {
                hide = new boolean[param.length];
                for (i = 0; i < hide.length; ++i) {
                    hide[i] = hideFace[faceIndex[i]];
                }
            }
        }
        Vec3 viewDir = this.getDisplayCoordinates().toLocal().timesDirection(this.theCamera.getViewToWorld().timesDirection(Vec3.vz()));
        if (this.renderMode == 0) {
            this.renderWireframe(objInfo.getWireframePreview(), this.theCamera, surfaceColor);
        } else if (this.renderMode == 4) {
            VertexShader shader = new ConstantVertexShader(transparentColor);
            if (faceIndex != null && this.controller.getSelectionMode() == 2) {
                shader = new SelectionVertexShader(new RGBColor(1.0, 0.4, 1.0), shader, faceIndex, this.controller.getSelection());
            }
            this.renderMeshTransparent(objInfo.getPreviewMesh(), shader, this.theCamera, viewDir, hide);
        } else {
            VertexShader shader;
            RenderingMesh mesh = objInfo.getPreviewMesh();
            if (this.renderMode == 1) {
                shader = new FlatVertexShader(mesh, surfaceRGBColor, viewDir);
            } else if (this.surfaceColoringParameter != null) {
                shader = null;
                TextureParameter[] params = objInfo.getObject().getParameters();
                for (i = 0; i < params.length; ++i) {
                    if (!params[i].equals(this.surfaceColoringParameter)) continue;
                    shader = new ParameterVertexShader(mesh, mesh.param[i], lowValueColor, highValueColor, this.surfaceColoringParameter.minVal, this.surfaceColoringParameter.maxVal, viewDir);
                    break;
                }
            } else {
                shader = this.renderMode == 2 ? new SmoothVertexShader(mesh, surfaceRGBColor, viewDir) : new TexturedVertexShader(mesh, objInfo.getObject(), 0.0, viewDir).optimize();
            }
            if (faceIndex != null && this.controller.getSelectionMode() == 2) {
                shader = new SelectionVertexShader(new RGBColor(1.0, 0.4, 1.0), shader, faceIndex, this.controller.getSelection());
            }
            this.renderMesh(mesh, shader, this.theCamera, objInfo.getObject().isClosed(), hide);
        }
    }

    private void drawVertices(Color unselectedColor, Color selectedColor) {
        int i;
        if (!this.showMesh) {
            return;
        }
        MeshVertex[] v = ((Mesh)((Object)this.getController().getObject().getObject())).getVertices();
        ArrayList<Rectangle> boxes = new ArrayList<Rectangle>();
        ArrayList<Double> depths = new ArrayList<Double>();
        boolean[] selected = this.controller.getSelection();
        for (i = 0; i < v.length; ++i) {
            if (selected[i] || !this.visible[i]) continue;
            boxes.add(new Rectangle(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5));
            depths.add(this.screenZ[i] - 0.02);
        }
        this.renderBoxes(boxes, depths, unselectedColor);
        boxes.clear();
        depths.clear();
        for (i = 0; i < v.length; ++i) {
            if (!selected[i] || !this.visible[i]) continue;
            boxes.add(new Rectangle(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5));
            depths.add(this.screenZ[i] - 0.02);
        }
        this.renderBoxes(boxes, depths, selectedColor);
    }

    private void drawEdges(Vec2[] p, Color unselectedColor, Color selectedColor) {
        int[] projectedEdge;
        boolean[] isSelected;
        if (!this.showMesh) {
            return;
        }
        TriangleMesh.Edge[] e = ((TriangleMesh)this.getController().getObject().getObject()).getEdges();
        int selectMode = this.controller.getSelectionMode();
        boolean[] hideEdge = this.controller instanceof TriMeshEditorWindow ? ((TriMeshEditorWindow)this.controller).hideEdge : new boolean[e.length];
        boolean[] selected = this.controller.getSelection();
        if (selectMode == 0) {
            isSelected = new boolean[e.length];
        } else if (selectMode == 1) {
            isSelected = selected;
        } else {
            isSelected = new boolean[e.length];
            for (int i = 0; i < e.length; ++i) {
                isSelected[i] = selected[e[i].f1] || e[i].f2 > -1 && selected[e[i].f2];
            }
        }
        int[] nArray = projectedEdge = this.controller instanceof TriMeshEditorWindow ? ((TriMeshEditorWindow)this.controller).findProjectedEdges() : null;
        if (projectedEdge == null) {
            for (int j = 0; j < 2; ++j) {
                boolean showSelected = j == 1;
                Color color = showSelected ? selectedColor : unselectedColor;
                for (int i = 0; i < e.length; ++i) {
                    if (showSelected != isSelected[i] || hideEdge[i] || !this.visible[e[i].v1] || !this.visible[e[i].v2]) continue;
                    this.renderLine(p[e[i].v1], this.screenZ[e[i].v1] - 0.01, p[e[i].v2], this.screenZ[e[i].v2] - 0.01, this.theCamera, color);
                }
            }
        } else {
            TriangleMesh divMesh = ((TriMeshEditorWindow)this.controller).getSubdividedMesh();
            MeshVertex[] divVert = divMesh.getVertices();
            TriangleMesh.Edge[] divEdge = divMesh.getEdges();
            double[] divScreenZ = new double[divVert.length];
            Vec2[] divPos = new Vec2[divVert.length];
            for (int i = 0; i < divVert.length; ++i) {
                divPos[i] = this.theCamera.getObjectToScreen().timesXY(divVert[i].r);
                divScreenZ[i] = this.theCamera.getObjectToView().timesZ(divVert[i].r);
            }
            for (int j = 0; j < 2; ++j) {
                boolean showSelected = j == 1;
                Color color = showSelected ? selectedColor : unselectedColor;
                for (int i = 0; i < projectedEdge.length; ++i) {
                    int index = projectedEdge[i];
                    if (index <= -1 || showSelected != isSelected[index] || hideEdge[index] || !this.visible[e[index].v1] || !this.visible[e[index].v2]) continue;
                    this.renderLine(divPos[divEdge[i].v1], divScreenZ[divEdge[i].v1] - 0.01, divPos[divEdge[i].v2], divScreenZ[divEdge[i].v2] - 0.01, this.theCamera, color);
                }
            }
        }
    }

    protected void mousePressed(WidgetMouseEvent e) {
        boolean[] hideEdge;
        boolean wantHandleClicks;
        TriangleMesh mesh = (TriangleMesh)this.getController().getObject().getObject();
        TriangleMesh.Edge[] ed = mesh.getEdges();
        TriangleMesh.Face[] f = mesh.getFaces();
        this.requestFocus();
        this.sentClick = false;
        this.deselect = -1;
        this.dragging = false;
        this.clickPoint = e.getPoint();
        this.activeTool = this.metaTool != null && e.isMetaDown() ? this.metaTool : (this.altTool != null && e.isAltDown() ? this.altTool : this.currentTool);
        if ((this.activeTool.whichClicks() & 1) != 0) {
            this.activeTool.mousePressed(e, this);
            this.dragging = true;
            this.sentClick = true;
        }
        boolean allowSelectionChange = this.activeTool.allowSelectionChanges();
        boolean bl = wantHandleClicks = (this.activeTool.whichClicks() & 4) != 0;
        if (!allowSelectionChange && !wantHandleClicks) {
            return;
        }
        int i = this.findClickTarget(e.getPoint(), null);
        if (i == -1) {
            if (allowSelectionChange) {
                this.draggingSelectionBox = true;
                this.beginDraggingSelection(e.getPoint(), false);
            }
            return;
        }
        int j = this.controller.getSelectionMode() == 1 ? (this.visible[ed[i].v1] ? ed[i].v1 : ed[i].v2) : (this.controller.getSelectionMode() == 2 ? (this.visible[f[i].v1] ? f[i].v1 : (this.visible[f[i].v2] ? f[i].v2 : f[i].v3)) : i);
        boolean[] selected = this.controller.getSelection();
        if (selected[i]) {
            if (e.isShiftDown() && allowSelectionChange) {
                this.deselect = i;
            }
            if (wantHandleClicks) {
                this.activeTool.mousePressedOnHandle(e, this, 0, j);
            }
            this.sentClick = true;
            return;
        }
        if (!allowSelectionChange) {
            return;
        }
        boolean[] oldSelection = (boolean[])selected.clone();
        if (!e.isShiftDown()) {
            for (int k = 0; k < selected.length; ++k) {
                selected[k] = false;
            }
        }
        selected[i] = true;
        boolean[] blArray = hideEdge = this.controller instanceof TriMeshEditorWindow ? ((TriMeshEditorWindow)this.controller).hideEdge : new boolean[ed.length];
        if (this.controller.getSelectionMode() == 2) {
            if (hideEdge[f[i].e1]) {
                selected[ed[f[i].e1].f2] = true;
                selected[ed[f[i].e1].f1] = true;
            }
            if (hideEdge[f[i].e2]) {
                selected[ed[f[i].e2].f2] = true;
                selected[ed[f[i].e2].f1] = true;
            }
            if (hideEdge[f[i].e3]) {
                selected[ed[f[i].e3].f2] = true;
                selected[ed[f[i].e3].f1] = true;
            }
        }
        this.currentTool.getWindow().setUndoRecord(new UndoRecord(this.currentTool.getWindow(), false, 15, new Object[]{this.controller, this.controller.getSelectionMode(), oldSelection}));
        this.controller.setSelection(selected);
        this.currentTool.getWindow().updateMenus();
        if (!e.isShiftDown() && wantHandleClicks) {
            this.activeTool.mousePressedOnHandle(e, this, 0, j);
            this.sentClick = true;
        }
    }

    protected void mouseDragged(WidgetMouseEvent e) {
        if (!this.dragging) {
            Point p = e.getPoint();
            if (Math.abs(p.x - this.clickPoint.x) < 2 && Math.abs(p.y - this.clickPoint.y) < 2) {
                return;
            }
        }
        this.dragging = true;
        this.deselect = -1;
        super.mouseDragged(e);
    }

    protected void mouseReleased(WidgetMouseEvent e) {
        boolean tolerant;
        TriangleMesh mesh = (TriangleMesh)this.getController().getObject().getObject();
        TriangleMesh.Edge[] ed = mesh.getEdges();
        TriangleMesh.Face[] fc = mesh.getFaces();
        this.moveToGrid(e);
        this.endDraggingSelection();
        boolean[] selected = this.controller.getSelection();
        boolean[] oldSelection = (boolean[])selected.clone();
        if (this.draggingSelectionBox && !e.isShiftDown() && !e.isControlDown()) {
            for (int i = 0; i < selected.length; ++i) {
                selected[i] = false;
            }
        }
        boolean[] hideVert = this.controller instanceof TriMeshEditorWindow ? ((TriMeshEditorWindow)this.controller).hideVert : new boolean[mesh.getVertices().length];
        boolean[] hideEdge = this.controller instanceof TriMeshEditorWindow ? ((TriMeshEditorWindow)this.controller).hideEdge : new boolean[ed.length];
        boolean[] hideFace = this.controller instanceof TriMeshEditorWindow ? ((TriMeshEditorWindow)this.controller).hideFace : new boolean[fc.length];
        boolean bl = tolerant = this.controller instanceof TriMeshEditorWindow ? ((TriMeshEditorWindow)this.controller).tolerant : false;
        if (this.selectBounds != null) {
            int i;
            boolean newsel;
            boolean bl2 = newsel = !e.isControlDown();
            if (this.controller.getSelectionMode() == 0) {
                for (i = 0; i < selected.length; ++i) {
                    if (hideVert[i] || !this.selectionRegionContains(this.screenVert[i])) continue;
                    selected[i] = newsel;
                }
            } else if (this.controller.getSelectionMode() == 1) {
                if (tolerant) {
                    for (i = 0; i < selected.length; ++i) {
                        if (hideEdge[i] || !this.selectionRegionIntersects(this.screenVert[ed[i].v1], this.screenVert[ed[i].v2])) continue;
                        selected[i] = newsel;
                    }
                } else {
                    for (i = 0; i < selected.length; ++i) {
                        if (hideEdge[i] || !this.selectionRegionContains(this.screenVert[ed[i].v1]) || !this.selectionRegionContains(this.screenVert[ed[i].v2])) continue;
                        selected[i] = newsel;
                    }
                }
            } else if (tolerant) {
                for (i = 0; i < selected.length; ++i) {
                    if (hideFace != null && hideFace[i] || !this.selectionRegionIntersects(this.screenVert[fc[i].v1], this.screenVert[fc[i].v2]) && !this.selectionRegionIntersects(this.screenVert[fc[i].v2], this.screenVert[fc[i].v3]) && !this.selectionRegionIntersects(this.screenVert[fc[i].v3], this.screenVert[fc[i].v1])) continue;
                    selected[i] = newsel;
                }
            } else {
                for (i = 0; i < selected.length; ++i) {
                    if (hideFace != null && hideFace[i] || !this.selectionRegionContains(this.screenVert[fc[i].v1]) || !this.selectionRegionContains(this.screenVert[fc[i].v2]) || !this.selectionRegionContains(this.screenVert[fc[i].v3])) continue;
                    selected[i] = newsel;
                }
            }
        }
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        if (this.sentClick) {
            if (!this.dragging) {
                Point p = e.getPoint();
                e.translatePoint(this.clickPoint.x - p.x, this.clickPoint.y - p.y);
            }
            this.activeTool.mouseReleased(e, this);
        }
        if (this.deselect > -1) {
            selected[this.deselect] = false;
            if (this.controller.getSelectionMode() == 2) {
                TriangleMesh.Face f = fc[this.deselect];
                if (hideEdge[f.e1]) {
                    selected[ed[f.e1].f2] = false;
                    selected[ed[f.e1].f1] = false;
                }
                if (hideEdge[f.e2]) {
                    selected[ed[f.e2].f2] = false;
                    selected[ed[f.e2].f1] = false;
                }
                if (hideEdge[f.e3]) {
                    selected[ed[f.e3].f2] = false;
                    selected[ed[f.e3].f1] = false;
                }
            }
        }
        for (int k = 0; k < selected.length; ++k) {
            if (selected[k] == oldSelection[k]) continue;
            this.currentTool.getWindow().setUndoRecord(new UndoRecord(this.currentTool.getWindow(), false, 15, new Object[]{this.controller, this.controller.getSelectionMode(), oldSelection}));
            break;
        }
        this.controller.setSelection(selected);
        this.currentTool.getWindow().updateMenus();
    }

    public int findClickTarget(Point pos, Vec3 uvw) {
        boolean priorityToSelected;
        double closestz = Double.MAX_VALUE;
        boolean sel = false;
        int which = -1;
        boolean[] selected = this.controller.getSelection();
        boolean bl = priorityToSelected = this.getRenderMode() == 0 || this.getRenderMode() == 4;
        if (this.controller.getSelectionMode() == 0) {
            TriangleMesh mesh = (TriangleMesh)this.getController().getObject().getObject();
            TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])mesh.getVertices();
            for (int i = 0; i < vt.length; ++i) {
                double z;
                if (!this.visible[i] || sel && !selected[i] && priorityToSelected) continue;
                Point v1 = this.screenVert[i];
                if (pos.x < v1.x - 2 || pos.x > v1.x + 2 || pos.y < v1.y - 2 || pos.y > v1.y + 2 || !((z = this.theCamera.getObjectToView().timesZ(vt[i].r)) < closestz) && (sel || !selected[i] || !priorityToSelected)) continue;
                which = i;
                closestz = z;
                sel = selected[i];
            }
        } else if (this.controller.getSelectionMode() == 1) {
            TriangleMesh mesh = (TriangleMesh)this.getController().getObject().getObject();
            TriangleMesh.Edge[] origEd = mesh.getEdges();
            int[] projectedEdge = null;
            if (this.controller instanceof TriMeshEditorWindow) {
                projectedEdge = ((TriMeshEditorWindow)this.controller).findProjectedEdges();
            }
            if (projectedEdge != null) {
                mesh = ((TriMeshEditorWindow)this.controller).getSubdividedMesh();
            }
            TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])mesh.getVertices();
            TriangleMesh.Edge[] ed = mesh.getEdges();
            boolean[] hideEdge = this.controller instanceof TriMeshEditorWindow ? ((TriMeshEditorWindow)this.controller).hideEdge : new boolean[ed.length];
            for (int i = 0; i < ed.length; ++i) {
                double w;
                double u;
                double v;
                Point v2;
                Point v1;
                if (projectedEdge == null) {
                    if (!this.visible[ed[i].v1] || !this.visible[ed[i].v2] || hideEdge[i] || sel && !selected[i] && priorityToSelected) continue;
                    v1 = this.screenVert[ed[i].v1];
                    v2 = this.screenVert[ed[i].v2];
                } else {
                    int orig = projectedEdge[i];
                    if (orig == -1 || !this.visible[origEd[orig].v1] || !this.visible[origEd[orig].v2] || hideEdge[orig] || sel && !selected[orig] && priorityToSelected) continue;
                    Vec2 screen1 = this.theCamera.getObjectToScreen().timesXY(vt[ed[i].v1].r);
                    Vec2 screen2 = this.theCamera.getObjectToScreen().timesXY(vt[ed[i].v2].r);
                    v1 = new Point((int)screen1.x, (int)screen1.y);
                    v2 = new Point((int)screen2.x, (int)screen2.y);
                }
                if (pos.x < v1.x - 2 && pos.x < v2.x - 2 || pos.x > v1.x + 2 && pos.x > v2.x + 2 || pos.y < v1.y - 2 && pos.y < v2.y - 2 || pos.y > v1.y + 2 && pos.y > v2.y + 2) continue;
                if (Math.abs(v1.x - v2.x) > Math.abs(v1.y - v2.y)) {
                    if (v2.x > v1.x) {
                        v = ((double)pos.x - (double)v1.x) / (double)(v2.x - v1.x);
                        u = 1.0 - v;
                    } else {
                        u = ((double)pos.x - (double)v2.x) / (double)(v1.x - v2.x);
                        v = 1.0 - u;
                    }
                    w = u * (double)v1.y + v * (double)v2.y - (double)pos.y;
                } else {
                    if (v2.y > v1.y) {
                        v = ((double)pos.y - (double)v1.y) / (double)(v2.y - v1.y);
                        u = 1.0 - v;
                    } else {
                        u = ((double)pos.y - (double)v2.y) / (double)(v1.y - v2.y);
                        v = 1.0 - u;
                    }
                    w = u * (double)v1.x + v * (double)v2.x - (double)pos.x;
                }
                if (Math.abs(w) > 2.0) continue;
                int index = projectedEdge == null ? i : projectedEdge[i];
                double z = u * this.theCamera.getObjectToView().timesZ(vt[ed[i].v1].r) + v * this.theCamera.getObjectToView().timesZ(vt[ed[i].v2].r);
                if (!(z < closestz) && (sel || !selected[index] || !priorityToSelected)) continue;
                which = index;
                closestz = z;
                sel = selected[which];
                if (uvw == null) continue;
                uvw.set(u, v, w);
            }
        } else {
            TriangleMesh mesh = null;
            if (this.controller instanceof TriMeshEditorWindow) {
                mesh = ((TriMeshEditorWindow)this.controller).getSubdividedMesh();
            }
            if (mesh == null) {
                mesh = (TriangleMesh)this.getController().getObject().getObject();
            }
            TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])mesh.getVertices();
            TriangleMesh.Face[] fc = mesh.getFaces();
            TriangleMesh.Face[] origFc = ((TriangleMesh)this.getController().getObject().getObject()).getFaces();
            double[] param = null;
            boolean[] hideFace = null;
            if (this.controller instanceof TriMeshEditorWindow) {
                TriMeshEditorWindow win = (TriMeshEditorWindow)this.controller;
                if (win.getFaceIndexParameter() != null) {
                    param = ((FaceParameterValue)mesh.getParameterValue(win.getFaceIndexParameter())).getValue();
                }
                hideFace = win.hideFace;
            }
            for (int i = 0; i < fc.length; ++i) {
                double z;
                double u;
                double w;
                double denom;
                double v;
                int index;
                int n = index = param == null ? i : (int)param[i];
                if (hideFace != null && hideFace[index] || !this.visible[origFc[index].v1] || !this.visible[origFc[index].v2] || !this.visible[origFc[index].v3] || sel && !selected[index] && priorityToSelected) continue;
                Vec2 screen1 = this.theCamera.getObjectToScreen().timesXY(vt[fc[i].v1].r);
                Vec2 screen2 = this.theCamera.getObjectToScreen().timesXY(vt[fc[i].v2].r);
                Vec2 screen3 = this.theCamera.getObjectToScreen().timesXY(vt[fc[i].v3].r);
                Point v1 = new Point((int)screen1.x, (int)screen1.y);
                Point v2 = new Point((int)screen2.x, (int)screen2.y);
                Point v3 = new Point((int)screen3.x, (int)screen3.y);
                if (pos.x < v1.x - 2 && pos.x < v2.x - 2 && pos.x < v3.x - 2 || pos.x > v1.x + 2 && pos.x > v2.x + 2 && pos.x > v3.x + 2 || pos.y < v1.y - 2 && pos.y < v2.y - 2 && pos.y < v3.y - 2 || pos.y > v1.y + 2 && pos.y > v2.y + 2 && pos.y > v3.y + 2) continue;
                double e1x = v1.x - v2.x;
                double e1y = v1.y - v2.y;
                double e2x = v1.x - v3.x;
                double e2y = v1.y - v3.y;
                double vy = pos.y - v1.y;
                double vx = pos.x - v1.x;
                if ((v = (e2x *= (denom = 1.0 / (e1x * e2y - e1y * e2x))) * vy - (e2y *= denom) * vx) < 0.0 || v > 1.0 || (w = vx * (e1y *= denom) - vy * (e1x *= denom)) < 0.0 || w > 1.0 || (u = 1.0 - v - w) < 0.0 || u > 1.0 || !((z = u * this.theCamera.getObjectToView().timesZ(vt[fc[i].v1].r) + v * this.theCamera.getObjectToView().timesZ(vt[fc[i].v2].r) + w * this.theCamera.getObjectToView().timesZ(vt[fc[i].v3].r)) < closestz) && (sel || !selected[index] || !priorityToSelected)) continue;
                which = index;
                closestz = z;
                sel = selected[index];
                if (uvw == null) continue;
                uvw.set(u, v, w);
            }
        }
        return which;
    }
}

