/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.math.Vec3;
import artofillusion.object.TriangleMesh;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class TriMeshSelectionUtilities {
    public static boolean[] convertSelection(TriangleMesh mesh, int oldMode, boolean[] selection, int newMode) {
        boolean[] newSel;
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])mesh.getVertices();
        TriangleMesh.Edge[] e = mesh.getEdges();
        TriangleMesh.Face[] f = mesh.getFaces();
        if (newMode == oldMode) {
            return (boolean[])selection.clone();
        }
        if (newMode == 0) {
            newSel = new boolean[v.length];
            if (oldMode == 1) {
                for (int i = 0; i < e.length; ++i) {
                    if (!selection[i]) continue;
                    newSel[e[i].v2] = true;
                    newSel[e[i].v1] = true;
                }
            } else {
                for (int i = 0; i < f.length; ++i) {
                    if (!selection[i]) continue;
                    newSel[f[i].v3] = true;
                    newSel[f[i].v2] = true;
                    newSel[f[i].v1] = true;
                }
            }
        } else if (newMode == 1) {
            newSel = new boolean[e.length];
            if (oldMode == 0) {
                for (int i = 0; i < e.length; ++i) {
                    newSel[i] = selection[e[i].v1] && selection[e[i].v2];
                }
            } else {
                for (int i = 0; i < f.length; ++i) {
                    if (!selection[i]) continue;
                    newSel[f[i].e3] = true;
                    newSel[f[i].e2] = true;
                    newSel[f[i].e1] = true;
                }
            }
        } else {
            newSel = new boolean[f.length];
            if (oldMode == 0) {
                for (int i = 0; i < f.length; ++i) {
                    newSel[i] = selection[f[i].v1] && selection[f[i].v2] && selection[f[i].v3];
                }
            } else {
                for (int i = 0; i < f.length; ++i) {
                    newSel[i] = selection[f[i].e1] && selection[f[i].e2] && selection[f[i].e3];
                }
            }
        }
        return newSel;
    }

    public static boolean[] findSelectionBoundary(TriangleMesh mesh, int oldMode, boolean[] selection) {
        boolean[] edgeSelection = TriMeshSelectionUtilities.convertSelection(mesh, oldMode, selection, 1);
        boolean[] faceSelection = TriMeshSelectionUtilities.convertSelection(mesh, oldMode, selection, 2);
        TriangleMesh.Edge[] e = mesh.getEdges();
        TriangleMesh.Face[] f = mesh.getFaces();
        boolean[] newSel = new boolean[e.length];
        for (int i = 0; i < e.length; ++i) {
            newSel[i] = edgeSelection[i] && (!faceSelection[e[i].f1] || e[i].f2 == -1 || !faceSelection[e[i].f2]);
        }
        return newSel;
    }

    private static boolean[] findSingleEdgeLoop(TriangleMesh mesh, int startEdge) {
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])mesh.getVertices();
        TriangleMesh.Edge[] e = mesh.getEdges();
        TriangleMesh.Face[] f = mesh.getFaces();
        boolean[] newSel = new boolean[e.length];
        int currentEdge = startEdge;
        int currentVert = e[startEdge].v1;
        while (true) {
            if (newSel[currentEdge]) {
                if (currentEdge == startEdge) {
                    return newSel;
                }
                return null;
            }
            newSel[currentEdge] = true;
            Vec3 dir1 = v[e[currentEdge].v1].r.minus(v[e[currentEdge].v2].r);
            dir1.normalize();
            int[] vertEdges = v[currentVert].getEdges();
            int bestEdge = -1;
            double maxDot = -1.0;
            for (int i = 0; i < vertEdges.length; ++i) {
                if (vertEdges[i] == currentEdge) continue;
                Vec3 dir2 = v[e[vertEdges[i]].v1].r.minus(v[e[vertEdges[i]].v2].r);
                dir2.normalize();
                double dot = dir1.dot(dir2);
                if (e[currentEdge].v1 == e[vertEdges[i]].v1 || e[currentEdge].v2 == e[vertEdges[i]].v2) {
                    dot = -dot;
                }
                if (!(dot > maxDot)) continue;
                maxDot = dot;
                bestEdge = vertEdges[i];
            }
            currentEdge = bestEdge;
            currentVert = e[currentEdge].v1 == currentVert ? e[currentEdge].v2 : e[currentEdge].v1;
        }
    }

    public static boolean[] findEdgeLoops(TriangleMesh mesh, boolean[] selection) {
        boolean[] newSel = new boolean[selection.length];
        for (int i = 0; i < selection.length; ++i) {
            if (!selection[i]) continue;
            boolean[] loop = TriMeshSelectionUtilities.findSingleEdgeLoop(mesh, i);
            if (loop == null) {
                return null;
            }
            for (int j = 0; j < loop.length; ++j) {
                int n = j;
                newSel[n] = newSel[n] | loop[j];
            }
        }
        return newSel;
    }

    private static boolean[] findSingleEdgeStrip(TriangleMesh mesh, int startEdge) {
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])mesh.getVertices();
        TriangleMesh.Edge[] e = mesh.getEdges();
        TriangleMesh.Face[] f = mesh.getFaces();
        boolean[] newSel = new boolean[e.length];
        int currentEdge = startEdge;
        int prevEdge = startEdge;
        while (true) {
            int i;
            if (newSel[currentEdge]) {
                if (currentEdge == startEdge) {
                    return newSel;
                }
                return null;
            }
            newSel[currentEdge] = true;
            TriangleMesh.Edge ce = e[currentEdge];
            Vec3 dir1 = v[ce.v1].r.minus(v[ce.v2].r);
            dir1.normalize();
            int bestEdge = -1;
            double maxDot = -1.0;
            HashSet<Integer> v1neighbors = new HashSet<Integer>();
            int[] v1edges = v[ce.v1].getEdges();
            for (int i2 = 0; i2 < v1edges.length; ++i2) {
                TriangleMesh.Edge ed = e[v1edges[i2]];
                if (ed == ce) continue;
                v1neighbors.add(new Integer(ed.v1 == ce.v1 ? ed.v2 : ed.v1));
            }
            HashSet<Integer> v2neighbors = new HashSet<Integer>();
            int[] v2edges = v[ce.v2].getEdges();
            for (int i3 = 0; i3 < v2edges.length; ++i3) {
                TriangleMesh.Edge ed = e[v2edges[i3]];
                if (ed == ce) continue;
                v2neighbors.add(new Integer(ed.v1 == ce.v2 ? ed.v2 : ed.v1));
            }
            Iterator n2iter = v2neighbors.iterator();
            while (n2iter.hasNext()) {
                int neighbor = (Integer)n2iter.next();
                int[] neighborEdges = v[neighbor].getEdges();
                for (i = 0; i < neighborEdges.length; ++i) {
                    if (neighborEdges[i] == prevEdge) continue;
                    TriangleMesh.Edge ed = e[neighborEdges[i]];
                    if (!v1neighbors.contains(new Integer(ed.v1)) && !v1neighbors.contains(new Integer(ed.v2))) continue;
                    Vec3 dir2 = v[ed.v1].r.minus(v[ed.v2].r);
                    dir2.normalize();
                    double dot = Math.abs(dir1.dot(dir2));
                    if (!(dot > maxDot)) continue;
                    maxDot = dot;
                    bestEdge = neighborEdges[i];
                }
            }
            if (bestEdge == -1) {
                return null;
            }
            ArrayList<TriangleMesh.Face> faceList1 = new ArrayList<TriangleMesh.Face>();
            faceList1.add(f[ce.f1]);
            if (ce.f2 != -1) {
                faceList1.add(f[ce.f2]);
            }
            ArrayList<TriangleMesh.Face> faceList2 = new ArrayList<TriangleMesh.Face>();
            faceList2.add(f[e[bestEdge].f1]);
            if (e[bestEdge].f2 != -1) {
                faceList2.add(f[e[bestEdge].f2]);
            }
            block5: for (i = 0; i < faceList1.size(); ++i) {
                TriangleMesh.Face fc1 = (TriangleMesh.Face)faceList1.get(i);
                for (int j = 0; j < faceList2.size(); ++j) {
                    TriangleMesh.Face fc2 = (TriangleMesh.Face)faceList2.get(j);
                    if (fc1.e1 == fc2.e1 || fc1.e1 == fc2.e2 || fc1.e1 == fc2.e3) {
                        newSel[fc1.e1] = true;
                        continue block5;
                    }
                    if (fc1.e2 == fc2.e1 || fc1.e2 == fc2.e2 || fc1.e2 == fc2.e3) {
                        newSel[fc1.e2] = true;
                        continue block5;
                    }
                    if (fc1.e3 != fc2.e1 && fc1.e3 != fc2.e2 && fc1.e3 != fc2.e3) continue;
                    newSel[fc1.e3] = true;
                    continue block5;
                }
            }
            prevEdge = currentEdge;
            currentEdge = bestEdge;
        }
    }

    public static boolean[] findEdgeStrips(TriangleMesh mesh, boolean[] selection) {
        boolean[] newSel = new boolean[selection.length];
        for (int i = 0; i < selection.length; ++i) {
            if (!selection[i]) continue;
            boolean[] loop = TriMeshSelectionUtilities.findSingleEdgeStrip(mesh, i);
            if (loop == null) {
                return null;
            }
            for (int j = 0; j < loop.length; ++j) {
                int n = j;
                newSel[n] = newSel[n] | loop[j];
            }
        }
        return newSel;
    }
}

