/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.ui.UIUtilities;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BWindow;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;

public class TitleWindow
extends BWindow {
    private PropertyChangeListener activeWindowListener;

    public TitleWindow() {
        int imageNumber = new Random(System.currentTimeMillis()).nextInt(8);
        ImageIcon image = new ImageIcon(this.getClass().getResource("/artofillusion/titleImages/titleImage" + imageNumber + ".jpg"));
        String text = "<html><div align=\"center\">Art of Illusion v" + ArtOfIllusion.getVersion() + "<br>Copyright 1999-2010 by Peter Eastman and others" + "<br>(See the README file for details.)" + "<br>This program may be freely distributed under" + "<br>the terms of the accompanying license.</div></html>";
        BLabel label = new BLabel(text, image, BLabel.NORTH, BLabel.SOUTH);
        label.setFont(new Font("Serif", 0, 12));
        BOutline content = BOutline.createLineBorder(new BOutline(label, BorderFactory.createEmptyBorder(0, 0, 5, 0)), Color.BLACK, 1);
        Color background = Color.white;
        if (imageNumber == 4) {
            background = new Color(204, 204, 255);
        } else if (imageNumber == 6) {
            background = new Color(232, 255, 232);
        }
        UIUtilities.applyBackground(content, background);
        this.setContent(content);
        this.pack();
        Rectangle bounds = this.getBounds();
        ++bounds.height;
        this.setBounds(bounds);
        UIUtilities.centerWindow(this);
        this.setVisible(true);
        this.activeWindowListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof Dialog) {
                    TitleWindow.this.setVisible(false);
                } else if (!TitleWindow.this.isVisible()) {
                    TitleWindow.this.setVisible(true);
                }
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("activeWindow", this.activeWindowListener);
    }

    public void dispose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("activeWindow", this.activeWindowListener);
        super.dispose();
    }
}

