/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MeshEditorWindow;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.MeshEditingTool;
import artofillusion.ui.NinePointManipulator;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import java.awt.Image;
import java.awt.Point;
import java.text.NumberFormat;

public class ThickenMeshTool
extends MeshEditingTool {
    private boolean dragInProgress;
    private Point clickPoint;
    private Vec3[] norm;
    private Vec3[] baseVertPos;
    private UndoRecord undo;
    private final NinePointManipulator manipulator;

    public ThickenMeshTool(EditingWindow fr, MeshEditController controller) {
        super(fr, controller);
        this.initButton("outsetPoints");
        this.manipulator = new NinePointManipulator(new Image[]{null, null, null, null, NinePointManipulator.ARROWS_N_S, null, null, null, null});
        this.manipulator.addEventLink(NinePointManipulator.HandlePressedEvent.class, (Object)this, "handlePressed");
        this.manipulator.addEventLink(NinePointManipulator.HandleDraggedEvent.class, (Object)this, "handleDragged");
        this.manipulator.addEventLink(NinePointManipulator.HandleReleasedEvent.class, (Object)this, "handleReleased");
    }

    public boolean allowSelectionChanges() {
        return !this.dragInProgress;
    }

    public String getToolTipText() {
        return Translate.text("thickenMeshTool.tipText");
    }

    public void drawOverlay(ViewerCanvas view) {
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        if (!this.dragInProgress) {
            if (selectionBounds != null) {
                this.manipulator.draw(view, selectionBounds);
                this.theWindow.setHelpText(Translate.text("thickenMeshTool.helpText"));
            } else {
                this.theWindow.setHelpText(Translate.text("thickenMeshTool.errorText"));
            }
        }
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        this.dragInProgress = false;
        if (selectionBounds != null) {
            this.dragInProgress = this.manipulator.mousePressed(e, view, selectionBounds);
        }
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        this.manipulator.mouseDragged(e, view);
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        this.manipulator.mouseReleased(e, view);
    }

    protected void handlePressed(NinePointManipulator.HandlePressedEvent ev) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        this.clickPoint = ev.getMouseEvent().getPoint();
        this.norm = mesh.getNormals();
        this.baseVertPos = mesh.getVertexPositions();
    }

    protected void handleDragged(NinePointManipulator.HandleDraggedEvent ev) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        Point dragPoint = ev.getMouseEvent().getPoint();
        if (this.undo == null) {
            this.undo = new UndoRecord(this.theWindow, false, 13, new Object[]{mesh, mesh.getVertexPositions()});
        }
        double distance = 0.01 * (double)(this.clickPoint.y - dragPoint.y);
        Vec3[] v = this.findNewPositions(this.baseVertPos, distance);
        mesh.setVertexPositions(v);
        this.controller.objectChanged();
        this.theWindow.updateImage();
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(2);
        if (distance < 0.0) {
            this.theWindow.setHelpText(Translate.text("thickenMeshTool.dragText.inward", format.format(-distance)));
        } else {
            this.theWindow.setHelpText(Translate.text("thickenMeshTool.dragText.outward", format.format(distance)));
        }
    }

    protected void handleReleased(NinePointManipulator.HandleReleasedEvent ev) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        Point dragPoint = ev.getMouseEvent().getPoint();
        if (this.undo != null) {
            this.theWindow.setUndoRecord(this.undo);
            double distance = 0.01 * (double)(this.clickPoint.y - dragPoint.y);
            Vec3[] v = this.findNewPositions(this.baseVertPos, distance);
            mesh.setVertexPositions(v);
        }
        this.controller.objectChanged();
        this.theWindow.updateImage();
        this.norm = null;
        this.undo = null;
        this.baseVertPos = null;
        this.dragInProgress = false;
    }

    private Vec3[] findNewPositions(Vec3[] vert, double distance) {
        int i;
        Vec3[] v = new Vec3[vert.length];
        int[] selected = this.controller.getSelectionDistance();
        for (i = 0; i < v.length; ++i) {
            v[i] = selected[i] == 0 ? this.norm[i].times(distance) : new Vec3();
        }
        ((MeshEditorWindow)this.theFrame).adjustDeltas(v);
        for (i = 0; i < vert.length; ++i) {
            v[i].add(vert[i]);
        }
        return v;
    }
}

