/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.MeshEditingTool;
import artofillusion.ui.NinePointManipulator;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class TaperMeshTool
extends MeshEditingTool {
    private boolean dragInProgress;
    private boolean taperAll;
    private boolean towardCenter;
    private Point clickPoint;
    private NinePointManipulator.HandlePosition whichHandle;
    private double boundsHeight;
    private double boundsWidth;
    private Vec3[] baseVertPos;
    private UndoRecord undo;
    private final NinePointManipulator manipulator;
    public static final int HANDLE_SIZE = 5;

    public TaperMeshTool(EditingWindow fr, MeshEditController controller) {
        super(fr, controller);
        this.initButton("taperPoints");
        this.manipulator = new NinePointManipulator(new Image[]{NinePointManipulator.ARROWS_S_E, null, NinePointManipulator.ARROWS_S_W, null, null, null, NinePointManipulator.ARROWS_N_E, null, NinePointManipulator.ARROWS_N_W});
        this.manipulator.addEventLink(NinePointManipulator.HandlePressedEvent.class, (Object)this, "handlePressed");
        this.manipulator.addEventLink(NinePointManipulator.HandleDraggedEvent.class, (Object)this, "handleDragged");
        this.manipulator.addEventLink(NinePointManipulator.HandleReleasedEvent.class, (Object)this, "handleReleased");
    }

    public int whichClicks() {
        return 1;
    }

    public boolean allowSelectionChanges() {
        return !this.dragInProgress;
    }

    public String getToolTipText() {
        return Translate.text("taperMeshTool.tipText");
    }

    public void drawOverlay(ViewerCanvas view) {
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        if (selectionBounds != null) {
            if (!this.dragInProgress) {
                this.manipulator.draw(view, selectionBounds);
            }
            this.theWindow.setHelpText(Translate.text("taperMeshTool.helpText"));
        } else {
            this.theWindow.setHelpText(Translate.text("taperMeshTool.errorText"));
        }
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        this.dragInProgress = false;
        if (selectionBounds != null) {
            this.dragInProgress = this.manipulator.mousePressed(e, view, selectionBounds);
        }
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        this.manipulator.mouseDragged(e, view);
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        this.manipulator.mouseReleased(e, view);
    }

    protected void handlePressed(NinePointManipulator.HandlePressedEvent ev) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        this.clickPoint = ev.getMouseEvent().getPoint();
        this.whichHandle = ev.getHandle();
        this.taperAll = ev.getMouseEvent().isShiftDown();
        this.towardCenter = ev.getMouseEvent().isControlDown();
        Rectangle r = ev.getScreenBounds();
        this.boundsHeight = r.height;
        this.boundsWidth = r.width;
        this.baseVertPos = mesh.getVertexPositions();
    }

    protected void handleDragged(NinePointManipulator.HandleDraggedEvent ev) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        if (this.undo == null) {
            this.undo = new UndoRecord(this.theWindow, false, 13, new Object[]{mesh, mesh.getVertexPositions()});
        }
        Vec3[] v = this.findTaperedPositions(this.baseVertPos, ev.getMouseEvent().getPoint(), ev.getSelectionBounds(), (MeshViewer)ev.getView());
        mesh.setVertexPositions(v);
        this.controller.objectChanged();
        this.theWindow.updateImage();
    }

    protected void handleReleased(NinePointManipulator.HandleReleasedEvent ev) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        if (this.undo != null) {
            this.theWindow.setUndoRecord(this.undo);
        }
        Vec3[] v = this.findTaperedPositions(this.baseVertPos, ev.getMouseEvent().getPoint(), ev.getSelectionBounds(), (MeshViewer)ev.getView());
        mesh.setVertexPositions(v);
        this.controller.objectChanged();
        this.theWindow.updateImage();
        this.undo = null;
        this.baseVertPos = null;
        this.dragInProgress = false;
    }

    private Vec3[] findTaperedPositions(Vec3[] vert, Point pos, BoundingBox bounds, MeshViewer view) {
        int i;
        double taper;
        Vec3[] v = new Vec3[vert.length];
        int[] selected = this.controller.getSelectionDistance();
        Camera cam = view.getCamera();
        double clickX = this.clickPoint.x;
        double clickY = this.clickPoint.y;
        double posX = pos.x;
        double posY = pos.y;
        boolean direction = !(Math.abs(posX - clickX) > Math.abs(posY - clickY));
        Vec3 center = new Vec3(0.0, 0.0, (bounds.minz + bounds.maxz) / 2.0);
        if (bounds.minx == bounds.maxx || bounds.miny == bounds.maxy) {
            taper = 0.0;
        } else if (!direction) {
            center.x = this.towardCenter ? (bounds.minx + bounds.maxx) / 2.0 : (this.whichHandle.isWest() ? bounds.minx : bounds.maxx);
            center.y = this.whichHandle.isNorth() ? bounds.miny : bounds.maxy;
            taper = this.whichHandle.isWest() ? (posX - clickX) / this.boundsWidth : (clickX - posX) / this.boundsWidth;
            if (taper > 1.0) {
                taper = 1.0;
            }
            if (this.whichHandle.isSouth()) {
                taper *= -1.0;
            }
        } else {
            center.y = this.towardCenter ? (bounds.miny + bounds.maxy) / 2.0 : (this.whichHandle.isNorth() ? bounds.miny : bounds.maxy);
            center.x = this.whichHandle.isWest() ? bounds.minx : bounds.maxx;
            taper = this.whichHandle.isNorth() ? (posY - clickY) / this.boundsHeight : (clickY - posY) / this.boundsHeight;
            if (taper > 1.0) {
                taper = 1.0;
            }
            if (this.whichHandle.isEast()) {
                taper *= -1.0;
            }
        }
        if (taper == 0.0) {
            for (int i2 = 0; i2 < vert.length; ++i2) {
                v[i2] = new Vec3(vert[i2]);
            }
            return v;
        }
        Mat4 m1 = cam.getObjectToView();
        m1 = Mat4.translation(-center.x, -center.y, -center.z).times(m1);
        Mat4 m2 = Mat4.translation(center.x, center.y, center.z);
        m2 = cam.getViewToWorld().times(m2);
        m2 = view.getDisplayCoordinates().toLocal().times(m2);
        for (i = 0; i < vert.length; ++i) {
            if (selected[i] == 0) {
                v[i] = m1.times(vert[i]);
                if (!direction) {
                    v[i].x *= 1.0 - taper * v[i].y / (bounds.maxy - bounds.miny);
                    if (this.taperAll) {
                        v[i].z *= 1.0 - taper * v[i].y / (bounds.maxy - bounds.miny);
                    }
                } else {
                    v[i].y *= 1.0 - taper * v[i].x / (bounds.maxx - bounds.minx);
                    if (this.taperAll) {
                        v[i].z *= 1.0 - taper * v[i].x / (bounds.maxx - bounds.minx);
                    }
                }
                v[i] = m2.times(v[i]).minus(vert[i]);
                continue;
            }
            v[i] = new Vec3();
        }
        if (this.theFrame instanceof MeshEditorWindow) {
            ((MeshEditorWindow)this.theFrame).adjustDeltas(v);
        }
        for (i = 0; i < vert.length; ++i) {
            v[i].add(vert[i]);
        }
        return v;
    }
}

