/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.MeshEditingTool;
import artofillusion.ui.NinePointManipulator;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class SkewMeshTool
extends MeshEditingTool {
    private boolean dragInProgress;
    private boolean skewX;
    private boolean skewY;
    private boolean skewAll;
    private double clickX;
    private double clickY;
    private double centerX;
    private double centerY;
    private Vec3 skewCenter;
    private Vec3[] baseVertPos;
    private UndoRecord undo;
    private final NinePointManipulator manipulator;
    public static final int HANDLE_SIZE = 5;

    public SkewMeshTool(EditingWindow fr, MeshEditController controller) {
        super(fr, controller);
        this.initButton("skewPoints");
        this.manipulator = new NinePointManipulator(new Image[]{NinePointManipulator.ARROWS_S_E, NinePointManipulator.ARROWS_E_W, NinePointManipulator.ARROWS_S_W, NinePointManipulator.ARROWS_N_S, null, NinePointManipulator.ARROWS_N_S, NinePointManipulator.ARROWS_N_E, NinePointManipulator.ARROWS_E_W, NinePointManipulator.ARROWS_N_W});
        this.manipulator.addEventLink(NinePointManipulator.HandlePressedEvent.class, (Object)this, "handlePressed");
        this.manipulator.addEventLink(NinePointManipulator.HandleDraggedEvent.class, (Object)this, "handleDragged");
        this.manipulator.addEventLink(NinePointManipulator.HandleReleasedEvent.class, (Object)this, "handleReleased");
    }

    public int whichClicks() {
        return 1;
    }

    public boolean allowSelectionChanges() {
        return !this.dragInProgress;
    }

    public String getToolTipText() {
        return Translate.text("skewMeshTool.tipText");
    }

    public void drawOverlay(ViewerCanvas view) {
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        if (selectionBounds != null) {
            if (!this.dragInProgress) {
                this.manipulator.draw(view, selectionBounds);
            }
            this.theWindow.setHelpText(Translate.text("skewMeshTool.helpText"));
        } else {
            this.theWindow.setHelpText(Translate.text("skewMeshTool.errorText"));
        }
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        this.dragInProgress = false;
        if (selectionBounds != null) {
            this.dragInProgress = this.manipulator.mousePressed(e, view, selectionBounds);
        }
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        this.manipulator.mouseDragged(e, view);
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        this.manipulator.mouseReleased(e, view);
    }

    protected void handlePressed(NinePointManipulator.HandlePressedEvent ev) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        Point clickPoint = ev.getMouseEvent().getPoint();
        this.clickX = clickPoint.x;
        this.clickY = clickPoint.y;
        BoundingBox bounds = ev.getSelectionBounds();
        Rectangle r = ev.getScreenBounds();
        NinePointManipulator.HandlePosition handle = ev.getHandle();
        this.skewCenter = new Vec3(0.0, 0.0, (bounds.minz + bounds.maxz) / 2.0);
        if (handle.isWest()) {
            this.skewY = true;
            this.centerX = r.x + r.width;
            this.skewCenter.x = bounds.minx;
        } else if (handle.isEast()) {
            this.skewY = true;
            this.centerX = r.x;
            this.skewCenter.x = bounds.maxx;
        } else {
            this.skewY = false;
            this.skewCenter.x = bounds.minx + bounds.maxx;
        }
        if (handle.isNorth()) {
            this.skewX = true;
            this.centerY = r.y + r.height;
            this.skewCenter.y = bounds.miny;
        } else if (handle.isSouth()) {
            this.skewX = true;
            this.centerY = r.y;
            this.skewCenter.y = bounds.maxy;
        } else {
            this.skewX = false;
            this.skewCenter.y = bounds.miny + bounds.maxy;
        }
        if (ev.getMouseEvent().isControlDown()) {
            this.centerX = r.x + r.width / 2;
            this.centerY = r.y + r.height / 2;
            this.skewCenter.x = (bounds.minx + bounds.maxx) / 2.0;
            this.skewCenter.y = (bounds.miny + bounds.maxy) / 2.0;
        }
        this.skewAll = this.skewX && this.skewY && ev.getMouseEvent().isShiftDown();
        this.baseVertPos = mesh.getVertexPositions();
    }

    protected void handleDragged(NinePointManipulator.HandleDraggedEvent ev) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        Point dragPoint = ev.getMouseEvent().getPoint();
        if (this.undo == null) {
            this.undo = new UndoRecord(this.theWindow, false, 13, new Object[]{mesh, mesh.getVertexPositions()});
        }
        double yskew = 0.0;
        double xskew = 0.0;
        if (this.skewX) {
            xskew = ((double)dragPoint.x - this.clickX) / ((double)dragPoint.y - this.centerY);
        }
        if (this.skewY) {
            yskew = ((double)dragPoint.y - this.clickY) / ((double)dragPoint.x - this.centerX);
        }
        if (this.skewAll) {
            double max = Math.max(Math.abs(xskew), Math.abs(yskew));
            if (xskew != 0.0) {
                xskew *= max / Math.abs(xskew);
            }
            if (yskew != 0.0) {
                yskew *= max / Math.abs(yskew);
            }
        }
        Vec3[] v = this.findSkewedPositions(this.baseVertPos, xskew, yskew, (MeshViewer)ev.getView());
        mesh.setVertexPositions(v);
        this.controller.objectChanged();
        this.theWindow.updateImage();
    }

    protected void handleReleased(NinePointManipulator.HandleReleasedEvent ev) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        Point dragPoint = ev.getMouseEvent().getPoint();
        double yskew = 0.0;
        double xskew = 0.0;
        if (this.skewX) {
            xskew = ((double)dragPoint.x - this.clickX) / ((double)dragPoint.y - this.centerY);
        }
        if (this.skewY) {
            yskew = ((double)dragPoint.y - this.clickY) / ((double)dragPoint.x - this.centerX);
        }
        if (this.skewAll) {
            double max = Math.max(Math.abs(xskew), Math.abs(yskew));
            if (xskew != 0.0) {
                xskew *= max / Math.abs(xskew);
            }
            if (yskew != 0.0) {
                yskew *= max / Math.abs(yskew);
            }
        }
        if (this.undo != null) {
            this.theWindow.setUndoRecord(this.undo);
        }
        Vec3[] v = this.findSkewedPositions(this.baseVertPos, xskew, yskew, (MeshViewer)ev.getView());
        mesh.setVertexPositions(v);
        this.controller.objectChanged();
        this.theWindow.updateImage();
        this.undo = null;
        this.baseVertPos = null;
        this.dragInProgress = false;
    }

    private Vec3[] findSkewedPositions(Vec3[] vert, double xskew, double yskew, MeshViewer view) {
        int i;
        Vec3[] v = new Vec3[vert.length];
        int[] selected = this.controller.getSelectionDistance();
        Camera cam = view.getCamera();
        Mat4 m = cam.getObjectToView();
        m = Mat4.translation(-this.skewCenter.x, -this.skewCenter.y, -this.skewCenter.z).times(m);
        Mat4 s = new Mat4(1.0, xskew, 0.0, 0.0, yskew, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        m = s.times(m);
        m = Mat4.translation(this.skewCenter.x, this.skewCenter.y, this.skewCenter.z).times(m);
        m = cam.getViewToWorld().times(m);
        m = view.getDisplayCoordinates().toLocal().times(m);
        for (i = 0; i < vert.length; ++i) {
            v[i] = selected[i] == 0 ? m.times(vert[i]).minus(vert[i]) : new Vec3();
        }
        if (this.theFrame instanceof MeshEditorWindow) {
            ((MeshEditorWindow)this.theFrame).adjustDeltas(v);
        }
        for (i = 0; i < vert.length; ++i) {
            v[i].add(vert[i]);
        }
        return v;
    }
}

