/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class ScaleObjectTool
extends EditingTool {
    static final int TOP = 1;
    static final int BOTTOM = 2;
    static final int LEFT = 4;
    static final int RIGHT = 8;
    static final int POSITIONS_FIXED = 0;
    static final int POSITIONS_SCALE = 1;
    static final int OPMODE_SCALE = 0;
    static final int OPMODE_MOVE = 1;
    private BoundingBox[] bounds;
    private Point clickPoint;
    private Vec3[] objectPos;
    private Vec3[] scaleCenter;
    private Object3D[] oldObj;
    private CoordinateSystem[] oldCoords;
    private Vector<ObjectInfo> toMove;
    private double halfx;
    private double halfy;
    private double centerx;
    private double centery;
    private ObjectInfo clickedObject;
    private int whichSides;
    private int opmode;
    private int[] haxis;
    private int[] vaxis;
    private int[] haxisDir;
    private int[] vaxisDir;
    private int scaleAround = 0;
    private boolean scaleAll;
    private boolean dragged;
    private boolean applyToChildren = true;

    public ScaleObjectTool(EditingWindow fr) {
        super(fr);
        this.initButton("resize");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("scaleObjectTool.helpText"));
    }

    public int whichClicks() {
        return 6;
    }

    public boolean allowSelectionChanges() {
        return true;
    }

    public String getToolTipText() {
        return Translate.text("scaleObjectTool.tipText");
    }

    public void mousePressedOnHandle(WidgetMouseEvent e, ViewerCanvas view, int obj, int handle) {
        ObjectInfo info;
        int i;
        Scene theScene = this.theWindow.getScene();
        Camera cam = view.getCamera();
        this.opmode = 0;
        this.toMove = new Vector();
        this.clickedObject = theScene.getObject(obj);
        int[] sel = this.applyToChildren ? theScene.getSelectionWithChildren() : theScene.getSelection();
        for (i = 0; i < sel.length; ++i) {
            this.toMove.addElement(theScene.getObject(sel[i]));
        }
        this.bounds = new BoundingBox[this.toMove.size()];
        this.scaleCenter = new Vec3[this.toMove.size()];
        this.haxis = new int[this.toMove.size()];
        this.vaxis = new int[this.toMove.size()];
        this.haxisDir = new int[this.toMove.size()];
        this.vaxisDir = new int[this.toMove.size()];
        this.objectPos = new Vec3[this.toMove.size()];
        for (i = 0; i < this.objectPos.length; ++i) {
            info = this.toMove.elementAt(i);
            this.objectPos[i] = info.getCoords().getOrigin();
        }
        for (i = 0; i < this.bounds.length; ++i) {
            this.bounds[i] = this.toMove.elementAt(i).getBounds();
            cam.setObjectTransform(this.toMove.elementAt(i).getCoords().fromLocal());
            Vec3 screenx = cam.getObjectToView().timesDirection(Vec3.vx());
            Vec3 screeny = cam.getObjectToView().timesDirection(Vec3.vy());
            Vec3 screenz = cam.getObjectToView().timesDirection(Vec3.vz());
            this.haxis[i] = Math.abs(screenx.x) > Math.abs(screeny.x) ? (Math.abs(screenz.x) > Math.abs(screenx.x) ? 2 : 0) : (Math.abs(screenz.x) > Math.abs(screeny.x) ? 2 : 1);
            this.vaxis[i] = Math.abs(screenx.y) > Math.abs(screeny.y) ? (Math.abs(screenz.y) > Math.abs(screenx.y) ? 2 : 0) : (Math.abs(screenz.y) > Math.abs(screeny.y) ? 2 : 1);
            if (this.vaxis[i] == this.haxis[i]) {
                this.vaxis[i] = (this.vaxis[i] + 1) % 3;
            }
            Vec3[] dirs = new Vec3[]{screenx, screeny, screenz};
            this.haxisDir[i] = dirs[this.haxis[i]].x > 0.0 ? 1 : -1;
            this.vaxisDir[i] = dirs[this.vaxis[i]].y > 0.0 ? 1 : -1;
        }
        if (e.isControlDown()) {
            if (this.scaleAround == 0) {
                for (i = 0; i < this.scaleCenter.length; ++i) {
                    this.scaleCenter[i] = this.toMove.elementAt(i).getCoords().getOrigin();
                }
            } else {
                for (i = 0; i < this.scaleCenter.length; ++i) {
                    this.scaleCenter[i] = this.clickedObject.getCoords().getOrigin();
                }
            }
            for (i = 0; i < this.scaleCenter.length; ++i) {
                this.scaleCenter[i] = this.toMove.elementAt(i).getCoords().toLocal().times(this.scaleCenter[i]);
            }
            cam.setObjectTransform(this.clickedObject.getCoords().fromLocal());
            Rectangle r = cam.findScreenBounds(this.clickedObject.getBounds());
            this.halfx = (double)r.width / 2.0;
            this.halfy = (double)r.height / 2.0;
            this.centerx = (double)r.x + this.halfx;
            this.centery = (double)r.y + this.halfy;
        } else {
            if (this.scaleAround == 0) {
                for (i = 0; i < this.scaleCenter.length; ++i) {
                    info = this.toMove.elementAt(i);
                    this.scaleCenter[i] = this.findBorderPos(info.getBounds(), info.getCoords().getOrigin(), this.haxis[i], this.vaxis[i], this.haxisDir[i], this.vaxisDir[i], handle);
                }
            } else {
                i = 0;
                while (this.toMove.elementAt(i) != this.clickedObject) {
                    ++i;
                }
                Vec3 center = this.findBorderPos(this.clickedObject.getBounds(), this.clickedObject.getCoords().getOrigin(), this.haxis[i], this.vaxis[i], this.haxisDir[i], this.vaxisDir[i], handle);
                center = this.clickedObject.getCoords().fromLocal().times(center);
                for (i = 0; i < this.scaleCenter.length; ++i) {
                    this.scaleCenter[i] = this.toMove.elementAt(i).getCoords().toLocal().times(center);
                }
            }
            cam.setObjectTransform(this.clickedObject.getCoords().fromLocal());
            Rectangle r = cam.findScreenBounds(this.clickedObject.getBounds());
            this.halfx = (double)r.width / 2.0;
            this.halfy = (double)r.height / 2.0;
            this.centerx = handle == 0 || handle == 3 || handle == 5 ? (double)(r.x + r.width) : (handle == 1 || handle == 6 ? (double)r.x + this.halfx : (double)r.x);
            this.centery = handle == 0 || handle == 1 || handle == 2 ? (double)(r.y + r.height) : (handle == 3 || handle == 4 ? (double)r.y + this.halfy : (double)r.y);
            this.halfx *= 2.0;
            this.halfy *= 2.0;
        }
        this.dragged = false;
        this.scaleAll = e.isShiftDown();
        this.whichSides = 0;
        if (handle < 3) {
            ++this.whichSides;
        }
        if (handle > 4) {
            this.whichSides += 2;
        }
        if (handle == 0 || handle == 3 || handle == 5) {
            this.whichSides += 4;
        }
        if (handle == 2 || handle == 4 || handle == 7) {
            this.whichSides += 8;
        }
    }

    public void mousePressedOnObject(WidgetMouseEvent e, ViewerCanvas view, int obj) {
        int i;
        Scene theScene = this.theWindow.getScene();
        this.opmode = 1;
        this.toMove = new Vector();
        this.clickedObject = theScene.getObject(obj);
        int[] sel = this.applyToChildren ? theScene.getSelectionWithChildren() : theScene.getSelection();
        for (i = 0; i < sel.length; ++i) {
            this.toMove.addElement(theScene.getObject(sel[i]));
        }
        this.objectPos = new Vec3[this.toMove.size()];
        for (i = 0; i < this.objectPos.length; ++i) {
            ObjectInfo info = this.toMove.elementAt(i);
            this.objectPos[i] = info.getCoords().getOrigin();
        }
        this.clickPoint = e.getPoint();
        this.dragged = false;
    }

    private Vec3 findBorderPos(BoundingBox bb, Vec3 center, int h, int v, int hdir, int vdir, int handle) {
        double swap;
        double maxv;
        double centerv;
        double minv;
        double maxh;
        double centerh;
        double minh;
        if (h == 0) {
            minh = bb.minx;
            centerh = center.x;
            maxh = bb.maxx;
        } else if (h == 1) {
            minh = bb.miny;
            centerh = center.y;
            maxh = bb.maxy;
        } else {
            minh = bb.minz;
            centerh = center.z;
            maxh = bb.maxz;
        }
        if (v == 0) {
            minv = bb.minx;
            centerv = center.x;
            maxv = bb.maxx;
        } else if (v == 1) {
            minv = bb.miny;
            centerv = center.y;
            maxv = bb.maxy;
        } else {
            minv = bb.minz;
            centerv = center.z;
            maxv = bb.maxz;
        }
        if (hdir == -1) {
            swap = minh;
            minh = maxh;
            maxh = swap;
        }
        if (vdir == -1) {
            swap = minv;
            minv = maxv;
            maxv = swap;
        }
        double borderh = handle == 0 || handle == 3 || handle == 5 ? minh : (handle == 1 || handle == 6 ? centerh : maxh);
        double borderv = handle == 0 || handle == 1 || handle == 2 ? minv : (handle == 3 || handle == 4 ? centerv : maxv);
        Vec3 pos = new Vec3(center);
        if (h == 0) {
            pos.x = borderh;
        } else if (v == 0) {
            pos.x = borderv;
        }
        if (h == 1) {
            pos.y = borderh;
        } else if (v == 1) {
            pos.y = borderv;
        }
        if (h == 2) {
            pos.z = borderh;
        } else if (v == 2) {
            pos.z = borderv;
        }
        return pos;
    }

    public void mouseDraggedMoveOp(WidgetMouseEvent e, ViewerCanvas view) {
        CoordinateSystem c;
        int i;
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (!this.dragged) {
            UndoRecord undo = new UndoRecord(this.theWindow, false);
            this.theWindow.setUndoRecord(undo);
            for (i = 0; i < this.toMove.size(); ++i) {
                ObjectInfo info = this.toMove.elementAt(i);
                c = info.getCoords();
                undo.addCommand(1, new Object[]{c, c.duplicate()});
            }
            this.dragged = true;
        }
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (e.isShiftDown() && !e.isControlDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                dy = 0;
            } else {
                dx = 0;
            }
        }
        Vec3 v = e.isControlDown() ? cam.getCameraCoordinates().getZDirection().times((double)(-dy) * 0.01) : cam.findDragVector(this.clickedObject.getCoords().getOrigin(), dx, dy);
        for (i = 0; i < this.toMove.size(); ++i) {
            ObjectInfo info = this.toMove.elementAt(i);
            c = info.getCoords();
            c.setOrigin(this.objectPos[i].plus(v));
        }
        this.theWindow.updateImage();
        this.theWindow.setHelpText(Translate.text("moveObjectTool.dragText", (double)Math.round(v.x * 100000.0) / 100000.0 + ", " + (double)Math.round(v.y * 100000.0) / 100000.0 + ", " + (double)Math.round(v.z * 100000.0) / 100000.0));
    }

    public void mouseDraggedScaleOp(WidgetMouseEvent e, ViewerCanvas view) {
        double size;
        double hscale;
        double vscale;
        ObjectInfo info;
        Scene theScene = this.theWindow.getScene();
        Point dragPoint = e.getPoint();
        double[] scale = new double[3];
        if (!this.dragged) {
            this.oldObj = new Object3D[this.toMove.size()];
            this.oldCoords = new CoordinateSystem[this.toMove.size()];
            UndoRecord undo = new UndoRecord(this.theWindow, false);
            this.theWindow.setUndoRecord(undo);
            for (int i = 0; i < this.toMove.size(); ++i) {
                info = this.toMove.elementAt(i);
                this.oldObj[i] = info.getObject().duplicate();
                this.oldCoords[i] = info.getCoords().duplicate();
                undo.addCommand(1, new Object[]{info.getCoords(), this.oldCoords[i]});
                undo.addCommand(0, new Object[]{info.getObject(), this.oldObj[i]});
            }
            this.dragged = true;
        }
        if (this.scaleAll) {
            vscale = 0.0;
            hscale = 0.0;
        } else {
            vscale = 1.0;
            hscale = 1.0;
        }
        if ((this.whichSides & 1) > 0) {
            size = this.centery - (double)dragPoint.y;
            if (size < 1.0) {
                size = 1.0;
            }
            vscale = size / this.halfy;
        }
        if ((this.whichSides & 2) > 0) {
            size = (double)dragPoint.y - this.centery;
            if (size < 1.0) {
                size = 1.0;
            }
            vscale = size / this.halfy;
        }
        if ((this.whichSides & 4) > 0) {
            size = this.centerx - (double)dragPoint.x;
            if (size < 1.0) {
                size = 1.0;
            }
            hscale = size / this.halfx;
        }
        if ((this.whichSides & 8) > 0) {
            size = (double)dragPoint.x - this.centerx;
            if (size < 1.0) {
                size = 1.0;
            }
            hscale = size / this.halfx;
        }
        for (int i = 0; i < this.toMove.size(); ++i) {
            if (this.scaleAll) {
                scale[1] = scale[2] = Math.max(hscale, vscale);
                scale[0] = scale[2];
            } else {
                scale[2] = 1.0;
                scale[1] = 1.0;
                scale[0] = 1.0;
                scale[this.haxis[i]] = hscale;
                scale[this.vaxis[i]] = vscale;
            }
            Vec3 oldsize = this.bounds[i].getSize();
            info = this.toMove.elementAt(i);
            Object3D obj = info.getObject();
            obj.copyObject(this.oldObj[i]);
            obj.setSize(scale[0] * oldsize.x, scale[1] * oldsize.y, scale[2] * oldsize.z);
            Vec3 offset = new Vec3(this.scaleCenter[i]);
            offset.x *= 1.0 - scale[0];
            offset.y *= 1.0 - scale[1];
            offset.z *= 1.0 - scale[2];
            info.getCoords().setOrigin(this.oldCoords[i].fromLocal().times(offset));
            theScene.objectModified(obj);
        }
        this.theWindow.updateImage();
        if (this.scaleAll) {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", Double.toString((double)Math.round(Math.max(hscale, vscale) * 100000.0) / 100000.0)));
        } else if (this.whichSides == 8 || this.whichSides == 4) {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", Double.toString((double)Math.round(hscale * 100000.0) / 100000.0)));
        } else if (this.whichSides == 1 || this.whichSides == 2) {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", Double.toString((double)Math.round(vscale * 100000.0) / 100000.0)));
        } else {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", (double)Math.round(hscale * 100000.0) / 100000.0 + ", " + (double)Math.round(vscale * 100000.0) / 100000.0));
        }
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        if (this.opmode == 0) {
            this.mouseDraggedScaleOp(e, view);
        } else {
            this.mouseDraggedMoveOp(e, view);
        }
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        this.theWindow.getScene().applyTracksAfterModification(this.toMove);
        this.toMove = null;
        this.objectPos = null;
        this.oldObj = null;
        this.oldCoords = null;
        this.bounds = null;
        this.scaleCenter = null;
        this.theWindow.updateImage();
        this.theWindow.setModified();
        this.theWindow.setHelpText(Translate.text("scaleObjectTool.helpText"));
    }

    public void iconDoubleClicked() {
        BCheckBox childrenBox = new BCheckBox(Translate.text("applyToUnselectedChildren"), this.applyToChildren);
        BComboBox centerChoice = new BComboBox(new String[]{Translate.text("remainFixed"), Translate.text("scaleWithObjects")});
        centerChoice.setSelectedIndex(this.scaleAround);
        RowContainer row = new RowContainer();
        row.add(Translate.label("objectPositions"));
        row.add(centerChoice);
        ComponentsDialog dlg = new ComponentsDialog(this.theFrame, Translate.text("resizeToolTitle"), new Widget[]{childrenBox, row}, new String[]{null, null});
        if (!dlg.clickedOk()) {
            return;
        }
        this.applyToChildren = childrenBox.getState();
        this.scaleAround = centerChoice.getSelectedIndex();
    }
}

