/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.CameraFilterDialog;
import artofillusion.RenderListener;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.image.ComplexImage;
import artofillusion.image.ImageAverager;
import artofillusion.image.ImageSaver;
import artofillusion.image.filter.ImageFilter;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.RepaintEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BorderContainer;
import buoy.widget.CustomWidget;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.WidgetContainer;
import buoy.widget.WindowWidget;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Insets;

public class RenderingDialog
extends BDialog
implements RenderListener {
    private CustomWidget canvas;
    private Image previewImage;
    private ComplexImage originalImage;
    private ComplexImage filteredImage;
    private Renderer renderer;
    private Scene theScene;
    private ObjectInfo sceneCamera;
    private SceneCamera cameraForFilters;
    private Camera theCamera;
    private double start;
    private double end;
    private double originalTime;
    private ImageSaver imgsaver;
    private ImageAverager imgaverager;
    private BButton closeButton;
    private BButton saveButton;
    private BButton filterButton;
    private BLabel label1;
    private BLabel label2;
    private BFrame parent;
    private int w;
    private int h;
    private int fps;
    private int subimages;
    private int currentFrame;
    private int currentSubimage;
    private int totalFrames;
    private long startTime;
    private boolean done;
    private boolean hasModifiedFilters;

    public RenderingDialog(BFrame parent, Renderer rend, Scene sc, Camera cam, ObjectInfo sceneCamera) {
        super(parent, true);
        this.parent = parent;
        this.sceneCamera = sceneCamera;
        this.renderer = rend;
        this.theScene = sc;
        this.layoutDialog(parent, cam);
        this.startTime = System.currentTimeMillis();
        SceneCamera scm = (SceneCamera)sceneCamera.getObject();
        rend.renderScene(sc, cam, this, scm);
        this.setVisible(true);
    }

    public RenderingDialog(BFrame parent, Renderer rend, Scene sc, Camera cam, ObjectInfo sceneCamera, double start, double end, int fps, int subimages, ImageSaver imgsaver) {
        super(parent, true);
        this.parent = parent;
        this.renderer = rend;
        this.theScene = sc;
        this.theCamera = cam;
        this.sceneCamera = sceneCamera;
        this.start = start;
        this.end = end;
        this.fps = fps;
        this.subimages = subimages;
        this.imgsaver = imgsaver;
        this.originalTime = this.theScene.getTime();
        this.totalFrames = (int)Math.ceil((end - start) * (double)fps);
        if (this.totalFrames <= 0) {
            this.totalFrames = 1;
        }
        if (subimages > 1) {
            this.imgaverager = new ImageAverager(this.theCamera.getSize().width, this.theCamera.getSize().height);
        }
        this.layoutDialog(parent, cam);
        this.startTime = System.currentTimeMillis();
        sc.setTime(start);
        this.theCamera.setCameraCoordinates(sceneCamera.getCoords().duplicate());
        SceneCamera scm = (SceneCamera)sceneCamera.getObject();
        cam.setScreenTransform(scm.getScreenTransform(this.w, this.h), this.w, this.h);
        rend.renderScene(sc, this.theCamera, this, scm);
        this.setVisible(true);
    }

    private void layoutDialog(BFrame parent, Camera cam) {
        Dimension dim = cam.getSize();
        this.w = dim.width;
        this.h = dim.height;
        this.setFont(parent.getFont());
        FormContainer content = new FormContainer(new double[]{1.0, 0.0, 0.0}, new double[]{0.0, 0.0, 1.0});
        this.setContent(content);
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, new Insets(2, 2, 2, 2), null));
        this.label1 = new BLabel(Translate.text("Rendering", "..."));
        content.add(this.label1, 0, 0);
        this.label2 = new BLabel(Translate.text("elapsedTime", "0:00"));
        content.add(this.label2, 0, 1);
        this.closeButton = Translate.button("cancel", this, "doCancel");
        content.add(this.closeButton, 2, 0);
        this.saveButton = Translate.button("save", this, "doSave");
        content.add(this.saveButton, 2, 1);
        this.filterButton = Translate.button("filter", this, "doFilter");
        content.add(this.filterButton, 1, 1);
        this.closeButton.setFocusable(false);
        this.saveButton.setVisible(false);
        this.filterButton.setVisible(false);
        this.canvas = new CustomWidget();
        this.canvas.setPreferredSize(new Dimension(this.w, this.h));
        this.canvas.addEventLink(RepaintEvent.class, (Object)this, "paintCanvas");
        BScrollPane sp = new BScrollPane(this.canvas);
        content.add(sp, 0, 2, 3, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.pack();
        UIUtilities.centerDialog(this, parent);
        UIUtilities.fitWindowToScreen(this);
        this.addEventLink(WindowClosingEvent.class, (Object)this, "doCancel");
    }

    private void doCancel() {
        this.done = true;
        this.renderer.cancelRendering(this.theScene);
        if (this.imgsaver != null) {
            this.theScene.setTime(this.originalTime);
            this.imgsaver.lastMovieImage();
        }
        this.dispose();
        if (this.hasModifiedFilters) {
            String[] values = new String[]{Translate.text("button.save"), Translate.text("button.dontSave")};
            int choice = new BStandardDialog("", Translate.text("saveModifiedFilters", this.sceneCamera.getName()), BStandardDialog.QUESTION).showOptionDialog(this.parent, values, values[0]);
            if (choice == 0) {
                ((SceneCamera)this.sceneCamera.getObject()).setImageFilters(this.cameraForFilters.getImageFilters());
            }
        }
    }

    private void doSave() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        ImageSaver saver = new ImageSaver(this.parent);
        if (saver.clickedOk()) {
            saver.saveImage(this.filteredImage);
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.toFront();
    }

    private void doFilter() {
        final CameraFilterDialog.FiltersPanel filtersPanel = new CameraFilterDialog.FiltersPanel(this.cameraForFilters, new Runnable(){

            public void run() {
            }
        });
        final BDialog dlg = new BDialog(this, Translate.text("Filters"), true);
        final ImageFilter[] originalFilters = this.cameraForFilters.getImageFilters();
        final boolean[] hasAppliedFilters = new boolean[1];
        RowContainer buttonPanel = new RowContainer();
        buttonPanel.add(Translate.button("apply", new Object(){

            void processEvent() {
                hasAppliedFilters[0] = true;
                RenderingDialog.this.cameraForFilters.setImageFilters(filtersPanel.getFilters().toArray(new ImageFilter[0]));
                RenderingDialog.this.applyFilters(false);
                RenderingDialog.this.verifyFilters(dlg);
            }
        }, "processEvent"));
        buttonPanel.add(Translate.button("ok", new Object(){

            void processEvent() {
                RenderingDialog.this.cameraForFilters.setImageFilters(filtersPanel.getFilters().toArray(new ImageFilter[0]));
                RenderingDialog.this.applyFilters(false);
                RenderingDialog.this.verifyFilters(dlg);
                RenderingDialog.this.hasModifiedFilters = true;
                dlg.dispose();
            }
        }, "processEvent"));
        buttonPanel.add(Translate.button("cancel", new Object(){

            void processEvent() {
                if (hasAppliedFilters[0]) {
                    RenderingDialog.this.cameraForFilters.setImageFilters(originalFilters);
                    RenderingDialog.this.applyFilters(false);
                }
                dlg.dispose();
            }
        }, "processEvent"));
        BorderContainer content = new BorderContainer();
        content.add(filtersPanel, BorderContainer.CENTER);
        content.add(buttonPanel, BorderContainer.SOUTH, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE));
        dlg.setContent(content);
        dlg.pack();
        dlg.setVisible(true);
    }

    private void paintCanvas(RepaintEvent ev) {
        if (this.previewImage != null) {
            ev.getGraphics().drawImage(this.previewImage, 0, 0, null);
        }
    }

    private void updateTimeLabel() {
        int sec = (int)((System.currentTimeMillis() - this.startTime) / 1000L);
        int hour = sec / 3600;
        int min = (sec -= 3600 * hour) / 60;
        sec -= 60 * min;
        if (hour == 0) {
            this.label2.setText(Translate.text("elapsedTime", min + ":" + (sec < 10 ? "0" : "") + sec));
        } else {
            this.label2.setText(Translate.text("elapsedTime", hour + ":" + (min < 10 ? "0" : "") + min + ":" + (sec < 10 ? "0" : "") + sec));
        }
    }

    private void verifyFilters(WindowWidget parent) {
        ImageFilter[] filters = this.cameraForFilters.getImageFilters();
        for (int i = 0; i < filters.length; ++i) {
            int component;
            for (int required = filters[i].getDesiredComponents(); required != 0; required -= component) {
                component = required - (required & required - 1);
                if (this.originalImage.hasFloatData(component)) continue;
                new BStandardDialog("", UIUtilities.breakString(Translate.text("missingComponentsForFilters")), BStandardDialog.WARNING).showMessageDialog(parent);
                return;
            }
        }
    }

    private void applyFilters(boolean updateLabel) {
        this.filteredImage = null;
        if (this.cameraForFilters.getImageFilters().length > 0) {
            this.filteredImage = this.originalImage.duplicate();
            if (updateLabel) {
                this.statusChanged(Translate.text("applyingFilters"));
            }
            this.cameraForFilters.applyImageFilters(this.filteredImage, this.theScene, this.sceneCamera.getCoords());
        } else {
            this.filteredImage = this.originalImage;
        }
        this.previewImage = this.filteredImage.getImage();
        this.canvas.repaint();
    }

    public void imageUpdated(Image image) {
        this.previewImage = image;
        this.canvas.repaint();
        this.updateTimeLabel();
    }

    public void statusChanged(String status) {
        if (this.imgsaver != null) {
            String current = Integer.toString(this.currentFrame + 1);
            String total = Integer.toString(this.totalFrames);
            if (this.subimages > 1) {
                this.label1.setText(Translate.text("renderSubimageLabel", new String[]{current, total, Integer.toString(this.currentSubimage + 1), status}));
            } else {
                this.label1.setText(Translate.text("renderFrameLabel", new String[]{current, total, status}));
            }
        } else {
            this.label1.setText(status + "...");
        }
        this.updateTimeLabel();
    }

    public void imageComplete(ComplexImage image) {
        this.cameraForFilters = ((SceneCamera)this.sceneCamera.getObject()).duplicate();
        this.originalImage = image;
        this.previewImage = image.getImage();
        this.canvas.repaint();
        this.applyFilters(true);
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    if (RenderingDialog.this.imgsaver != null) {
                        RenderingDialog.this.nextFrame();
                    }
                    if (RenderingDialog.this.currentFrame == RenderingDialog.this.totalFrames) {
                        RenderingDialog.this.done = true;
                        if (RenderingDialog.this.imgsaver != null) {
                            RenderingDialog.this.imgsaver.lastMovieImage();
                        }
                        RenderingDialog.this.label1.setText(Translate.text("doneRendering"));
                        RenderingDialog.this.closeButton.setText(Translate.text("button.close"));
                        RenderingDialog.this.saveButton.setVisible(RenderingDialog.this.imgsaver == null);
                        RenderingDialog.this.filterButton.setVisible(RenderingDialog.this.imgsaver == null);
                        ((WidgetContainer)RenderingDialog.this.getContent()).layoutChildren();
                    }
                    RenderingDialog.this.updateTimeLabel();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void renderingCanceled() {
        this.dispose();
    }

    private void nextFrame() {
        if (this.done) {
            return;
        }
        this.statusChanged(Translate.text("Saving"));
        if (this.imgaverager != null) {
            this.imgaverager.addImage(this.filteredImage);
            ++this.currentSubimage;
            if (this.currentSubimage == this.subimages) {
                this.imgsaver.saveImage(this.imgaverager.getAverageImage());
                this.imgaverager.clear();
                this.currentSubimage = 0;
                ++this.currentFrame;
                if (this.currentFrame == this.totalFrames) {
                    return;
                }
            }
        } else {
            this.imgsaver.saveImage(this.filteredImage);
            ++this.currentFrame;
        }
        this.theScene.setTime(this.start + (double)(this.currentFrame * this.subimages + this.currentSubimage) / (double)(this.fps * this.subimages));
        this.theCamera.setCameraCoordinates(this.sceneCamera.getCoords().duplicate());
        SceneCamera scm = (SceneCamera)this.sceneCamera.getObject();
        this.theCamera.setScreenTransform(scm.getScreenTransform(this.w, this.h), this.w, this.h);
        this.renderer.renderScene(this.theScene, this.theCamera, this, scm);
        this.statusChanged(Translate.text("Rendering"));
    }
}

