/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ApplicationPreferences;
import artofillusion.ArtOfIllusion;
import artofillusion.LayoutWindow;
import artofillusion.ModellingTool;
import artofillusion.Plugin;
import artofillusion.PluginRegistry;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.Translator;
import artofillusion.image.filter.ImageFilter;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.object.ObjectInfo;
import artofillusion.procedural.Module;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.ui.EditingWindow;
import buoy.widget.BFrame;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ModellingApp {
    public static final String MAJOR_VERSION = ArtOfIllusion.getMajorVersion();
    public static final String VERSION = ArtOfIllusion.getVersion();
    public static final double DIST_TO_SCREEN = 20.0;
    public static String currentDirectory;

    public static void main(String[] args) {
        System.out.println("ModellingApp is deprecated.  Use artofillusion.ArtOfIllusion.main() instead.");
        ArtOfIllusion.main(args);
    }

    public static String getVersion() {
        return ArtOfIllusion.getVersion();
    }

    public static String getMajorVersion() {
        return ArtOfIllusion.getMajorVersion();
    }

    public static ApplicationPreferences getPreferences() {
        return ArtOfIllusion.getPreferences();
    }

    public static Renderer[] getRenderers() {
        return PluginRegistry.getPlugins(Renderer.class).toArray(new Renderer[0]);
    }

    public static Plugin[] getPlugins() {
        return PluginRegistry.getPlugins(Plugin.class).toArray(new Plugin[0]);
    }

    public static Translator[] getTranslators() {
        return PluginRegistry.getPlugins(Translator.class).toArray(new Translator[0]);
    }

    public static ModellingTool[] getModellingTools() {
        return PluginRegistry.getPlugins(ModellingTool.class).toArray(new ModellingTool[0]);
    }

    public static Class[] getTextureTypes() {
        List<Texture> instances = PluginRegistry.getPlugins(Texture.class);
        Class[] classes = new Class[instances.size()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = instances.get(i).getClass();
        }
        return classes;
    }

    public static Class[] getMaterialTypes() {
        List<Material> instances = PluginRegistry.getPlugins(Material.class);
        Class[] classes = new Class[instances.size()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = instances.get(i).getClass();
        }
        return classes;
    }

    public static Class[] getTextureMappings() {
        List<TextureMapping> instances = PluginRegistry.getPlugins(TextureMapping.class);
        Class[] classes = new Class[instances.size()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = instances.get(i).getClass();
        }
        return classes;
    }

    public static Class[] getMaterialMappings() {
        List<MaterialMapping> instances = PluginRegistry.getPlugins(MaterialMapping.class);
        Class[] classes = new Class[instances.size()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = instances.get(i).getClass();
        }
        return classes;
    }

    public static Class[] getImageFilters() {
        List<ImageFilter> instances = PluginRegistry.getPlugins(ImageFilter.class);
        Class[] classes = new Class[instances.size()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = instances.get(i).getClass();
        }
        return classes;
    }

    public static Class[] getModules() {
        List<Module> instances = PluginRegistry.getPlugins(Module.class);
        Class[] classes = new Class[instances.size()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = instances.get(i).getClass();
        }
        return classes;
    }

    public static void registerRenderer(Renderer o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerTranslator(Translator o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerModellingTool(ModellingTool o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerTexture(Texture o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerMaterial(Material o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerTextureMapping(TextureMapping o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerMaterialMapping(MaterialMapping o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerPlugin(Plugin o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerImageFilter(ImageFilter o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void registerModule(Module o) {
        PluginRegistry.registerPlugin(o);
    }

    public static void newWindow() {
        ArtOfIllusion.newWindow();
    }

    public static void newWindow(Scene theScene) {
        ArtOfIllusion.newWindow(theScene);
    }

    public static void addWindow(EditingWindow win) {
        ArtOfIllusion.addWindow(win);
    }

    public static void closeWindow(EditingWindow win) {
        ArtOfIllusion.closeWindow(win);
    }

    public static EditingWindow[] getWindows() {
        return ArtOfIllusion.getWindows();
    }

    public static void quit() {
        ArtOfIllusion.quit();
    }

    public static Class getClass(String name) throws ClassNotFoundException {
        return ArtOfIllusion.getClass(name);
    }

    public static String loadFile(File f) throws IOException {
        return ArtOfIllusion.loadFile(f);
    }

    public static boolean saveScene(Scene sc, LayoutWindow fr) {
        return ArtOfIllusion.saveScene(sc, fr);
    }

    public static void openScene(BFrame fr) {
        ArtOfIllusion.openScene(fr);
    }

    public static void openScene(File f, BFrame fr) {
        ArtOfIllusion.openScene(f, fr);
    }

    public static void copyToClipboard(ObjectInfo[] obj, Scene scene) {
        ArtOfIllusion.copyToClipboard(obj, scene);
    }

    public static void pasteClipboard(LayoutWindow win) {
        ArtOfIllusion.pasteClipboard(win);
    }

    public static int getClipboardSize() {
        return ArtOfIllusion.getClipboardSize();
    }
}

