/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Scene;
import artofillusion.object.ExternalObject;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ObjectTreeElement;
import artofillusion.ui.Translate;
import artofillusion.ui.TreeList;
import artofillusion.ui.UIUtilities;
import buoy.event.SelectionChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BDialog;
import buoy.widget.BFileChooser;
import buoy.widget.BOutline;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextField;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ExternalObjectEditingWindow
extends BDialog {
    private EditingWindow parentWindow;
    private ExternalObject theObject;
    private ObjectInfo info;
    private Scene scene;
    private BTextField fileField;
    private TreeList itemTree;
    private BButton okButton;
    private BCheckBox includeChildrenBox;
    private String objectName;
    private int objectId;
    private Runnable onClose;

    public ExternalObjectEditingWindow(EditingWindow parent, ExternalObject obj, ObjectInfo info, Runnable onClose) {
        super(parent.getFrame(), info.getName(), true);
        this.parentWindow = parent;
        this.theObject = obj;
        this.info = info;
        this.onClose = onClose;
        this.objectName = obj.getExternalObjectName();
        this.objectId = obj.getExternalObjectId();
        FormContainer content = new FormContainer(new double[]{0.0, 1.0, 0.0, 0.0}, new double[]{0.0, 1.0, 0.0, 0.0});
        this.setContent(BOutline.createEmptyBorder(content, UIUtilities.getStandardDialogInsets()));
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(2, 2, 2, 2), null));
        LayoutInfo labelLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(2, 2, 2, 2), null);
        content.add(Translate.label("externalObject.sceneFile"), 0, 0, labelLayout);
        this.fileField = new BTextField(this.theObject.getExternalSceneFile().getAbsolutePath(), 30);
        content.add(this.fileField, 1, 0);
        content.add(Translate.button("browse", this, "doBrowseFile"), 2, 0);
        this.fileField.setEditable(false);
        this.itemTree = new TreeList(this.parentWindow);
        this.itemTree.setPreferredSize(new Dimension(130, 100));
        this.itemTree.setAllowMultiple(false);
        this.itemTree.addEventLink(SelectionChangedEvent.class, (Object)this, "selectionChanged");
        BScrollPane itemTreeScroller = new BScrollPane(this.itemTree);
        itemTreeScroller.setForceWidth(true);
        itemTreeScroller.setForceHeight(true);
        itemTreeScroller.getVerticalScrollBar().setUnitIncrement(10);
        content.add(itemTreeScroller, 0, 1, 3, 1);
        this.includeChildrenBox = new BCheckBox(Translate.text("externalObject.includeChildren"), obj.getIncludeChildren());
        content.add(this.includeChildrenBox, 0, 2, 3, 1);
        RowContainer buttons = new RowContainer();
        content.add(buttons, 0, 3, 3, 1, new LayoutInfo());
        this.okButton = Translate.button("ok", this, "doOk");
        buttons.add(this.okButton);
        buttons.add(Translate.button("cancel", this, "dispose"));
        this.loadExternalScene();
        this.buildObjectTree();
        this.selectionChanged();
        this.pack();
        UIUtilities.centerDialog(this, this.parentWindow.getFrame());
        this.setVisible(true);
    }

    private void doBrowseFile() {
        BFileChooser fc = new BFileChooser(BFileChooser.OPEN_FILE, Translate.text("externalObject.selectScene"));
        File f = this.theObject.getExternalSceneFile();
        if (f.isFile()) {
            fc.setSelectedFile(f);
        }
        if (fc.showDialog(this)) {
            this.fileField.setText(fc.getSelectedFile().getAbsolutePath());
            this.loadExternalScene();
            this.buildObjectTree();
            this.selectionChanged();
        }
    }

    private void loadExternalScene() {
        File f = new File(this.fileField.getText());
        this.scene = null;
        if (!f.isFile()) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("externalObject.sceneNotFound", this.theObject.getExternalSceneFile().getAbsolutePath())), BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.scene = new Scene(f, true);
        }
        catch (InvalidObjectException ex) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("errorLoadingWholeScene")), BStandardDialog.ERROR).showMessageDialog(this);
        }
        catch (IOException ex) {
            new BStandardDialog("", new String[]{Translate.text("errorLoadingFile"), ex.getMessage() == null ? "" : ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(this);
        }
        this.setCursor(Cursor.getDefaultCursor());
        if (this.scene == null) {
            return;
        }
    }

    private void buildObjectTree() {
        this.itemTree.removeAllElements();
        if (this.scene == null) {
            return;
        }
        this.itemTree.setUpdateEnabled(false);
        for (int i = 0; i < this.scene.getNumObjects(); ++i) {
            ObjectInfo info = this.scene.getObject(i);
            if (info.getParent() != null) continue;
            this.itemTree.addElement(new ObjectTreeElement(info, this.itemTree));
        }
        this.itemTree.setUpdateEnabled(true);
        ObjectInfo oldSelection = this.scene.getObjectById(this.objectId);
        if (oldSelection == null || !oldSelection.getName().equals(this.objectName)) {
            oldSelection = this.scene.getObject(this.objectName);
        }
        if (oldSelection != null) {
            this.itemTree.setSelected(oldSelection, true);
            this.itemTree.expandToShowObject(oldSelection);
        }
    }

    private void selectionChanged() {
        Object[] sel = this.itemTree.getSelectedObjects();
        if (sel.length == 0) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
            ObjectInfo selected = (ObjectInfo)sel[0];
            this.objectName = selected.getName();
            this.objectId = selected.getId();
        }
    }

    private void doOk() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.theObject.setExternalObjectName(this.objectName);
        this.theObject.setExternalObjectId(this.objectId);
        this.theObject.setExternalSceneFile(new File(this.fileField.getText()));
        this.theObject.setIncludeChildren(this.includeChildrenBox.getState());
        this.theObject.reloadObject();
        if (this.theObject.getLoadingError() != null) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("externalObject.loadingError", this.theObject.getLoadingError())), BStandardDialog.ERROR).showMessageDialog(this);
        }
        this.info.clearCachedMeshes();
        this.theObject.sceneChanged(this.info, this.parentWindow.getScene());
        this.dispose();
        if (this.onClose != null) {
            this.onClose.run();
        }
        this.parentWindow.updateImage();
        this.parentWindow.updateMenus();
    }
}

