/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.CSGDialog;
import artofillusion.Camera;
import artofillusion.MoveObjectTool;
import artofillusion.MoveViewTool;
import artofillusion.ObjectEditorWindow;
import artofillusion.Renderer;
import artofillusion.RenderingDialog;
import artofillusion.RotateObjectTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleObjectTool;
import artofillusion.Scene;
import artofillusion.SceneViewer;
import artofillusion.TransformDialog;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.CSGObject;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.object.TriangleMesh;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.WidgetEvent;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuItem;
import buoy.widget.BStandardDialog;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;

public class CSGEditorWindow
extends ObjectEditorWindow {
    private CSGObject oldObject;
    private CSGObject theObject;
    private BMenuItem undoItem;
    private BMenuItem redoItem;
    private BMenuItem[] objectMenuItem;
    private BMenuItem templateItem;
    private BMenuItem axesItem;
    private BMenuItem splitViewItem;
    private BCheckBoxMenuItem[] displayItem;
    private Scene theScene = new Scene();
    private Runnable onClose;

    public CSGEditorWindow(EditingWindow parent, String title, CSGObject obj, Runnable onClose) {
        super(parent, title, new ObjectInfo(obj, new CoordinateSystem(), ""));
        this.initialize();
        this.oldObject = obj;
        this.theObject = (CSGObject)obj.duplicate();
        this.onClose = onClose;
        this.theScene.addObject(obj.getObject1().getObject().duplicate(), obj.getObject1().getCoords().duplicate(), obj.getObject1().getName(), null);
        this.theScene.addObject(obj.getObject2().getObject().duplicate(), obj.getObject2().getCoords().duplicate(), obj.getObject2().getName(), null);
        FormContainer content = new FormContainer(new double[]{0.0, 1.0}, new double[]{1.0, 0.0, 0.0});
        this.setContent(content);
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.helpText = new BLabel();
        content.add(this.helpText, 0, 1, 2, 1);
        content.add(this.viewsContainer, 1, 0);
        RowContainer buttons = new RowContainer();
        buttons.add(Translate.button("ok", this, "doOk"));
        buttons.add(Translate.button("cancel", this, "doCancel"));
        content.add(buttons, 0, 2, 2, 1, new LayoutInfo());
        this.tools = new ToolPalette(1, 5);
        content.add(this.tools, 0, 0);
        this.defaultTool = new MoveObjectTool(this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new RotateObjectTool(this));
        this.tools.addTool(new ScaleObjectTool(this));
        MoveViewTool metaTool = new MoveViewTool(this);
        this.tools.addTool(metaTool);
        RotateViewTool altTool = new RotateViewTool(this);
        this.tools.addTool(altTool);
        this.tools.selectTool(this.defaultTool);
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].setMetaTool(metaTool);
            this.theView[i].setAltTool(altTool);
        }
        UIUtilities.applyDefaultFont(content);
        UIUtilities.applyDefaultBackground(content);
        this.createEditMenu();
        this.createObjectMenu();
        this.createViewMenu();
        this.recursivelyAddListeners(this);
        Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Dimension windowDim = new Dimension(screenBounds.width * 3 / 4, screenBounds.height * 3 / 4);
        this.setBounds(new Rectangle((screenBounds.width - windowDim.width) / 2, (screenBounds.height - windowDim.height) / 2, windowDim.width, windowDim.height));
        this.tools.requestFocus();
        this.updateMenus();
        this.setVisible(true);
    }

    protected ViewerCanvas createViewerCanvas(int index, RowContainer controls) {
        return new SceneViewer(this.theScene, controls, this);
    }

    void createEditMenu() {
        BMenu editMenu = Translate.menu("edit");
        this.menubar.add(editMenu);
        this.undoItem = Translate.menuItem("undo", this, "undoCommand");
        editMenu.add(this.undoItem);
        this.redoItem = Translate.menuItem("redo", this, "redoCommand");
        editMenu.add(this.redoItem);
        this.undoItem.setEnabled(false);
        editMenu.addSeparator();
        editMenu.add(Translate.menuItem("selectAll", this, "selectAllCommand"));
        editMenu.add(Translate.menuItem("properties", this, "propertiesCommand"));
    }

    void createObjectMenu() {
        BMenu objectMenu = Translate.menu("object");
        this.menubar.add(objectMenu);
        this.objectMenuItem = new BMenuItem[5];
        this.objectMenuItem[0] = Translate.menuItem("editObject", this, "editObjectCommand");
        objectMenu.add(this.objectMenuItem[0]);
        this.objectMenuItem[1] = Translate.menuItem("objectLayout", this, "objectLayoutCommand");
        objectMenu.add(this.objectMenuItem[1]);
        this.objectMenuItem[2] = Translate.menuItem("transformObject", this, "transformObjectCommand");
        objectMenu.add(this.objectMenuItem[2]);
        this.objectMenuItem[3] = Translate.menuItem("alignObjects", this, "alignObjectsCommand");
        objectMenu.add(this.objectMenuItem[3]);
        objectMenu.add(Translate.menuItem("centerObjects", this, "centerObjectsCommand"));
        this.objectMenuItem[4] = Translate.menuItem("convertToTriangle", this, "convertToTriangleCommand");
        objectMenu.add(this.objectMenuItem[4]);
    }

    protected void createViewMenu() {
        BMenu viewMenu = Translate.menu("view");
        this.menubar.add(viewMenu);
        BMenu displayMenu = Translate.menu("displayMode");
        viewMenu.add(displayMenu);
        this.displayItem = new BCheckBoxMenuItem[5];
        ViewerCanvas view = this.theView[this.currentView];
        this.displayItem[0] = Translate.checkboxMenuItem("wireframeDisplay", this, "displayModeChanged", view.getRenderMode() == 0);
        displayMenu.add(this.displayItem[0]);
        this.displayItem[1] = Translate.checkboxMenuItem("shadedDisplay", this, "displayModeChanged", view.getRenderMode() == 1);
        displayMenu.add(this.displayItem[1]);
        this.displayItem[2] = Translate.checkboxMenuItem("smoothDisplay", this, "displayModeChanged", view.getRenderMode() == 2);
        displayMenu.add(this.displayItem[2]);
        this.displayItem[3] = Translate.checkboxMenuItem("texturedDisplay", this, "displayModeChanged", view.getRenderMode() == 3);
        displayMenu.add(this.displayItem[3]);
        this.displayItem[4] = Translate.checkboxMenuItem("transparentDisplay", this, "displayModeChanged", view.getRenderMode() == 4);
        displayMenu.add(this.displayItem[4]);
        this.splitViewItem = Translate.menuItem(this.numViewsShown == 1 ? "fourViews" : "oneView", this, "toggleViewsCommand");
        viewMenu.add(this.splitViewItem);
        viewMenu.add(Translate.menuItem("grid", this, "setGridCommand"));
        this.axesItem = Translate.menuItem(view.getShowAxes() ? "hideCoordinateAxes" : "showCoordinateAxes", this, "showAxesCommand");
        viewMenu.add(this.axesItem);
        this.templateItem = Translate.menuItem("showTemplate", this, "showTemplateCommand");
        viewMenu.add(this.templateItem);
        viewMenu.add(Translate.menuItem("setTemplate", this, "setTemplateCommand"));
        if (ArtOfIllusion.getPreferences().getObjectPreviewRenderer() != null) {
            viewMenu.addSeparator();
            viewMenu.add(Translate.menuItem("renderPreview", this, "renderPreviewCommand"));
        }
    }

    public void updateMenus() {
        ViewerCanvas view = this.getView();
        int[] selected = this.theScene.getSelection();
        this.undoItem.setEnabled(this.undoStack.canUndo());
        this.redoItem.setEnabled(this.undoStack.canRedo());
        this.objectMenuItem[0].setEnabled(selected.length == 1);
        this.objectMenuItem[1].setEnabled(selected.length > 0);
        this.objectMenuItem[2].setEnabled(selected.length > 0);
        this.objectMenuItem[3].setEnabled(selected.length > 1);
        this.objectMenuItem[4].setEnabled(selected.length == 1);
        this.templateItem.setEnabled(view.getTemplateImage() != null);
        this.templateItem.setText(view.getTemplateShown() ? Translate.text("menu.hideTemplate") : Translate.text("menu.showTemplate"));
        this.splitViewItem.setText(this.numViewsShown == 1 ? Translate.text("menu.fourViews") : Translate.text("menu.oneView"));
        this.axesItem.setText(Translate.text(view.getShowAxes() ? "menu.hideCoordinateAxes" : "menu.showCoordinateAxes"));
        this.displayItem[0].setState(view.getRenderMode() == 0);
        this.displayItem[1].setState(view.getRenderMode() == 1);
        this.displayItem[2].setState(view.getRenderMode() == 2);
        this.displayItem[3].setState(view.getRenderMode() == 3);
    }

    public Scene getScene() {
        return this.theScene;
    }

    protected void doOk() {
        this.updateFromScene();
        this.oldObject.copyObject(this.theObject);
        this.theObject = null;
        this.oldObject = null;
        this.theScene = null;
        this.dispose();
        this.onClose.run();
        this.parentWindow.updateImage();
        this.parentWindow.updateMenus();
    }

    protected void doCancel() {
        this.theObject = null;
        this.oldObject = null;
        this.theScene = null;
        this.dispose();
    }

    private void displayModeChanged(WidgetEvent ev) {
        Widget source = ev.getWidget();
        for (int i = 0; i < this.displayItem.length; ++i) {
            this.displayItem[i].setState(source == this.displayItem[i]);
        }
        if (source == this.displayItem[0]) {
            this.theView[this.currentView].setRenderMode(0);
        } else if (source == this.displayItem[1]) {
            this.theView[this.currentView].setRenderMode(1);
        } else if (source == this.displayItem[2]) {
            this.theView[this.currentView].setRenderMode(2);
        } else if (source == this.displayItem[3]) {
            this.theView[this.currentView].setRenderMode(3);
        } else if (source == this.displayItem[4]) {
            this.theView[this.currentView].setRenderMode(4);
        }
        this.savePreferences();
    }

    private void updateFromScene() {
        this.theObject.setComponentObjects(this.theScene.getObject(0), this.theScene.getObject(1));
    }

    void selectAllCommand() {
        this.theScene.setSelection(new int[]{0, 1});
        this.updateImage();
        this.updateMenus();
    }

    void propertiesCommand() {
        this.updateFromScene();
        new CSGDialog(this, this.theObject);
    }

    void editObjectCommand() {
        int[] sel = this.theScene.getSelection();
        if (sel.length != 1) {
            return;
        }
        final Object3D obj = this.theScene.getObject(sel[0]).getObject();
        if (obj.isEditable()) {
            final UndoRecord undo = new UndoRecord(this, false, 0, new Object[]{obj, obj.duplicate()});
            obj.edit(this, this.theScene.getObject(sel[0]), new Runnable(){

                public void run() {
                    CSGEditorWindow.this.setUndoRecord(undo);
                    CSGEditorWindow.this.theScene.objectModified(obj);
                    CSGEditorWindow.this.updateImage();
                    CSGEditorWindow.this.updateMenus();
                }
            });
        }
    }

    void objectLayoutCommand() {
        int i;
        int[] sel = this.theScene.getSelection();
        Object3D[] obj = new Object3D[sel.length];
        CoordinateSystem[] coords = new CoordinateSystem[sel.length];
        if (sel.length == 0) {
            return;
        }
        UndoRecord undo = new UndoRecord(this, false);
        this.setUndoRecord(undo);
        for (i = 0; i < sel.length; ++i) {
            obj[i] = this.theScene.getObject(sel[i]).getObject();
            coords[i] = this.theScene.getObject(sel[i]).getCoords();
            undo.addCommand(0, new Object[]{obj[i], obj[i].duplicate()});
            undo.addCommand(1, new Object[]{coords[i], coords[i].duplicate()});
        }
        if (sel.length == 1) {
            Vec3 orig = coords[0].getOrigin();
            double[] angles = coords[0].getRotationAngles();
            Vec3 size = this.theScene.getObject(sel[0]).getBounds().getSize();
            TransformDialog dlg = new TransformDialog(this, Translate.text("objectLayoutTitle", this.theScene.getObject(sel[0]).getName()), new double[]{orig.x, orig.y, orig.z, angles[0], angles[1], angles[2], size.x, size.y, size.z}, false, false);
            double[] values = dlg.getValues();
            if (!Double.isNaN(values[0])) {
                orig.x = values[0];
            }
            if (!Double.isNaN(values[1])) {
                orig.y = values[1];
            }
            if (!Double.isNaN(values[2])) {
                orig.z = values[2];
            }
            if (!Double.isNaN(values[3])) {
                angles[0] = values[3];
            }
            if (!Double.isNaN(values[4])) {
                angles[1] = values[4];
            }
            if (!Double.isNaN(values[5])) {
                angles[2] = values[5];
            }
            if (!Double.isNaN(values[6])) {
                size.x = values[6];
            }
            if (!Double.isNaN(values[7])) {
                size.y = values[7];
            }
            if (!Double.isNaN(values[8])) {
                size.z = values[8];
            }
            coords[0].setOrigin(orig);
            coords[0].setOrientation(angles[0], angles[1], angles[2]);
            obj[0].setSize(size.x, size.y, size.z);
        } else {
            TransformDialog dlg = new TransformDialog(this, Translate.text("objectLayoutTitleMultiple"), false, false);
            double[] values = dlg.getValues();
            for (i = 0; i < sel.length; ++i) {
                Vec3 orig = coords[i].getOrigin();
                double[] angles = coords[i].getRotationAngles();
                Vec3 size = this.theScene.getObject(sel[i]).getBounds().getSize();
                if (!Double.isNaN(values[0])) {
                    orig.x = values[0];
                }
                if (!Double.isNaN(values[1])) {
                    orig.y = values[1];
                }
                if (!Double.isNaN(values[2])) {
                    orig.z = values[2];
                }
                if (!Double.isNaN(values[3])) {
                    angles[0] = values[3];
                }
                if (!Double.isNaN(values[4])) {
                    angles[1] = values[4];
                }
                if (!Double.isNaN(values[5])) {
                    angles[2] = values[5];
                }
                if (!Double.isNaN(values[6])) {
                    size.x = values[6];
                }
                if (!Double.isNaN(values[7])) {
                    size.y = values[7];
                }
                if (!Double.isNaN(values[8])) {
                    size.z = values[8];
                }
                coords[i].setOrigin(orig);
                coords[i].setOrientation(angles[0], angles[1], angles[2]);
                obj[i].setSize(size.x, size.y, size.z);
            }
        }
        this.theScene.objectModified(obj[0]);
        this.updateImage();
    }

    void transformObjectCommand() {
        int[] sel = this.theScene.getSelection();
        if (sel.length == 0) {
            return;
        }
        TransformDialog dlg = sel.length == 1 ? new TransformDialog(this, Translate.text("transformObjectTitle", this.theScene.getObject(sel[0]).getName()), new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, true, true) : new TransformDialog(this, Translate.text("transformObjectTitleMultiple"), new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, true, true);
        double[] values = dlg.getValues();
        UndoRecord undo = new UndoRecord(this, false);
        this.setUndoRecord(undo);
        for (int i = 0; i < sel.length; ++i) {
            Object3D obj = this.theScene.getObject(sel[i]).getObject();
            CoordinateSystem coords = this.theScene.getObject(sel[i]).getCoords();
            undo.addCommand(0, new Object[]{obj, obj.duplicate()});
            undo.addCommand(1, new Object[]{coords, coords.duplicate()});
            Vec3 orig = coords.getOrigin();
            Vec3 size = obj.getBounds().getSize();
            if (!Double.isNaN(values[0])) {
                orig.x += values[0];
            }
            if (!Double.isNaN(values[1])) {
                orig.y += values[1];
            }
            if (!Double.isNaN(values[2])) {
                orig.z += values[2];
            }
            Mat4 m = Mat4.identity();
            if (!Double.isNaN(values[3])) {
                m = m.times(Mat4.xrotation(values[3] * Math.PI / 180.0));
            }
            if (!Double.isNaN(values[4])) {
                m = m.times(Mat4.yrotation(values[4] * Math.PI / 180.0));
            }
            if (!Double.isNaN(values[5])) {
                m = m.times(Mat4.zrotation(values[5] * Math.PI / 180.0));
            }
            if (!Double.isNaN(values[6])) {
                size.x *= values[6];
            }
            if (!Double.isNaN(values[7])) {
                size.y *= values[7];
            }
            if (!Double.isNaN(values[8])) {
                size.z *= values[8];
            }
            coords.setOrigin(orig);
            coords.transformAxes(m);
            obj.setSize(size.x, size.y, size.z);
        }
        this.updateImage();
    }

    void alignObjectsCommand() {
        Vec3 orig;
        Vec3 center;
        BoundingBox bounds;
        CoordinateSystem coords;
        Object3D obj;
        int i;
        int[] sel = this.theScene.getSelection();
        RowContainer px = new RowContainer();
        RowContainer py = new RowContainer();
        RowContainer pz = new RowContainer();
        if (sel.length == 0) {
            return;
        }
        BComboBox xchoice = new BComboBox(new String[]{Translate.text("doNotAlign"), Translate.text("Right"), Translate.text("Center"), Translate.text("Left"), Translate.text("Origin")});
        px.add(xchoice);
        px.add(Translate.label("alignTo"));
        ValueField vfx = new ValueField(Double.NaN, 0, 5);
        px.add(vfx);
        BComboBox ychoice = new BComboBox(new String[]{Translate.text("doNotAlign"), Translate.text("Top"), Translate.text("Center"), Translate.text("Bottom"), Translate.text("Origin")});
        py.add(ychoice);
        py.add(Translate.label("alignTo"));
        ValueField vfy = new ValueField(Double.NaN, 0, 5);
        py.add(vfy);
        BComboBox zchoice = new BComboBox(new String[]{Translate.text("doNotAlign"), Translate.text("Front"), Translate.text("Center"), Translate.text("Back"), Translate.text("Origin")});
        pz.add(zchoice);
        pz.add(Translate.label("alignTo"));
        ValueField vfz = new ValueField(Double.NaN, 0, 5);
        pz.add(vfz);
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("alignObjectsTitle"), new Widget[]{px, py, pz}, new String[]{"X", "Y", "Z"});
        if (!dlg.clickedOk()) {
            return;
        }
        UndoRecord undo = new UndoRecord(this, false);
        this.setUndoRecord(undo);
        Vec3 alignTo = new Vec3();
        for (i = 0; i < sel.length; ++i) {
            obj = this.theScene.getObject(sel[i]).getObject();
            coords = this.theScene.getObject(sel[i]).getCoords();
            bounds = obj.getBounds();
            bounds = bounds.transformAndOutset(coords.fromLocal());
            center = bounds.getCenter();
            orig = coords.getOrigin();
            if (!Double.isNaN(vfx.getValue())) {
                alignTo.x += vfx.getValue();
            } else if (xchoice.getSelectedIndex() == 1) {
                alignTo.x += bounds.maxx;
            } else if (xchoice.getSelectedIndex() == 2) {
                alignTo.x += center.x;
            } else if (xchoice.getSelectedIndex() == 3) {
                alignTo.x += bounds.minx;
            } else if (xchoice.getSelectedIndex() == 4) {
                alignTo.x += orig.x;
            }
            if (!Double.isNaN(vfy.getValue())) {
                alignTo.y += vfy.getValue();
            } else if (ychoice.getSelectedIndex() == 1) {
                alignTo.y += bounds.maxy;
            } else if (ychoice.getSelectedIndex() == 2) {
                alignTo.y += center.y;
            } else if (ychoice.getSelectedIndex() == 3) {
                alignTo.y += bounds.miny;
            } else if (ychoice.getSelectedIndex() == 4) {
                alignTo.y += orig.y;
            }
            if (!Double.isNaN(vfz.getValue())) {
                alignTo.z += vfz.getValue();
                continue;
            }
            if (zchoice.getSelectedIndex() == 1) {
                alignTo.z += bounds.maxz;
                continue;
            }
            if (zchoice.getSelectedIndex() == 2) {
                alignTo.z += center.z;
                continue;
            }
            if (zchoice.getSelectedIndex() == 3) {
                alignTo.z += bounds.minz;
                continue;
            }
            if (zchoice.getSelectedIndex() != 4) continue;
            alignTo.z += orig.z;
        }
        alignTo.scale(1.0 / (double)sel.length);
        for (i = 0; i < sel.length; ++i) {
            obj = this.theScene.getObject(sel[i]).getObject();
            coords = this.theScene.getObject(sel[i]).getCoords();
            bounds = obj.getBounds();
            bounds = bounds.transformAndOutset(coords.fromLocal());
            center = bounds.getCenter();
            orig = coords.getOrigin();
            undo.addCommand(1, new Object[]{coords, coords.duplicate()});
            if (xchoice.getSelectedIndex() == 1) {
                orig.x += alignTo.x - bounds.maxx;
            } else if (xchoice.getSelectedIndex() == 2) {
                orig.x += alignTo.x - center.x;
            } else if (xchoice.getSelectedIndex() == 3) {
                orig.x += alignTo.x - bounds.minx;
            } else if (xchoice.getSelectedIndex() == 4) {
                orig.x += alignTo.x - orig.x;
            }
            if (ychoice.getSelectedIndex() == 1) {
                orig.y += alignTo.y - bounds.maxy;
            } else if (ychoice.getSelectedIndex() == 2) {
                orig.y += alignTo.y - center.y;
            } else if (ychoice.getSelectedIndex() == 3) {
                orig.y += alignTo.y - bounds.miny;
            } else if (ychoice.getSelectedIndex() == 4) {
                orig.y += alignTo.y - orig.y;
            }
            if (zchoice.getSelectedIndex() == 1) {
                orig.z += alignTo.z - bounds.maxz;
            } else if (zchoice.getSelectedIndex() == 2) {
                orig.z += alignTo.z - center.z;
            } else if (zchoice.getSelectedIndex() == 3) {
                orig.z += alignTo.z - bounds.minz;
            } else if (zchoice.getSelectedIndex() == 4) {
                orig.z += alignTo.z - orig.z;
            }
            coords.setOrigin(orig);
        }
        this.updateImage();
    }

    void centerObjectsCommand() {
        BoundingBox bounds = null;
        for (int i = 0; i < this.theScene.getNumObjects(); ++i) {
            ObjectInfo info = this.theScene.getObject(i);
            BoundingBox b = info.getBounds().transformAndOutset(info.getCoords().fromLocal());
            bounds = bounds == null ? b : bounds.merge(b);
        }
        Vec3 center = bounds.getCenter();
        UndoRecord undo = new UndoRecord(this, false);
        this.setUndoRecord(undo);
        for (int i = 0; i < this.theScene.getNumObjects(); ++i) {
            ObjectInfo info = this.theScene.getObject(i);
            undo.addCommand(1, new Object[]{info.getCoords(), info.getCoords().duplicate()});
            info.getCoords().setOrigin(info.getCoords().getOrigin().minus(center));
        }
        this.updateImage();
    }

    void convertToTriangleCommand() {
        TriangleMesh mesh;
        int[] sel = this.theScene.getSelection();
        if (sel.length != 1) {
            return;
        }
        ObjectInfo info = this.theScene.getObject(sel[0]);
        Object3D obj = info.getObject();
        if (obj.canConvertToTriangleMesh() == 0) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 2, new Object[]{info, info.duplicate()}));
        if (obj.canConvertToTriangleMesh() == 1) {
            mesh = obj.convertToTriangleMesh(0.0);
        } else {
            ValueField errorField = new ValueField(0.1, 3);
            ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("selectToleranceForMesh"), new Widget[]{errorField}, new String[]{Translate.text("maxError")});
            if (!dlg.clickedOk()) {
                return;
            }
            mesh = obj.convertToTriangleMesh(errorField.getValue());
        }
        if (mesh == null) {
            new BStandardDialog("", Translate.text("cannotTriangulate"), BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        ((Object3D)mesh).setTexture(obj.getTexture(), obj.getTextureMapping());
        mesh.setMaterial(obj.getMaterial(), obj.getMaterialMapping());
        this.theScene.getObject(sel[0]).setObject(mesh);
        this.updateImage();
        this.updateMenus();
    }

    public void renderPreviewCommand() {
        Scene sc = new Scene();
        Camera theCamera = this.getView().getCamera();
        Renderer rend = ArtOfIllusion.getPreferences().getObjectPreviewRenderer();
        if (rend == null) {
            return;
        }
        this.updateFromScene();
        sc.addObject(new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), theCamera.getCameraCoordinates(), "", null);
        sc.addObject(this.theObject, new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy()), "", null);
        this.getView().adjustCamera(true);
        rend.configurePreview();
        ObjectInfo cameraInfo = new ObjectInfo(new SceneCamera(), theCamera.getCameraCoordinates(), "");
        new RenderingDialog(this, rend, sc, theCamera, cameraInfo);
    }
}

