/*
    EasyImageSizer

    Program to resize and rename some image files at the same time.

    Copyright (C) 2010  FalseCAM

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "imagepluginloader.h"
#include <QDebug>

ImagePluginLoader* ImagePluginLoader::instance = 0;

ImagePluginLoader& ImagePluginLoader::getInstance()
{
   if ( !instance )
      instance = new ImagePluginLoader();
   return *instance;
}

void ImagePluginLoader::destroy()
{
   if ( instance )
      delete instance;
   instance = 0;
}

void ImagePluginLoader::addImagePlugin(ImagePlugin *plugin){
    if(plugin){
        qDebug("%s plugin loaded", qPrintable(plugin->getName()));
        list.append(plugin);
    }
}

void ImagePluginLoader::clearActivated(){
    activatedList.clear();
}

void ImagePluginLoader::activate(QString name){
    foreach(ImagePlugin * plugin, list){
        if(!activatedList.contains(plugin)){
            if(QString(plugin->getName()+ " " +plugin->getVersion()) == name){
                activatedList.append(plugin);
                emit(pluginStateChanged());
            }
        }
    }
}

void ImagePluginLoader::deactivate(QString name){
    foreach(ImagePlugin * plugin, activatedList){
        if(QString(plugin->getName()+ " " +plugin->getVersion()) == name){
            activatedList.removeOne(plugin);
            emit(pluginStateChanged());
        }
    }
}

QList<ImagePlugin *> ImagePluginLoader::getImagePlugins(){
    return list;
}

QList<ImagePlugin *> ImagePluginLoader::getActivatedImagePlugins(){
    return activatedList;
}
