/*
    EasyImageSizer

    Program to resize and rename some image files at the same time.

    Copyright (C) 2010  FalseCAM

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef IMAGEPLUGIN_H
#define IMAGEPLUGIN_H

#include <QtGui>
#include <QWidget>
#include <QString>
#include <QImage>

class ImagePlugin: virtual public QWidget
{
public:
     //ImagePlugin(QWidget *parent) :
     //        QWidget(parent){}
     virtual ~ImagePlugin() {}
     virtual QString getName() = 0;
     virtual QString getTitle() = 0;
     virtual QString getVersion() = 0;
     virtual QString getAuthor() = 0;
     virtual QString getDescription() = 0;
     virtual void convert(QImage &image, QString &fileName, int index, QString origImage) = 0;
};

Q_DECLARE_INTERFACE(ImagePlugin,
                     "easyimagesizer.ImagePlugin/0.1");

#endif // IMAGEPLUGIN_H
