#ifndef CONVERT_H
#define CONVERT_H

#include <QThread>
#include <QStringList>
#include <QImage>

class Convert : public QThread
{
    Q_OBJECT
public:
    explicit Convert();

signals:
    void message(QString, int);
    void process(int);
    void taskProcess(int);
protected:
    void run();
private:
    QStringList imagesList;
    bool saveTo;
    QString saveToDir;
    bool copyImage;
    bool changeQuality;
    int quality;
    QString imageSaveFormat;

    // bool to check if converting is stopping
    bool stop;

    void save(QString imageFile, int index);
    void convertImage(QImage &image, QString &fileName, int index, QString origImage);
    void copyExifData(QString srcFile, QString destFile);

public:
    void setImagesList(QStringList list){ imagesList = list; }
    void setSaveTo(bool state){ saveTo = state; }
    void setSaveToDir(QString dir){ saveToDir = dir; }
    void setCopyImage(bool state){ copyImage = state; }
    void setChangeQuality(bool state){ changeQuality = state; }
    void setQuality(int quality_){ quality = quality_; }
    void setImageSaveFormat(QString format){ imageSaveFormat = format; }
    void stopConvert(){ stop = true; }
public slots:

};

#endif // CONVERT_H
