.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbAllocGeomOverlayRows 3Xkb "Release 6.1" "X Version 11" "XKBLIB FUNCTION"
.SH NAME
XkbAllocGeomOverlayRows \- Allocate rows in a overlay
.SH SYNOPSIS
.B Status XkbAllocGeomOverlayRows
(
.I overlay,
.I num_needed
)
.br
      XkbSectionPtr \fIoverlay\fP\^;
.br
      int \fInum_needed\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- overlay
section for which rows should be allocated
.TP
.I \- num_needed
number of new rows required
.SH DESCRIPTION
.LP
Xkb provides a number of functions to allocate and free subcomponents of a 
keyboard geometry. Use these functions to create or modify keyboard geometries. 
Note that these functions merely allocate space for the new element(s), and it 
is up to you to fill in the values explicitly in your code. These allocation 
functions increase 
.I sz_* 
but never touch 
.I num_* 
(unless there is an allocation failure, in which case they reset both 
.I sz_* 
and 
.I num_* 
to zero). These functions return Success if they succeed, BadAlloc if they are 
not able to allocate space, or BadValue if a parameter is not as expected.

.I XkbAllocGeomOverlayRows 
allocates 
.I num_needed 
rows and adds them to the 
.I overlay. 
No initialization of the rows is done.

To free rows in an overlay, use 
.I XkbFreeGeomOverlayRows.
.SH DIAGNOSTICS
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadValue
An argument is out of range
.SH "SEE ALSO"
.BR XkbFreeGeomOverlayRows (__libmansuffix__)
