#!/bin/sh
# rc.M		
# This file is executed by init(8) when the system is being initialized 
# for one of the "multi user" run levels (i.e. levels 2 through 5).
#
# Origin: this script is a mix of rc.S, rc.M and rc.inet2 from Slackware 10.0
#
# GNU GPL (c) Eko M. Budi, 2004
#         (c) Vector Linux, 2004
#

# load functions
. /etc/rc.d/functions-display

PATH="/bin:/sbin:/usr/bin:/usr/sbin:$PATH"

#TIMED0=`hwclock --show`

# Tell the viewers what's going to happen.
echocl "rc.M ==> Going multiuser..." yellow

## Turn ON system logger first
if [ -x /etc/rc.d/rc.syslog ]; then
  echonl "Starting system logger ..."
  /etc/rc.d/rc.syslog start > /dev/null 2>&1
  evaluate_retvall
fi

#TIMED1=`hwclock --show`

## Hardware initialisation
echocl "Initializing hardware" cyan
for RC in modules pnp pcmcia serial parallel alsa; do
   if [ -x /etc/rc.d/rc.$RC ]; then
      echonl "Setting up $RC ..."
      /etc/rc.d/rc.$RC start > /dev/null 2>&1
      evaluate_retvall
   fi
done

# Start hotplug in the background
if [ -x /etc/rc.d/rc.hotplug ]; then
      /etc/rc.d/rc.hotplug start > /dev/null 2>&1 &
      PID2=$!
fi

for RC in apm wireless; do
   if [ -x /etc/rc.d/rc.$RC ]; then
      echonl "Setting up $RC ..."
      /etc/rc.d/rc.$RC start > /dev/null 2>&1
      evaluate_retvall
   fi
done

## Setup basic networking
## Note for slackers: this replaces rc.inet1
## On Vector rc.inet? = individual network device
echocl "Initializing network" cyan

## Start Paranoid firewall 
if [ -x /etc/rc.d/rc.paranoid ]; then
  echonl "Closing up the holes ..."
  /etc/rc.d/rc.paranoid start > /dev/null 2>&1
  evaluate_retvall
fi

#TIMED2=`hwclock --show`

## Set hostname & name server
if grep -qe " *(hostname|dns)=" /proc/cmdline; then
  if [ -x /etc/rc.d/rc.boot-name ]; then
    echonl "Setting name from boot parameters ..."
    /etc/rc.d/rc.boot-name start > /dev/null 2>&1
    evaluate_retvall
  fi
fi

## Local host is always ON for multiuser mode
## So I hardcoded it here
echonl "Setting up localhost ..."
ifconfig lo 127.0.0.1 netmask 255.0.0.0 && \
  route add -net 127.0.0.0 netmask 255.0.0.0 lo > /dev/null 2>&1
evaluate_retvall

## set other networks
for RC in 1 2 3 4 5 6 7 8; do
  ## Start network using boot parameter or the default inet script
  ## Boot parameter is useful for UML, e.g. you may boot linux with
  ## linux inet1=eth0,dhcp
  ## linux inet1=eth0,{IP},{NETMASK},{GATEWAY}
  if grep -q " inet$RC=" /proc/cmdline; then
    echonl "Setting up inet$RC from boot parameters ..."
    /etc/rc.d/rc.boot-inet start inet$RC > /dev/null 2>&1
    evaluate_retvall
  elif [ -x /etc/rc.d/rc.inet$RC ]; then
    echonl "Setting up inet$RC ..."
    /etc/rc.d/rc.inet$RC start > /dev/null 2>&1
    evaluate_retvall
  fi
done

## routing, gateway and firewall
## rc.route = custom routing 
## rc.firewall = custom firewall
## ip_forward = enable forwarding, if not in the firewall
for RC in route firewall; do
   if [ -x /etc/rc.d/rc.$RC ]; then
      echonl "Setting up $RC ..."
      /etc/rc.d/rc.$RC start > /dev/null 2>&1
      evaluate_retvall
   fi
done

## at this point, we are ready to talk to The World...
## Here comes the Network file system
## Note for slackers: this is taken from rc.inet2

#TIMED3=`hwclock --show`

NFSTAB=`grep -E "^[^#].*[[:space:]].*[[:space:]](nfs|smbfs|ncpfs)[[:space:]]" /etc/fstab`
if [ "$NFSTAB" ]; then
  echocl "Mounting network file system ..." cyan
  if echo $NFSTAB | grep -qw nfs; then
    # Start the RPC portmapper if we find NFS volumes defined in /etc/fstab.
    if ! /usr/sbin/rpcinfo -p 1> /dev/null 2> /dev/null ; then
      if [ -x /sbin/rpc.portmap ]; then
        echonl "Starting RPC portmapper ..."
        /sbin/rpc.portmap > /dev/null 2&>1
	evaluate_retvall
      fi
    fi
    echonl "Mounting remote (NFS) file systems ..."
    /sbin/mount -a -t nfs  > /dev/null 2&>1
    evaluate_retvall
  fi

  if echo $NFSTAB | grep -qE "[[:space:]](smbfs|ncpfs)[[:space:]]"; then
    echonl "Mounting remote (SMB/NCP) file systems ..."
    /sbin/mount -a -t smbfs,ncpfs > /dev/null 2&>1
    evaluate_retvall
  fi

  ## If the new mounted FS is /tmp or /var, reset the file system again
  mount | while read LINE; do
     fsystem=`echo $LINE | cut -f5 -d ' '`
     case $fsystem in nfs|smbfs|ncpfs)
       mpoint=`echo $LINE | cut -f3 -d ' '`
       case $mpoint in
         /tmp|/tmp/*) 
	    rm -f /tmp/.X*lock /tmp/core /tmp/menu* /tmp/reply* /tmp/vasm.log
	    [ -r /tmp/hunt -o -r /tmp/hunt.stats ] && rm -f /tmp/hunt*
	    mkdir -p /tmp/.ICE-unix /tmp/.X11-unix
	    chmod 1777 /tmp /tmp/.ICE-unix /tmp/.X11-unix
	    ;;
	 /var|/var/*)
	    rm -f /var/run/utmp /var/run/*pid /var/run/lpd* /var/run/ppp* /var/run/usb/* \
    		/var/lock/* /var/lock/usb/* /var/spool/uucp/LCK..*
	    touch /var/run/utmp
	    chown root.utmp /var/run/utmp
	    chmod 664 /var/run/utmp
	    /etc/rc.d/rc.syslog restart
	    ;;
	 /usr|/usr/*|/opt|/opt/*)
	    ## Updating libraries
	    ldconfig
           ;;	 
       esac
     esac
  done 
fi

#TIMED4=`hwclock --show`

# Set console and X fonts
# setfont &> /dev/null
if [ -x /usr/X11R6/bin/fc-cache ]; then
    echonl "Caching fonts ..."
    /usr/X11R6/bin/fc-cache &> /dev/null
    evaluate_retvall
fi

#TIMED5=`hwclock --show`

# wait hotplug to finish
if [ "$PID2" ]; then
    echonl "Starting hotplug ....."
    wait $PID2 >> $INITLOG 2>&1
    evaluate_retval
fi

#TIMED6=`hwclock --show`

## That's all
## Other configurable services will be started by sysvinit/vlinit

#echo "rc.M TIMED0  = $TIMED1" >> /etc/rc.d/init.log
#echo "rc.M TIMED1  = $TIMED1" >> /etc/rc.d/init.log
#echo "rc.M TIMED2  = $TIMED2" >> /etc/rc.d/init.log
#echo "rc.M TIMED3  = $TIMED3" >> /etc/rc.d/init.log
#echo "rc.M TIMED4  = $TIMED4" >> /etc/rc.d/init.log
#echo "rc.M TIMED5  = $TIMED5" >> /etc/rc.d/init.log
#echo "rc.M TIMED6  = $TIMED6" >> /etc/rc.d/init.log

