#!/bin/sh

if [ "$UID" = 0 ]; then
   echoc "You are working as root" red
   export CFLAGS="-O2 -march=i586 -mcpu=i686"
   export CXXFLAGS="-O2 -march=i586 -mcpu=i686"
   export PATH="$PATH:/usr/local/sbin:/usr/sbin:/sbin"
   if [ -z "$USER" ] || [ "$USER" != "root" ]; then
      UHOME=`egrep "^$USER:" /etc/passwd | cut -f6 -d:`
      if [ -f $UHOME/.Xauthority ]; then
	 # echo "Enabling X-Window $UHOME/.Xauthority"
	 cp $UHOME/.Xauthority /root
      fi
   fi
   echoc "Frequently used programs:" cyan
   echo "Configuration  : vasm"
   echo "Package manager: vlapt, slapt-get"
else
   echoc "You are working as $USER" green
   echoc "Frequently used programs:" cyan
   echo "Configuration  : vasm"
fi

which mc &>/dev/null && echo "File manager   : mc (press F2 for usefull menu)"
which mc &>/dev/null && echo "Editor         : mcedit"
which mc &>/dev/null && echo "Sound mixer    : alsamixer"

if [ -z "`skill -n X`" ]; then
which startx &>/dev/null        && echo "Default X      : startx"
which starticewm &>/dev/null    && echo "IceWM          : starticewm, starticewm-desk, starticewm-sound"
which startfluxbox &>/dev/null  && echo "Fluxbox        : startfluxbox, startfluxbox-desk"
which startxfce4 &>/dev/null    && echo "XFCE4          : startxfce4"
which startkde &>/dev/null      && echo "KDE            : xinit startkde"
fi

