#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>

#include "global.h"
#include "color.h"	
#include "util.h"	
#include "mountlist.h"
#include "panel.h"	
#include "main.h"	

#include "cmd.h"
#include "tty.h"

extern int show_mini_info;
extern struct mount_entry *mount_list;
extern void listbox_select_by_number (WListbox *l, int n);
extern int _do_panel_cd (WPanel *panel, char *new_dir, enum cd_enum cd);

#ifdef __BEOS__
struct mount_entry *read_filesystem_list (int need_fs_type, int all_fs);

struct mount_entry *read_filesystem_list (int need_fs_type, int all_fs)
{
	int					i, fd;
	char				*tp, dev[_POSIX_NAME_MAX], dir[_POSIX_PATH_MAX];

	static struct mount_entry	*me = NULL;

	if (me)
	{
		if (me->me_devname) free(me->me_devname);
		if (me->me_mountdir) free(me->me_mountdir);
		if (me->me_type) free(me->me_type);
		return (NULL);
	}
	else
		me = (struct mount_entry *)malloc(sizeof(struct mount_entry));

	
	me->me_devname = strdup("//");
	me->me_mountdir = strdup("//");
	me->me_type = strdup("unknown");

	return (me);
}
#endif /*__BEOS__*/

static inline int listbox_fwd (WListbox *l)
{
    if (l->current != l->list->prev)
    {
        listbox_select_by_number (l, l->pos+1);
        return 1;
    }
    return 0;
}


static int mnt_callback (Dlg_head * h, int Par, int Msg)
{
    switch (Msg)
    {
        case DLG_DRAW:
            attrset (COLOR_NORMAL);
            dlg_erase (h);
            draw_box (h, 0, 0, h->lines, h->cols);
            attrset (COLOR_HOT_NORMAL);
            break;
    }
    return 0;
}


static char *show_mnt (Hist *mntpoints,  WPanel *panel)
{
    int widget_x, widget_y;
    Hist *hi, *z;
    int maxlen = 5, i, count = 0;
    int x, y, w, h;
    char *q, *r = 0;
    Dlg_head *query_dlg;
    WListbox *query_list;

    z = mntpoints;

    widget_x = panel->widget.x ;
    widget_y = panel->widget.y ;

    if (!z)
        return 0;

    while (z->prev)           /* goto first */
        z = z->prev;
    hi = z;
    while (hi)
    {
        if ((i = strlen (hi->text)) > maxlen)
            maxlen = i;
        count++;
        hi = hi->next;
    }

    y = widget_y;
    h = count + 2;
    if (h <= y || y > LINES - 6)
    {
        h = min(h, y - 1);
        y -= h;
    }
    else
    {
        y++;
        h = min(h, LINES - y);
    }

    x = widget_x;
    if ((w = maxlen + 4) + x > COLS)
    {
        w = min(w,COLS);
        x = COLS - w;
    }

    x = widget_x + (panel->widget.cols - w)/2;
    y = widget_y + (panel->widget.lines - h)/2;


    query_dlg = create_dlg (y, x, h, w, dialog_colors, mnt_callback,
    "", "Mountpoints", DLG_NONE);
    query_list = listbox_new (1, 1, w - 2, h - 2, listbox_finish, 0, NULL);
    add_widget (query_dlg, query_list);
    hi = z;
    if (y < widget_y)
    {
        while (hi->next)
        {
            hi = hi->next;
        }
        while (hi)            /* traverse backwards */
        {
            listbox_add_item (query_list, 0, 0, hi->text, NULL);
            hi = hi->prev;
        }
        while (listbox_fwd (query_list));
    }
    else
    {
        while (hi)            /* traverse */
        {
            listbox_add_item (query_list, 0, 0, hi->text, NULL);
            hi = hi->next;
        }
    }
    run_dlg (query_dlg);
    q = NULL;
    if (query_dlg->ret_value != B_CANCEL)
    {
        listbox_get_current (query_list, &q, NULL);
        if (q)
            r = strdup (q);
    }
    destroy_dlg (query_dlg);
    return r;
}


static int select_mountpoint( WPanel *panel )
{
    char *s;
    int lockm = 0;
    struct mount_entry *temp = NULL;
    Hist *mountpoints = NULL; /* directory mountpoints */

    temp = read_filesystem_list (0,0);

    while (temp)
    {

        if (!mountpoints)
        {
            s=temp->me_mountdir;
            mountpoints = malloc (sizeof (Hist)+1);
            memset (mountpoints, 0, sizeof (Hist));
            mountpoints->text = strdup (s);
            lockm = 1;
        }

        if (mountpoints->next)
        {
            if (mountpoints->next->text)
            {
                free (mountpoints->next->text);
                mountpoints->next->text = 0;
            }
        }
        else
        {
            mountpoints->next = malloc (sizeof (Hist)+1);
            memset (mountpoints->next, 0, sizeof (Hist));
            mountpoints->next->prev = mountpoints;
        }

        if (lockm != 1)
        {
            mountpoints = mountpoints->next;
            s=temp->me_mountdir;
            mountpoints->text = strdup (s);
        }
        lockm = 0;
        temp = temp->me_next;
    }

    free (temp);

    if (mountpoints)
    {
        if (mountpoints->prev || mountpoints->next)
        {
            s = show_mnt (mountpoints, panel);
            if (s)
            {
                int r;
                r = _do_panel_cd (panel, s, cd_exact);
                free (s);
            }
        }
    }
    free (mountpoints);
    return 1;
}


void select_mnt_left ( void )
{
    switch_to_listing ( 0 );
    select_mountpoint ( left_panel );
}


void select_mnt_right ( void )
{
    switch_to_listing ( 1 );
    select_mountpoint ( right_panel );
}
