#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <dirent.h>
#include <signal.h>
#include <unistd.h>
#include <gtk/gtk.h>

#include "win.h"
#include "winreload.h"
#include "config.h"


static gint WinWMReloadIceWM(win_struct *win);
gint WinWMReload(win_struct *win);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Returns the process ID of the specified name of the process or
 *	0 if no match is made.
 */
static gint WinWMReloadGetPIDFromName(const gchar *name)
{
	gint bytes_read, pid = 0;
	const gchar *ent_name, *proc_name;
	gchar	full_path[PATH_MAX + NAME_MAX],
		link_val[PATH_MAX + NAME_MAX];
	const struct dirent *ent;
	DIR *dir = opendir(
#if defined(__linux__) || defined(__FreeBSD__)
	    "/proc"
#else
#warning WinWMReloadGetPIDFromName(): Platform not supported, assuming processes directory is "/proc"
	    "/proc"
#endif
	);
	if(dir == NULL)
	    return(pid);

	for(ent = readdir(dir);
	    ent != NULL;
	    ent = readdir(dir)
	)
	{
	    ent_name = ent->d_name;

	    /* Skip directory entries that are not process ID numbers */
	    if(!isdigit(*ent_name))
		continue;

	    /* Format full path to the link that specifies the
	     * processes' name
	     */
	    g_snprintf(
		full_path, sizeof(full_path),
		"/proc/%s/exe",
		ent_name
	    );

	    /* Get the link value which specifies the processes' name */
	    bytes_read = readlink(full_path, link_val, sizeof(link_val));
	    if(bytes_read <= 0)
		continue;
	    if(bytes_read < sizeof(link_val))
		link_val[bytes_read] = '\0';
	    else
		link_val[sizeof(link_val) - 1] = '\0';

	    /* Get the name portion of the link's value */
	    proc_name = strrchr(link_val, '/');
	    if(proc_name != NULL)
		proc_name++;
	    else
		proc_name = link_val;

	    /* Does the processes' name match the specified name? */
	    if(!strcmp(proc_name, name))
	    {
		/* Get the directory entry name as the process ID */
		pid = ATOI(ent_name);
		break;
	    }
	}

	closedir(dir);

	return(pid);
}


/*
 *	Instructs the current running process of IceWM to reload the
 *	menu configuration.
 */
static gint WinWMReloadIceWM(win_struct *win)
{
	gint p = WinWMReloadGetPIDFromName("icewm");
	if(p <= 0)
	    return(-1);

	kill(p, SIGHUP);

	return(0);
}


/*
 *	Instructs the Window Manager to reload the configuration in
 *	order to realize the changes to the menu configuration.
 */
gint WinWMReload(win_struct *win)
{
	gint status = -1;

	if(win == NULL)
	    return(status);

	switch(win->format)
	{
	  case MENU_FORMAT_ENDEAVOUR2:
	    status = -2;
	    break;

	  case MENU_FORMAT_ICEWM:
	    status = WinWMReloadIceWM(win);
	    break;
	}

	return(status);
}
