/*
			  Image Thumbs List
 */

#ifndef TLIST_H
#define TLIST_H

#include <gtk/gtk.h>


/*
 *	Flags:
 */
typedef enum {
	TLIST_HORIZONTAL		= (1 << 0),	/* Tile thumbs horizontally */
	TLIST_DOUBLE_BUFFER		= (1 << 1),	/* Use double buffer */
	TLIST_SHOW_THUMB_FRAMES		= (1 << 2),	/* Show Thumb Frames */
 	TLIST_SHOW_THUMB_LABELS		= (1 << 3),	/* Show Thumb Labels */
	TLIST_SHOW_TEXTTIPS		= (1 << 4)	/* Show Texttips */
} tlist_flags;

/*
 *	Load States:
 */
typedef enum {
	TLIST_LOAD_STATE_NOT_LOADED,
	TLIST_LOAD_STATE_LOADED,
	TLIST_LOAD_STATE_FAILED
} tlist_load_state;


typedef struct _tlist_thumb_struct	tlist_thumb_struct;
typedef struct _tlist_struct		tlist_struct;


/*
 *	Thumb:
 */
struct _tlist_thumb_struct {

	tlist_load_state	load_state;

	gchar		*text;
	GdkPixmap	*pixmap;
	GdkBitmap	*mask;
	GtkVisibility	text_visibility;

	gulong		loaded_time;	/* In systime seconds */

	gpointer	data;		/* User data */

	/* Destroy Callback */
	void		(*destroy_cb)(
		gpointer		/* Data */
	);

};
#define TLIST_THUMB(p)		((tlist_thumb_struct *)(p))


/*
 *	Thumbs List:
 */
struct _tlist_struct {

	GtkWidget	*toplevel;
	gboolean	map_state;
	gint		freeze_count;
	tlist_flags	flags;

	GdkGC		*gc,
			*selection_gc;

	GtkWidget	*list_da,
			*vsb,
			*hsb;

	GdkPixmap	*list_pm;

	GtkAdjustment	*vadj,
			*hadj;

	gint		focus_thumb,
			pointer_over_thumb;
	GtkSelectionMode	selection_mode;
	GList		*selection,		/* Selected thumbs */
			*selection_end;

	/* List of loaded thumbs */
	tlist_thumb_struct	**thumb;
	gint			total_thumbs;

	/* Geometry */
	gint		thumb_width,	/* Size of each thumb */
			thumb_height;
	gint		thumb_border;	/* Padding between a thumb's contents
					 * and its frame */
	gint		thumbs_per_line;/* Thumbs visible on one line */

	/* Callbacks */
	gpointer	client_data;
	void	(*select_cb)(
		gpointer,		/* TList */
		GdkEventButton *,	/* Button Event */
		gint,			/* Thumb */
		gpointer		/* Data */
	);
	void	(*unselect_cb)(
		gpointer,		/* TList */
		GdkEventButton *,	/* Button Event */
		gint,			/* Thumb */
		gpointer		/* Data */
	);

};
#define TLIST(p)	((tlist_struct *)(p))


/* Misc */
extern void TListQueryThumbPixmapSize(
	tlist_struct *tlist,
	gint img_width, gint img_height,
	gint *width, gint *height
);


/* Drawing */
extern void TListDraw(tlist_struct *tlist);
extern void TListQueueDraw(tlist_struct *tlist);


/* Resize */
extern void TListResize(tlist_struct *tlist, gint width, gint height);


/* Freeze/Thaw */
extern void TListFreeze(tlist_struct *tlist);
extern void TListThaw(tlist_struct *tlist);


/* Thumbs Add, Set, and Delete */
extern gint TListInsert(tlist_struct *tlist, gint thumb_num, const gchar *text);
extern gint TListAppend(tlist_struct *tlist, const gchar *text);
extern void TListSetLoadState(
	tlist_struct *tlist, gint thumb_num,
	tlist_load_state load_state
);
extern void TListSetText(
	tlist_struct *tlist, gint thumb_num,
	const gchar *text
);
extern void TListSetPixmap(
	tlist_struct *tlist, gint thumb_num,
	GdkPixmap *pixmap, GdkBitmap *mask
);
extern void TListSetRGBA(
	tlist_struct *tlist, gint thumb_num,
	gint width, gint height,        /* Of image data */
	gint bpl,                       /* Bytes per line, can be -1 */
	GdkRgbDither dith,
	const guint8 *rgba,
	gboolean no_enlarge		/* Do not upscale if image smaller
					 * than thumb */
);
extern void TListSetThumbData(
	tlist_struct *tlist, gint thumb_num,
	gpointer data
);
extern void TListSetThumbDataFull(
	tlist_struct *tlist, gint thumb_num,
	gpointer data,
	void (*destroy_cb)(gpointer)
);

extern void TListRemove(tlist_struct *tlist, gint thumb_num);
extern void TListClear(tlist_struct *tlist);

/* Thumbs Get */
extern tlist_load_state TListGetLoadState(tlist_struct *tlist, gint thumb_num);
extern gboolean TListGetText(
        tlist_struct *tlist, gint thumb_num, gchar **text
);
extern gboolean TListGetPixmap(
	tlist_struct *tlist, gint thumb_num,
	GdkPixmap **pixmap, GdkBitmap **mask
);
extern gpointer TListGetThumbData(tlist_struct *tlist, gint thumb_num);

/* Thumbs Find */
extern gint TListFindThumbFromData(tlist_struct *tlist, gpointer data);

/* Selecting */
extern void TListSelectThumb(tlist_struct *tlist, gint thumb_num);
extern void TListUnselectThumb(tlist_struct *tlist, gint thumb_num);
extern void TListSelectAll(tlist_struct *tlist);
extern void TListUnselectAll(tlist_struct *tlist);

extern gboolean TListGetSelection(
	tlist_struct *tlist, gint x, gint y,
	gint *thumb_num, gint *thumb_ix, gint *thumb_iy
);
extern gboolean TListGetPosition(
	tlist_struct *tlist, gint thumb_num,
	gint *x, gint *y
);


/* Visibility */
extern GtkVisibility TListIsThumbVisible(tlist_struct *tlist, gint thumb_num);


/* Scrolling */
extern void TListMoveTo(
	tlist_struct *tlist, gint thumb_num, gfloat coeff
);


/* Thumbs List */
extern tlist_struct *TListNew(
	gboolean horizontal,
	gint thumb_width, gint thumb_height, gint thumb_border,
	gpointer client_data,
	void (*select_cb)(gpointer, GdkEventButton *, gint, gpointer),
	void (*unselect_cb)(gpointer, GdkEventButton *, gint, gpointer)
);
extern void TListThumbGeometry(
	tlist_struct *tlist,
	gint thumb_width, gint thumb_height, gint thumb_border
);
extern void TListSelectionMode(
	tlist_struct *tlist, GtkSelectionMode selection_mode
);
extern void TListDoubleBuffer(tlist_struct *tlist, gboolean double_buffer);
extern void TListOrientation(tlist_struct *tlist, gboolean horizontal);
extern void TListShowThumbFrames(tlist_struct *tlist, gboolean show);
extern void TListShowThumbLabels(tlist_struct *tlist, gboolean show);
extern void TListShowTextTips(tlist_struct *tlist, gboolean show);
extern void TListMap(tlist_struct *tlist);
extern void TListUnmap(tlist_struct *tlist);
extern void TListDelete(tlist_struct *tlist);


#endif	/* TLIST_H */
