/*
 * GQview
 * (C) 2002 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#ifndef SIMILAR_H
#define SIMILAR_H


typedef struct _ImageSimilarityData ImageSimilarityData;
struct _ImageSimilarityData
{
        guint8 avg_r[1024];
        guint8 avg_g[1024];
        guint8 avg_b[1024];

        gint filled;
};


ImageSimilarityData *image_sim_new(void);
void image_sim_free(ImageSimilarityData *sd);

void image_sim_fill_data(ImageSimilarityData *sd, GdkPixbuf *pixbuf);
ImageSimilarityData *image_sim_new_from_pixbuf(GdkPixbuf *pixbuf);

gfloat image_sim_compare(ImageSimilarityData *a, ImageSimilarityData *b);
gfloat image_sim_compare_fast(ImageSimilarityData *a, ImageSimilarityData *b, gfloat min);


#endif

