/*
                            Win
 */
#ifndef WIN_H
#define WIN_H

#include <gtk/gtk.h>
#include "toolbar.h"
#include "obj.h"


typedef struct _win_struct              win_struct;
typedef struct _win_opid_struct         win_opid_struct;


/*
 *	Menu Formats:
 */
typedef enum {
	MENU_FORMAT_ENDEAVOUR2,
	MENU_FORMAT_ICEWM
} menu_format;

/*
 *	Menu Icon Size:
 */
typedef enum {
	MENU_ICON_SIZE_MINI,		/* 16x16 */
	MENU_ICON_SIZE_SMALL,		/* 20x20 */
	MENU_ICON_SIZE_SMALL_MEDIUM,	/* 24x24 */
	MENU_ICON_SIZE_MEDIUM,		/* 32x32 */
	MENU_ICON_SIZE_MEDIUM_LARGE,	/* 40x40 */
	MENU_ICON_SIZE_LARGE,		/* 48x48 */
	MENU_ICON_SIZE_XLARGE		/* 64x64 */
} menu_icon_size;


/*
 *	List Columns:
 */
#define WIN_TREE_COLUMNS		1
#define WIN_LIST_COLUMNS		4


/*
 *	Operation IDs:
 */
typedef enum {

	WIN_OPID_SEPARATOR				= 10,

	WIN_OPID_NEW_ITEM				= 50,
	WIN_OPID_NEW_SEPARATOR				= 51,
	WIN_OPID_NEW_GROUP				= 52,

	WIN_OPID_OPEN_ITEM				= 70,
	WIN_OPID_OPEN_MENUS				= 80,
	WIN_OPID_APPLY					= 85,
	WIN_OPID_SAVE					= 86,
	WIN_OPID_ALWAYS_APPLY_ON_CLOSE			= 87,
	WIN_OPID_REVERT					= 88,
	WIN_OPID_CLOSE					= 100,

	WIN_OPID_CUT					= 210,
	WIN_OPID_COPY					= 211,
	WIN_OPID_PASTE					= 212,
	WIN_OPID_RENAME					= 220,
	WIN_OPID_DELETE					= 250,
	WIN_OPID_SELECT_ALL				= 270,
	WIN_OPID_UNSELECT_ALL				= 271,
	WIN_OPID_INVERT_SELECTION			= 272,
	WIN_OPID_PROPERTIES				= 290,

	WIN_OPID_REFRESH				= 300,
	WIN_OPID_VIEW_TOOLBAR				= 310,
	WIN_OPID_VIEW_STATUSBAR				= 311,

	WIN_OPID_NEW_MENU_EDITOR			= 600,

	WIN_OPID_HELP_CONTENTS				= 1000,
	WIN_OPID_ABOUT					= 1100

} win_opid;


/*
 *	Win:
 */
struct _win_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count,
			freeze_count;
	gpointer	core;

	GList		*opid;

	GtkWidget	*main_vbox;

	gboolean	menubar_map_state;
	GtkWidget	*menubar_handle,
			*menubar;

	GtkWidget	*file_mlabel,
			*new_mi,
			*new_menu,
			*new_item_mi,
			*new_separator_mi,
			*new_group_mi,
			*open_item_mi,
			*open_menus_mi,
			*apply_mi,
			*save_mi,
			*always_apply_on_close_micheck,
			*revert_mi,
			*close_mi,

			*edit_mlabel,
			*cut_mi,
			*copy_mi,
			*paste_mi,
			*rename_mi,
			*delete_mi,
			*select_all_mi,
			*unselect_all_mi,
			*invert_selection_mi,
			*properties_mi,

			*view_mlabel,
			*refresh_mi,
			*view_toolbar_micheck,
			*view_statusbar_micheck,

			*windows_mlabel,
			*windows_new_menu_editor_mi,

			*help_mlabel,
			*help_contents_mi,
			*about_mi;

	gboolean	toolbar_map_state;
	GtkWidget	*toolbar_handle;
	toolbar_struct	*toolbar;

	GtkWidget	*lists_paned,
			*clist,
			*ctree;

	gboolean	statusbar_map_state;
	GtkWidget	*statusbar;
	GtkWidget	*statusbar_progress,
			*statusbar_label;
	gfloat		statusbar_progress_last;

	GtkWidget	*lists_menu,		/* Right click menu */
			*lists_menu_open_item_mi,
                        *lists_menu_cut_mi,
                        *lists_menu_copy_mi,
                        *lists_menu_paste_mi,
			*lists_menu_rename_mi,
                        *lists_menu_delete_mi,
                        *lists_menu_select_all_mi,
                        *lists_menu_unselect_all_mi,
                        *lists_menu_invert_selection_mi,
 			*lists_menu_properties_mi;

	menu_format	format;
	gchar		*filename;		/* Current opened menu
						 * configuration file */
	gboolean	read_only;		/* Menu configuration file
						 * is read only */
	GList		*icon_paths;
	obj_struct	*obj_menu_toplevel,
			*obj_tool_bar_toplevel;

	gboolean	always_apply_on_close;
};
#define WIN(p)		((win_struct *)(p))


/*
 *      Win Operation ID:
 */
struct _win_opid_struct {

	win_opid	id;
	win_struct	*win;        

	gboolean	allow_multiple;
	toolbar_item_type	item_type;

	gchar		*button_name,
			*menu_name,
			*tooltip;

	guint		accel_key,
			accel_mods;

	guint8		**button_icon_data,	/* Shared */
			**menu_icon_data;	/* Shared */

	void (*func_cb)(
		GtkWidget *,		/* GtkWidget */
		gpointer		/* Win */
	);
	gint (*enter_func_cb)(
		GtkWidget *,		/* GtkWidget */
		GdkEventCrossing *,	/* GdkEventCrossing */
		gpointer		/* OPID */
	);
	gint (*leave_func_cb)(
		GtkWidget *,		/* GtkWidget */
		GdkEventCrossing *,	/* GdkEventCrossing */
		gpointer		/* OPID */             
	);

};
#define WIN_OPID(p)		((win_opid_struct *)(p))


extern obj_struct *WinObjGetLinkObj(win_struct *win, obj_struct *obj);

extern win_opid_struct *WinOPIDNew(
	win_opid id, win_struct *win
);
extern void WinOPIDDelete(win_opid_struct *opid);
extern GList *WinOPIDListNew(win_struct *win);
extern void WinOPIDListDelete(GList *glist);
extern win_opid_struct *WinOPIDListFind(GList *glist, win_opid id);

extern win_struct *WinNew(gpointer core_ptr);
extern void WinSavePositions(win_struct *win);
extern void WinSetTitle(win_struct *win);
extern void WinUpdate(win_struct *win);
extern void WinSetBusy(win_struct *win, gboolean busy);
extern gboolean WinToolBarIsShown(win_struct *win);
extern void WinToolBarSetShow(win_struct *win, gboolean show);
extern void WinToolBarUpdateItems(win_struct *win);
extern gboolean WinStatusBarIsShown(win_struct *win);
extern void WinStatusBarSetShow(win_struct *win, gboolean show);
extern void WinStatusProgress(
	win_struct *win, gfloat val, gboolean allow_gtk_iteration
);
extern void WinStatusMessage(
	win_struct *win, const gchar *mesg, gboolean allow_gtk_iteration
);
extern gboolean WinIsMapped(win_struct *win);
extern void WinMap(win_struct *win);
extern void WinUnmap(win_struct *win);
extern void WinDelete(win_struct *win);


#endif	/* WIN_H */
