/*
                                    Icon Selector
 */

#ifndef ICONSEL_H
#define ICONSEL_H

#include <gtk/gtk.h>


/*
 *      Button Flags:
 */
typedef enum {
        ICON_SEL_BTNFLAG_OK		= (1 << 1),
        ICON_SEL_BTNFLAG_CANCEL		= (1 << 2),
        ICON_SEL_BTNFLAG_HELP		= (1 << 3)   
} icon_sel_btn_flags;


extern gint IconSelInit(gpointer imlib_h);
extern void IconSelSetStyle(GtkRcStyle *rc_style);
extern void IconSelSetTransientFor(GtkWidget *w);
extern gboolean IconSelIsQuery(void);
extern void IconSelBreakQuery(void);
extern GtkWidget *IconSelGetToplevel(void);

extern gchar **IconSelGetResponse(
        const gchar *title,
        const gchar *location,			/* Initial location */
        GList *locations_list,			/* List of gchar * locations */
        const gchar *ok_label,
        const gchar *cancel_label,
        icon_sel_btn_flags show_buttons,	/* Any of ICON_SEL_BTNFLAG_* */
        icon_sel_btn_flags default_button,	/* One of ICON_SEL_BTNFLAG_* */
	gint list_width, gint list_height,
	gint thumb_width, gint thumb_height, gint thumb_border,
	gboolean horizontal,
	gboolean show_frames,
	gboolean show_labels,
        gint *nvalues
);

extern void IconSelShutdown(void);


#endif	/* ICONSEL_H */
