/* vcapture
 * Simple X-Window screen capture, made for vdesk
 * The core of this code were taken from imlib1 tutorial
 * 
 * (c) Eko M. Budi, 2004
 * Released under GNU GPL License
 */
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>
#include <Imlib.h>

int main(int argc, char **argv)
{
    Display *disp;
    ImlibData *id;
    XSetWindowAttributes attr;
    Window win, root;
    ImlibImage *im;
    Pixmap p,m;
    int i,w,h;
    int delay=5;
    int show=0;
    char fname[512]="xcapture.png";
    char fext[8]=".png";
    char fnum[8];
    char *s;
    struct stat statbuf;
/* Be nice and tell the user if they don't, to provide a file as an arg */
    if (argc<=1)
      {
	printf("vcapture - capture X-Window screen.\n"
	"Usage:\n%s [-d <seconds>] [-s] image_file\n",argv[0]);
	exit(1);
      }

/* Parse options */
    for (i=1; i<argc; i++) {
	if (argv[i][0] == '-') {
	    switch (argv[i][1]) {
		case 'd' :
		    delay=atoi(argv[i+1]);
		    if (delay<0) {
			delay=1;
		    }
		    i++;
		    break;  
		case 's' :
		    show = 1;
		    break;
	    }
	}
	else {
	    strcpy(fname,argv[i]);
	}
    }
/* file extension sanitation */
    if (strlen(fname) >= sizeof(fname)-4) {
	printf("ERROR: filename too long\n");
	exit(1);
    }
    s=strrchr(fname, '.');
    if (s) {
	strncpy(fext,s,sizeof(fext));
    }
    else {
	s=fname+strlen(fname);
	strcat(fname, fext);
    }
/* if file is exist, add number */
   for (i=1; stat (fname,&statbuf) == 0; i++) {
	if (i>9999) {
	    printf("WARNING: %s will be overwritten !", fname);
	    break;
	}
	*s=0;
	sprintf(fnum,"-%04d",i);
	strcat(strcat(fname,fnum),fext);
   }
/* sleep a while */
   printf("Ready to capture in %d seconds\n", delay);
   sleep(delay);
   
/* Connect to the default Xserver */
   disp=XOpenDisplay(NULL);
   w = WidthOfScreen( DefaultScreenOfDisplay( disp ) );
   h = HeightOfScreen( DefaultScreenOfDisplay( disp ) );
   root = DefaultRootWindow( disp );

/* Immediately afterwards Intitialise Imlib */
   id=Imlib_init(disp);

/* Load the image specified as the first argument */
/*   im=Imlib_load_image(id,fname); */
/* capture screen */
   im = Imlib_create_image_from_drawable(id, root, 0, 0, 0, w, h );
   
/* save */
   Imlib_save_image( id, im, fname, NULL );
   printf("Snapshot has been saved as %s\007\n", fname);

/* if not show, quit immediatelly */
   if (!show) {
	Imlib_kill_image(id, im);
	exit(0);
   }

/* Scale the image for displaying */
   w=im->rgb_width/2;h=im->rgb_height/2;

/* Create a Window to display in */
   win=XCreateWindow(disp,DefaultRootWindow(disp),0,0,w,h,0,id->x.depth,
		     InputOutput,id->x.visual,0,&attr);
   XmbSetWMProperties(disp, win, fname, fname, NULL, 0, NULL, NULL, NULL);

   XSelectInput(disp,win,StructureNotifyMask);
/* Render the original 24-bit Image data into a pixmap of size w * h */
   Imlib_render(id,im,w,h);
/* Extract the Image and mask pixmaps from the Image */
   p=Imlib_move_image(id,im);
/* The mask will be 0 if the image has no transparency */
   m=Imlib_move_mask(id,im);
/* Put the Image pixmap in the background of the window */
   XSetWindowBackgroundPixmap(disp,win,p);
/* If there was a mask to the image, set the Image's mask to it */
   if (m) XShapeCombineMask(disp,win,ShapeBounding,0,0,m,ShapeSet);
/* Actually display the window */
   XMapWindow(disp,win);
/* Synchronise with the Xserver */
   XSync(disp,False);

/* Event loop to handle resizes and close */
   Atom wm_delete_window = XInternAtom(disp, "WM_DELETE_WINDOW", False);
   XSetWMProtocols(disp, win, &wm_delete_window, 1);
   for(;;)
     {
       XEvent ev;
     
/* Sit and wait for an event to happen */ 
       XNextEvent(disp,&ev);
       switch (ev.type) {
	case ConfigureNotify:
	   w=ev.xconfigure.width;h=ev.xconfigure.height;
/* Re-render the Image to the new size */ 
	   Imlib_render(id,im,w,h);
/* Free the previous pixmap used for the window - note ONLY the pixmap is */
/* freed - the mask is marked automatically to be freed along with the */
/* pixmap. There is no need to free it as well - in fact it is advised you do */
/* not. You must use the Imlib free function because of Imlib's caching. Do */
/* not use any other free functions. You can use this function for Pixmaps */
/* not created by Imlib - and it will just go free them as expected. */
	   Imlib_free_pixmap(id,p);
	   p=Imlib_move_image(id,im);
/* The mask will be 0 if the image has no transparency */
	   m=Imlib_move_mask(id,im);
/* Put the Image pixmap in the background of the window */
	   XSetWindowBackgroundPixmap(disp,win,p);
/* If there was a mask to the image, set the Image's mask to it */
	   if (m) XShapeCombineMask(disp,win,ShapeBounding,0,0,m,ShapeSet);
/* Clear the window to update the background change */
	   XClearWindow(disp,win);
/* Synchronise with the Xserver */
	   XSync(disp,False);
	   break;
	case ClientMessage:
/* Close */
	    Imlib_free_pixmap(id,p);
	    Imlib_kill_image(id, im);
	    exit (0);
	    break;
	}
     }
}
